/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import java.util.Enumeration;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.properties.PropertyHelper;
import org.exolab.jmscts.test.message.util.PropertyValues;

public class IdentifierTest
extends AbstractMessageTestCase
implements PropertyValues {
    private static final String[] VALID_IDENTIFIERS = new String[]{"A", "_A", "$A", "a1", "_a1", "$a1", "a_a", "a$a", "Aa\u0391\u0430\u0301"};
    private static final String[] INVALID_IDENTIFIERS = new String[]{null, "1", "+1", "-1", "'1'", "a.b", "0"};
    private static final String[] RESERVED = new String[]{"NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE"};
    private static final String[] JMSX_PROVIDER_IDENTIFIERS = new String[]{"JMSXUserID", "JMSXAppID", "JMSXDeliveryCount", "JMSXProducerTXID", "JMSXConsumerTXID", "JMSXRcvTimestamp", "JMSXState"};

    public IdentifierTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(IdentifierTest.class);
    }

    public void testValidIdentifiers() throws Exception {
        this.checkIdentifiers(VALID_IDENTIFIERS, false);
    }

    public void testInvalidIdentifiers() throws Exception {
        this.checkIdentifiers(INVALID_IDENTIFIERS, true);
    }

    public void testIdentifierCase() throws Exception {
        String upper = "ABC";
        String lower = "ABC".toLowerCase();
        TestContext context = this.getContext();
        Message message = context.getMessage();
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            for (int j = 0; j < ALL_VALUES[i].length; ++j) {
                message.setObjectProperty("ABC", ALL_VALUES[i][j]);
                if (message.getObjectProperty(lower) != null) {
                    IdentifierTest.fail((String)"getObjectProperty() is not treating names as being case sensitive");
                }
                message.setObjectProperty("ABC", null);
                message.setObjectProperty(lower, ALL_VALUES[i][j]);
                if (message.getObjectProperty("ABC") != null) {
                    IdentifierTest.fail((String)"getObjectProperty() is not treating names as being case sensitive");
                }
                message.setObjectProperty(lower, null);
            }
        }
    }

    public void testReservedWords() throws Exception {
        this.checkIdentifiers(RESERVED, true);
        this.checkIdentifiers(this.toLowerCase(RESERVED), true);
    }

    public void testJMSXProviderIdentifiers() throws Exception {
        TestContext context = this.getContext();
        ConnectionMetaData metaData = context.getConnection().getMetaData();
        Enumeration iter = metaData.getJMSXPropertyNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            for (int i = 0; i < JMSX_PROVIDER_IDENTIFIERS.length; ++i) {
                if (!name.equals(JMSX_PROVIDER_IDENTIFIERS[i])) continue;
                this.checkIdentifiers(new String[]{name}, true);
            }
        }
    }

    private void checkIdentifiers(String[] identifiers, boolean fail) throws Exception {
        for (int i = 0; i < identifiers.length; ++i) {
            String identifier = identifiers[i];
            for (int j = 0; j < ALL_VALUES.length; ++j) {
                Object[] values = ALL_VALUES[j];
                for (int k = 0; k < values.length; ++k) {
                    Object value = values[k];
                    if (fail) {
                        this.expectFailure(identifier, value);
                        continue;
                    }
                    this.expectSuccess(identifier, value);
                }
            }
        }
    }

    private void expectSuccess(String identifier, Object value) throws Exception {
        Message message = this.getContext().getMessage();
        message.setObjectProperty(identifier, value);
        PropertyHelper.setPrimitiveProperty(message, identifier, value);
    }

    private void expectFailure(String identifier, Object value) throws Exception {
        String packagePrefix = "java.lang.";
        Message message = this.getContext().getMessage();
        try {
            PropertyHelper.setPrimitiveProperty(message, identifier, value);
            String type = value.getClass().getName();
            if (type.startsWith(packagePrefix)) {
                type = type.substring(packagePrefix.length());
            }
            String method = "set" + type + "Property()";
            IdentifierTest.fail((String)("Expected " + method + " to fail for invalid identifier=" + identifier + ", value=" + value));
        }
        catch (JMSException expected) {
            // empty catch block
        }
        try {
            message.setObjectProperty(identifier, value);
            IdentifierTest.fail((String)("Expected setObjectProperty() to fail for invalid identifier=" + identifier + ", value=" + value));
        }
        catch (JMSException expected) {
            // empty catch block
        }
    }

    private String[] toLowerCase(String[] strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = strings[i].toLowerCase();
        }
        return result;
    }
}

