/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.ClassHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.PropertyValues;

public class PropertyConversionTest
extends AbstractMessageTestCase
implements PropertyValues {
    private static final Class[] INVALID_BOOLEANS = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] INVALID_BYTES = new Class[]{Boolean.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] INVALID_SHORTS = new Class[]{Boolean.TYPE, Byte.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] INVALID_INTS = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] INVALID_LONGS = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] INVALID_FLOATS = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE};
    private static final Class[] INVALID_DOUBLES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE};
    static /* synthetic */ Class class$javax$jms$MessageFormatException;

    public PropertyConversionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(PropertyConversionTest.class);
    }

    public void testBoolean() throws Exception {
        String name = "boolean";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < BOOLEANS.length; ++i) {
            boolean value = BOOLEANS[i];
            message.setObjectProperty("boolean", (Object)BOOLEANS[i]);
            Boolean property = (Boolean)message.getObjectProperty("boolean");
            PropertyConversionTest.assertEquals((boolean)value, (boolean)property);
            message.setBooleanProperty("boolean", value);
            PropertyConversionTest.assertEquals((boolean)value, (boolean)message.getBooleanProperty("boolean"));
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("boolean") instanceof Boolean));
            property = (Boolean)message.getObjectProperty("boolean");
            PropertyConversionTest.assertEquals((boolean)value, (boolean)property);
            String str = message.getStringProperty("boolean");
            PropertyConversionTest.assertEquals((boolean)value, (boolean)Boolean.valueOf(str));
            for (int j = 0; j < INVALID_BOOLEANS.length; ++j) {
                this.expectException("boolean", Boolean.TYPE, INVALID_BOOLEANS[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testByte() throws Exception {
        String name = "byte";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < BYTES.length; ++i) {
            byte value = BYTES[i];
            message.setObjectProperty("byte", (Object)BYTES[i]);
            PropertyConversionTest.assertEquals((byte)value, (byte)((Byte)message.getObjectProperty("byte")));
            message.setByteProperty("byte", value);
            PropertyConversionTest.assertEquals((byte)value, (byte)message.getByteProperty("byte"));
            PropertyConversionTest.assertEquals((short)value, (short)message.getShortProperty("byte"));
            PropertyConversionTest.assertEquals((int)value, (int)message.getIntProperty("byte"));
            PropertyConversionTest.assertEquals((long)value, (long)message.getLongProperty("byte"));
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("byte") instanceof Byte));
            PropertyConversionTest.assertEquals((byte)value, (byte)((Byte)message.getObjectProperty("byte")));
            String str = message.getStringProperty("byte");
            PropertyConversionTest.assertEquals((byte)value, (byte)Byte.parseByte(str));
            for (int j = 0; j < INVALID_BYTES.length; ++j) {
                this.expectException("byte", Byte.TYPE, INVALID_BYTES[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testShort() throws Exception {
        String name = "short";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < SHORTS.length; ++i) {
            short value = SHORTS[i];
            message.setObjectProperty("short", (Object)SHORTS[i]);
            PropertyConversionTest.assertEquals((short)value, (short)((Short)message.getObjectProperty("short")));
            message.setShortProperty("short", value);
            PropertyConversionTest.assertEquals((short)value, (short)message.getShortProperty("short"));
            PropertyConversionTest.assertEquals((int)value, (int)message.getIntProperty("short"));
            PropertyConversionTest.assertEquals((long)value, (long)message.getLongProperty("short"));
            String str = message.getStringProperty("short");
            PropertyConversionTest.assertEquals((short)value, (short)Short.parseShort(str));
            for (int j = 0; j < INVALID_SHORTS.length; ++j) {
                this.expectException("short", Short.TYPE, INVALID_SHORTS[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testInt() throws Exception {
        String name = "int";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < INTS.length; ++i) {
            int value = INTS[i];
            message.setObjectProperty("int", (Object)INTS[i]);
            PropertyConversionTest.assertTrue(((Integer)message.getObjectProperty("int") == value ? 1 : 0) != 0);
            message.setIntProperty("int", value);
            PropertyConversionTest.assertEquals((int)value, (int)message.getIntProperty("int"));
            PropertyConversionTest.assertEquals((long)value, (long)message.getLongProperty("int"));
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("int") instanceof Integer));
            PropertyConversionTest.assertEquals((int)value, (int)((Integer)message.getObjectProperty("int")));
            String str = message.getStringProperty("int");
            PropertyConversionTest.assertEquals((int)value, (int)Integer.parseInt(str));
            for (int j = 0; j < INVALID_INTS.length; ++j) {
                this.expectException("int", Integer.TYPE, INVALID_INTS[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testLong() throws Exception {
        String name = "long";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < LONGS.length; ++i) {
            long value = LONGS[i];
            message.setObjectProperty("long", (Object)LONGS[i]);
            PropertyConversionTest.assertEquals((long)value, (long)((Long)message.getObjectProperty("long")));
            message.setLongProperty("long", value);
            PropertyConversionTest.assertEquals((long)value, (long)message.getLongProperty("long"));
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("long") instanceof Long));
            PropertyConversionTest.assertEquals((long)value, (long)((Long)message.getObjectProperty("long")));
            String str = message.getStringProperty("long");
            PropertyConversionTest.assertEquals((long)value, (long)Long.parseLong(str));
            for (int j = 0; j < INVALID_LONGS.length; ++j) {
                this.expectException("long", Long.TYPE, INVALID_LONGS[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testFloat() throws Exception {
        String name = "float";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < FLOATS.length; ++i) {
            float value = FLOATS[i].floatValue();
            message.setObjectProperty("float", (Object)FLOATS[i]);
            this.checkFloat("float", value);
            message.setFloatProperty("float", value);
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("float") instanceof Float));
            this.checkFloat("float", value);
            String str = message.getStringProperty("float");
            if (str.equals(Float.toString(Float.NaN))) {
                PropertyConversionTest.assertTrue((boolean)Float.isNaN(value));
            } else if (str.equals(Float.toString(Float.NEGATIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((value == Float.NEGATIVE_INFINITY ? 1 : 0) != 0);
            } else if (str.equals(Float.toString(Float.POSITIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((value == Float.POSITIVE_INFINITY ? 1 : 0) != 0);
            } else {
                PropertyConversionTest.assertTrue((Float.parseFloat(str) == FLOATS[i].floatValue() ? 1 : 0) != 0);
            }
            for (int j = 0; j < INVALID_FLOATS.length; ++j) {
                this.expectException("float", Float.TYPE, INVALID_FLOATS[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testDouble() throws Exception {
        String name = "double";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < DOUBLES.length; ++i) {
            double value = DOUBLES[i];
            message.setObjectProperty("double", (Object)DOUBLES[i]);
            this.checkDouble("double", value);
            message.setDoubleProperty("double", value);
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("double") instanceof Double));
            this.checkDouble("double", value);
            String str = message.getStringProperty("double");
            if (str.equals(Double.toString(Double.NaN))) {
                PropertyConversionTest.assertTrue((boolean)Double.isNaN(value));
            } else if (str.equals(Double.toString(Double.NEGATIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((value == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
            } else if (str.equals(Double.toString(Double.POSITIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((value == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
            } else {
                PropertyConversionTest.assertTrue((Double.parseDouble(str) == value ? 1 : 0) != 0);
            }
            for (int j = 0; j < INVALID_DOUBLES.length; ++j) {
                this.expectException("double", Double.TYPE, INVALID_DOUBLES[j], class$javax$jms$MessageFormatException == null ? PropertyConversionTest.class$("javax.jms.MessageFormatException") : class$javax$jms$MessageFormatException);
            }
        }
    }

    public void testStringObject() throws Exception {
        String name = "stringObject";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < STRINGS.length; ++i) {
            message.setObjectProperty("stringObject", (Object)STRINGS[i]);
            PropertyConversionTest.assertTrue((boolean)((String)message.getObjectProperty("stringObject")).equals(STRINGS[i]));
            message.setStringProperty("stringObject", STRINGS[i]);
            PropertyConversionTest.assertEquals((String)STRINGS[i], (String)message.getStringProperty("stringObject"));
            PropertyConversionTest.assertTrue((boolean)(message.getObjectProperty("stringObject") instanceof String));
            PropertyConversionTest.assertEquals((Object)STRINGS[i], (Object)message.getObjectProperty("stringObject"));
        }
        message.setObjectProperty("stringObject", null);
        PropertyConversionTest.assertNull((Object)message.getStringProperty("stringObject"));
    }

    public void testStringBoolean() throws Exception {
        String name = "stringBoolean";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < BOOLEANS.length; ++i) {
            String value = BOOLEANS[i].toString();
            message.setStringProperty("stringBoolean", value);
            PropertyConversionTest.assertEquals((String)value, (String)message.getStringProperty("stringBoolean"));
            PropertyConversionTest.assertEquals((boolean)BOOLEANS[i], (boolean)message.getBooleanProperty("stringBoolean"));
        }
        Object[][] invalidBooleans = new Object[][]{BYTES, SHORTS, INTS, LONGS, FLOATS, DOUBLES};
        for (int i = 0; i < invalidBooleans.length; ++i) {
            for (int j = 0; j < invalidBooleans[i].length; ++j) {
                String value = invalidBooleans[i][j].toString();
                message.setStringProperty("stringBoolean", value);
                PropertyConversionTest.assertFalse((boolean)message.getBooleanProperty("stringBoolean"));
            }
        }
    }

    public void testStringByte() throws Exception {
        String name = "stringByte";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < BYTES.length; ++i) {
            String value = BYTES[i].toString();
            message.setStringProperty("stringByte", value);
            PropertyConversionTest.assertEquals((String)value, (String)message.getStringProperty("stringByte"));
            PropertyConversionTest.assertEquals((byte)BYTES[i], (byte)message.getByteProperty("stringByte"));
        }
        Class[] invalidBytes = new Class[]{Boolean.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        this.expectConversionException(Byte.TYPE, invalidBytes, NumberFormatException.class);
    }

    public void testStringShort() throws Exception {
        String name = "stringShort";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < SHORTS.length; ++i) {
            String value = SHORTS[i].toString();
            message.setStringProperty("stringShort", value);
            PropertyConversionTest.assertEquals((String)value, (String)message.getStringProperty("stringShort"));
            PropertyConversionTest.assertEquals((short)SHORTS[i], (short)message.getShortProperty("stringShort"));
        }
        Class[] invalidShorts = new Class[]{Boolean.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        this.expectConversionException(Short.TYPE, invalidShorts, NumberFormatException.class);
    }

    public void testStringInt() throws Exception {
        String name = "stringInt";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < INTS.length; ++i) {
            String value = INTS[i].toString();
            message.setStringProperty("stringInt", value);
            PropertyConversionTest.assertEquals((String)value, (String)message.getStringProperty("stringInt"));
            PropertyConversionTest.assertEquals((int)INTS[i], (int)message.getIntProperty("stringInt"));
        }
        Class[] invalidInts = new Class[]{Boolean.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        this.expectConversionException(Integer.TYPE, invalidInts, NumberFormatException.class);
    }

    public void testStringLong() throws Exception {
        String name = "stringLong";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < LONGS.length; ++i) {
            String value = LONGS[i].toString();
            message.setStringProperty("stringLong", value);
            PropertyConversionTest.assertEquals((String)value, (String)message.getStringProperty("stringLong"));
            PropertyConversionTest.assertEquals((long)LONGS[i], (long)message.getLongProperty("stringLong"));
        }
        Class[] invalidLongs = new Class[]{Boolean.TYPE, Float.TYPE, Double.TYPE};
        this.expectConversionException(Long.TYPE, invalidLongs, NumberFormatException.class);
    }

    public void testStringFloat() throws Exception {
        String name = "stringFloat";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < FLOATS.length; ++i) {
            String value = FLOATS[i].toString();
            message.setStringProperty("stringFloat", value);
            PropertyConversionTest.assertTrue((boolean)message.getStringProperty("stringFloat").equals(value));
            if (value.equals(Float.toString(Float.NaN))) {
                PropertyConversionTest.assertTrue((boolean)FLOATS[i].isNaN());
                continue;
            }
            if (value.equals(Float.toString(Float.NEGATIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((FLOATS[i].floatValue() == Float.NEGATIVE_INFINITY ? 1 : 0) != 0);
                continue;
            }
            if (value.equals(Float.toString(Float.POSITIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((FLOATS[i].floatValue() == Float.POSITIVE_INFINITY ? 1 : 0) != 0);
                continue;
            }
            PropertyConversionTest.assertTrue((message.getFloatProperty("stringFloat") == FLOATS[i].floatValue() ? 1 : 0) != 0);
        }
        Class[] invalidFloats = new Class[]{Boolean.TYPE};
        this.expectConversionException(Float.TYPE, invalidFloats, NumberFormatException.class);
        for (int i = 0; i < DOUBLES.length; ++i) {
            double value = DOUBLES[i];
            if (value == Double.MAX_VALUE || value == Double.MIN_VALUE) {
                message.setStringProperty("stringFloat", DOUBLES[i].toString());
                if (value == Double.MIN_VALUE) {
                    if ((double)message.getFloatProperty("stringFloat") == 0.0) continue;
                    PropertyConversionTest.fail((String)("Expected string conversion from double to float to underflow for double=" + value + ", but got " + message.getFloatProperty("stringFloat")));
                    continue;
                }
                if (Float.isInfinite(message.getFloatProperty("stringFloat"))) continue;
                PropertyConversionTest.fail((String)("Expected string conversion from double to float to be infinite for double=" + value + ", but got " + message.getFloatProperty("stringFloat")));
                continue;
            }
            this.expectConversionException(Float.TYPE, new Double[]{DOUBLES[i]}, class$java$lang$NumberFormatException == null ? PropertyConversionTest.class$("java.lang.NumberFormatException") : class$java$lang$NumberFormatException);
        }
    }

    public void testStringDouble() throws Exception {
        String name = "stringDouble";
        Message message = this.getContext().getMessage();
        for (int i = 0; i < DOUBLES.length; ++i) {
            String value = DOUBLES[i].toString();
            message.setStringProperty("stringDouble", value);
            PropertyConversionTest.assertTrue((boolean)message.getStringProperty("stringDouble").equals(value));
            if (value.equals(Double.toString(Double.NaN))) {
                PropertyConversionTest.assertTrue((boolean)DOUBLES[i].isNaN());
                continue;
            }
            if (value.equals(Double.toString(Double.NEGATIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((DOUBLES[i] == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
                continue;
            }
            if (value.equals(Double.toString(Double.POSITIVE_INFINITY))) {
                PropertyConversionTest.assertTrue((DOUBLES[i] == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
                continue;
            }
            PropertyConversionTest.assertTrue((message.getDoubleProperty("stringDouble") == DOUBLES[i].doubleValue() ? 1 : 0) != 0);
        }
        Class[] invalidDoubles = new Class[]{Boolean.TYPE};
        this.expectConversionException(Double.TYPE, invalidDoubles, NumberFormatException.class);
    }

    public void testNullToPrimitive() throws Exception {
        String name = "nulltest";
        Message message = this.getContext().getMessage();
        message.setObjectProperty("nulltest", null);
        PropertyConversionTest.assertFalse((boolean)message.getBooleanProperty("nulltest"));
        this.expectException("nulltest", Byte.TYPE, Byte.TYPE, NumberFormatException.class);
        this.expectException("nulltest", Short.TYPE, Short.TYPE, NumberFormatException.class);
        this.expectException("nulltest", Integer.TYPE, Integer.TYPE, NumberFormatException.class);
        this.expectException("nulltest", Long.TYPE, Long.TYPE, NumberFormatException.class);
        this.expectException("nulltest", Float.TYPE, Float.TYPE, NullPointerException.class);
        this.expectException("nulltest", Double.TYPE, Double.TYPE, NullPointerException.class);
    }

    private void checkFloat(String name, float expected) throws Exception {
        Message message = this.getContext().getMessage();
        if (Float.isNaN(expected)) {
            PropertyConversionTest.assertTrue((boolean)Float.isNaN(message.getFloatProperty(name)));
            PropertyConversionTest.assertTrue((boolean)Double.isNaN(message.getDoubleProperty(name)));
            PropertyConversionTest.assertTrue((boolean)((Float)message.getObjectProperty(name)).isNaN());
        } else {
            PropertyConversionTest.assertTrue((message.getFloatProperty(name) == expected ? 1 : 0) != 0);
            PropertyConversionTest.assertTrue((message.getDoubleProperty(name) == (double)expected ? 1 : 0) != 0);
            PropertyConversionTest.assertTrue((((Float)message.getObjectProperty(name)).floatValue() == expected ? 1 : 0) != 0);
        }
    }

    private void checkDouble(String name, double expected) throws Exception {
        Message message = this.getContext().getMessage();
        if (Double.isNaN(expected)) {
            PropertyConversionTest.assertTrue((boolean)Double.isNaN(message.getDoubleProperty(name)));
            PropertyConversionTest.assertTrue((boolean)((Double)message.getObjectProperty(name)).isNaN());
        } else {
            PropertyConversionTest.assertTrue((message.getDoubleProperty(name) == expected ? 1 : 0) != 0);
            PropertyConversionTest.assertTrue(((Double)message.getObjectProperty(name) == expected ? 1 : 0) != 0);
        }
    }

    private void expectConversionException(Class primitive, Class[] classes, Class exceptionType) throws Exception {
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].equals(Boolean.TYPE)) {
                this.expectConversionException(primitive, BOOLEANS, exceptionType);
                continue;
            }
            if (classes[i].equals(Byte.TYPE)) {
                this.expectConversionException(primitive, BYTES, exceptionType);
                continue;
            }
            if (classes[i].equals(Short.TYPE)) {
                this.expectConversionException(primitive, SHORTS, exceptionType);
                continue;
            }
            if (classes[i].equals(Integer.TYPE)) {
                this.expectConversionException(primitive, INTS, exceptionType);
                continue;
            }
            if (classes[i].equals(Long.TYPE)) {
                this.expectConversionException(primitive, LONGS, exceptionType);
                continue;
            }
            if (classes[i].equals(Float.TYPE)) {
                this.expectConversionException(primitive, FLOATS, exceptionType);
                continue;
            }
            if (classes[i].equals(Double.TYPE)) {
                this.expectConversionException(primitive, DOUBLES, exceptionType);
                continue;
            }
            throw new Exception("Don't support " + classes[i].getName());
        }
    }

    private void expectConversionException(Class primitive, Object[] values, Class exceptionType) throws Exception {
        Message message = this.getContext().getMessage();
        for (int i = 0; i < values.length; ++i) {
            Class<?> type = values[i].getClass();
            String name = ClassHelper.getPrimitiveType(type).getName();
            message.setStringProperty(name, values[i].toString());
            this.expectException(name, class$java$lang$String == null ? PropertyConversionTest.class$("java.lang.String") : class$java$lang$String, primitive, exceptionType);
        }
    }

    private void expectException(String name, Class from, Class to, Class exceptionType) throws Exception {
        block19: {
            Message message = this.getContext().getMessage();
            try {
                if (to.equals(Boolean.TYPE)) {
                    message.getBooleanProperty(name);
                } else if (to.equals(Byte.TYPE)) {
                    message.getByteProperty(name);
                } else if (to.equals(Byte.TYPE)) {
                    message.getByteProperty(name);
                } else if (to.equals(Short.TYPE)) {
                    message.getShortProperty(name);
                } else if (to.equals(Integer.TYPE)) {
                    message.getIntProperty(name);
                } else if (to.equals(Long.TYPE)) {
                    message.getLongProperty(name);
                } else if (to.equals(Float.TYPE)) {
                    message.getFloatProperty(name);
                } else if (to.equals(Double.TYPE)) {
                    message.getDoubleProperty(name);
                } else if (to.equals(String.class)) {
                    message.getStringProperty(name);
                }
                Object value = message.getObjectProperty(name);
                String text = value == null ? "<null>" : value.toString();
                PropertyConversionTest.fail((String)("Conversion from " + from.getName() + "=" + text + " to " + to.getName() + " should fail"));
            }
            catch (Exception exception) {
                if (exception.getClass().equals(exceptionType)) break block19;
                Object value = message.getObjectProperty(name);
                String text = value == null ? "<null>" : value.toString();
                PropertyConversionTest.fail((String)("Conversion from " + from.getName() + "=" + text + " to " + to.getName() + " threw " + exception.getClass().getName() + " - it should throw " + exceptionType.getName()));
            }
        }
    }
}

