/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import javax.jms.Message;
import javax.jms.MessageFormatException;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.PropertyValues;

public class PropertyTypeTest
extends AbstractMessageTestCase
implements PropertyValues {
    public PropertyTypeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(PropertyTypeTest.class);
    }

    public void testPropertyTypes() throws Exception {
        int value;
        int i;
        Message message = this.getContext().getMessage();
        String name = "test";
        for (i = 0; i < BOOLEANS.length; ++i) {
            value = BOOLEANS[i].booleanValue();
            message.setBooleanProperty("test", value != 0);
            PropertyTypeTest.assertEquals(value != 0, (boolean)message.getBooleanProperty("test"));
        }
        for (i = 0; i < BYTES.length; ++i) {
            value = BYTES[i].byteValue();
            message.setByteProperty("test", (byte)value);
            PropertyTypeTest.assertEquals((byte)value, (byte)message.getByteProperty("test"));
        }
        for (i = 0; i < SHORTS.length; ++i) {
            value = SHORTS[i].shortValue();
            message.setShortProperty("test", (short)value);
            PropertyTypeTest.assertEquals((short)value, (short)message.getShortProperty("test"));
        }
        for (i = 0; i < INTS.length; ++i) {
            value = INTS[i];
            message.setIntProperty("test", value);
            PropertyTypeTest.assertEquals((int)value, (int)message.getIntProperty("test"));
        }
        for (i = 0; i < LONGS.length; ++i) {
            long value2 = LONGS[i];
            message.setLongProperty("test", value2);
            PropertyTypeTest.assertEquals((long)value2, (long)message.getLongProperty("test"));
        }
        for (i = 0; i < FLOATS.length; ++i) {
            float value3 = FLOATS[i].floatValue();
            message.setFloatProperty("test", value3);
            if (Float.isNaN(value3)) {
                PropertyTypeTest.assertTrue((boolean)Float.isNaN(message.getFloatProperty("test")));
                continue;
            }
            PropertyTypeTest.assertEquals((double)value3, (double)message.getFloatProperty("test"), (double)0.0);
        }
        for (i = 0; i < DOUBLES.length; ++i) {
            double value4 = DOUBLES[i];
            message.setDoubleProperty("test", value4);
            if (Double.isNaN(value4)) {
                PropertyTypeTest.assertTrue((boolean)Double.isNaN(message.getDoubleProperty("test")));
                continue;
            }
            PropertyTypeTest.assertEquals((double)value4, (double)message.getDoubleProperty("test"), (double)0.0);
        }
        for (i = 0; i < STRINGS.length; ++i) {
            String value5 = STRINGS[i];
            message.setStringProperty("test", value5);
            PropertyTypeTest.assertEquals((String)value5, (String)message.getStringProperty("test"));
        }
    }

    public void testObjectPropertyTypes() throws Exception {
        Message message = this.getContext().getMessage();
        String name = "test";
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            Object[] values = ALL_VALUES[i];
            for (int j = 0; j < values.length; ++j) {
                Object value = values[j];
                message.setObjectProperty("test", value);
                PropertyTypeTest.assertEquals(value.getClass(), message.getObjectProperty("test").getClass());
                if (value instanceof Float && ((Float)value).isNaN()) {
                    PropertyTypeTest.assertTrue((boolean)((Float)message.getObjectProperty("test")).isNaN());
                    continue;
                }
                if (value instanceof Double && ((Double)value).isNaN()) {
                    PropertyTypeTest.assertTrue((boolean)((Double)message.getObjectProperty("test")).isNaN());
                    continue;
                }
                PropertyTypeTest.assertEquals((Object)value, (Object)message.getObjectProperty("test"));
            }
        }
        message.setObjectProperty("test", null);
        PropertyTypeTest.assertEquals(null, (Object)message.getObjectProperty("test"));
        try {
            message.setObjectProperty("test", (Object)new Character('A'));
            PropertyTypeTest.fail((String)"Managed to set invalid object property");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }
}

