/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.readwrite;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageNotReadableException;
import javax.jms.StreamMessage;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageVerifier;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.EmptyMessageVerifier;
import org.exolab.jmscts.test.message.util.EmptyPropertyVerifier;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.MessagePropertyVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;
import org.exolab.jmscts.test.message.util.PropertyValues;

public class ReadWriteTest
extends AbstractMessageTestCase
implements PropertyValues {
    private static final Category log = Category.getInstance((Class)ReadWriteTest.class);

    public ReadWriteTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(ReadWriteTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testWriteableOnCreation() throws Exception {
        MessagePopulatorVerifier populator;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        try {
            populator = new MessagePropertyVerifier();
            ((MessagePropertyVerifier)populator).populate(message);
        }
        catch (Exception exception) {
            log.debug((Object)exception, (Throwable)exception);
            ReadWriteTest.fail((String)("Failed to populate message properties on creation: " + exception));
        }
        try {
            populator = PopulatorVerifierFactory.create(message, null);
            populator.populate(message);
        }
        catch (Exception exception) {
            log.debug((Object)exception, (Throwable)exception);
            ReadWriteTest.fail((String)("Failed to populate message body on creation: " + exception));
        }
    }

    public void testReadableOnCreation() throws Exception {
        MessageVerifier verifier;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        try {
            verifier = new EmptyPropertyVerifier();
            verifier.verify(message);
        }
        catch (Exception exception) {
            String msg = "Attempt to read the properties of a new message should not throw any exceptions";
            log.debug((Object)msg, (Throwable)exception);
            ReadWriteTest.fail((String)(msg + ": " + exception));
        }
        verifier = new EmptyMessageVerifier();
        try {
            verifier.verify(message);
        }
        catch (Exception exception) {
            String msg = "Failed to read the message body of a new message";
            log.debug((Object)msg, (Throwable)exception);
            ReadWriteTest.fail((String)(msg + ": " + exception));
        }
    }

    public void testBytesReadableOnCreation() throws Exception {
        this.checkBytesStreamReadableOnCreation();
    }

    public void testStreamReadableOnCreation() throws Exception {
        this.checkBytesStreamReadableOnCreation();
    }

    public void testWriteableOnClear() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePopulatorVerifier populator = PopulatorVerifierFactory.create(message, null);
        try {
            populator.populate(message);
        }
        catch (Exception exception) {
            log.debug((Object)exception, (Throwable)exception);
            ReadWriteTest.fail((String)("Failed to populate message body on creation: " + exception));
        }
        message.clearBody();
        try {
            populator.populate(message);
        }
        catch (Exception exception) {
            log.debug((Object)exception, (Throwable)exception);
            ReadWriteTest.fail((String)("Failed to populate message body after invoking clearBody: " + exception));
        }
    }

    private void checkBytesStreamReadableOnCreation() throws Exception {
        String msg;
        MessageVerifier verifier;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        try {
            verifier = new EmptyPropertyVerifier();
            verifier.verify(message);
        }
        catch (Exception exception) {
            String msg2 = "Attempt to read the properties of a new message should not throw any exceptions";
            log.debug((Object)msg2, (Throwable)exception);
            ReadWriteTest.fail((String)(msg2 + ": " + exception));
        }
        verifier = new EmptyMessageVerifier(MessageNotReadableException.class);
        try {
            verifier.verify(message);
        }
        catch (Exception exception) {
            msg = "Attempt to read body of a new " + context.getMessageType().getName() + " should throw MessageNotReadableException";
            log.debug((Object)msg, (Throwable)exception);
            ReadWriteTest.fail((String)(msg + ": " + exception));
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
        } else {
            ((StreamMessage)message).reset();
        }
        verifier = new EmptyMessageVerifier(MessageEOFException.class);
        try {
            verifier.verify(message);
        }
        catch (Exception exception) {
            msg = "Attempt to read body of a new " + context.getMessageType().getName() + " after reset() should throw MessageEOFException";
            log.debug((Object)msg, (Throwable)exception);
            ReadWriteTest.fail((String)(msg + ": " + exception));
        }
    }
}

