/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.stream;

import java.math.BigDecimal;
import java.util.Arrays;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.ClassHelper;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.Conversions;
import org.exolab.jmscts.test.message.util.MessageValues;

public class StreamMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    private static final Object[][] CONVERSION_VALUES = new Object[][]{BOOLEANS, BYTES, SHORTS, CHARS, INTS, LONGS, FLOATS, DOUBLES, (Object[])BYTE_ARRAYS};
    private static final Float[] FLOAT_CONVERSION_VALUES = new Float[]{new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE)};
    private static final Double[] DOUBLE_CONVERSION_VALUES = new Double[]{new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE)};
    private static final Object[][] STRING_CONVERSION_VALUES = new Object[][]{BOOLEANS, BYTES, SHORTS, INTS, LONGS, FLOAT_CONVERSION_VALUES, DOUBLE_CONVERSION_VALUES, STRINGS};

    public StreamMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(StreamMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testReadFailure() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            for (int j = 0; j < ALL_VALUES[i].length; ++j) {
                Object value = ALL_VALUES[i][j];
                this.write(message, value);
                message.reset();
                Class<?> type = value.getClass();
                Class[] invalid = Conversions.getInvalidConversions(type);
                for (int k = 0; k < invalid.length; ++k) {
                    try {
                        this.read(message, invalid[k]);
                        StreamMessageTest.fail((String)("Expected MessageFormatException to be thrown when reading type=" + ClassHelper.getPrimitiveName(invalid[k]) + " for type=" + ClassHelper.getPrimitiveName(type)));
                        continue;
                    }
                    catch (MessageFormatException expected) {
                        continue;
                    }
                    catch (Exception exception) {
                        StreamMessageTest.fail((String)("Expected MessageFormatException to be thrown when reading type=" + ClassHelper.getPrimitiveName(invalid[k]) + " for type=" + ClassHelper.getPrimitiveName(type) + ", but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                    }
                }
                if (value instanceof byte[]) {
                    byte[] v = (byte[])value;
                    byte[] buffer = new byte[v.length];
                    StreamMessageTest.assertEquals((int)v.length, (int)message.readBytes(buffer));
                    StreamMessageTest.assertTrue((boolean)Arrays.equals(v, buffer));
                    StreamMessageTest.assertEquals((int)-1, (int)message.readBytes(buffer));
                } else {
                    Object result = this.read(message, type);
                    StreamMessageTest.assertEquals((Object)value, (Object)result);
                }
                message.clearBody();
            }
        }
    }

    public void testConversion() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        for (int i = 0; i < CONVERSION_VALUES.length; ++i) {
            for (int j = 0; j < CONVERSION_VALUES[i].length; ++j) {
                Object value = CONVERSION_VALUES[i][j];
                this.write(message, value);
                Class<?> type = value.getClass();
                Class[] valid = Conversions.getValidConversions(type);
                for (int k = 0; k < valid.length; ++k) {
                    message.reset();
                    Object result = this.read(message, valid[k]);
                    Object converted = Conversions.convert(value, valid[k]);
                    if (converted instanceof byte[]) {
                        if (Arrays.equals((byte[])result, (byte[])converted)) continue;
                        StreamMessageTest.fail((String)"Read byte array different to that written");
                        continue;
                    }
                    StreamMessageTest.assertEquals((String)("Conversion of type=" + ClassHelper.getPrimitiveName(type) + " to type=" + ClassHelper.getPrimitiveName(valid[k]) + " failed."), (Object)converted, (Object)result);
                }
                message.clearBody();
            }
        }
    }

    public void testStringConversion() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        for (int i = 0; i < STRING_CONVERSION_VALUES.length; ++i) {
            for (int j = 0; j < STRING_CONVERSION_VALUES[i].length; ++j) {
                Object value = STRING_CONVERSION_VALUES[i][j];
                this.write(message, value.toString());
                Class<?> type = value.getClass();
                message.reset();
                Object result = this.read(message, type);
                if (!value.equals(result)) {
                    StreamMessageTest.fail((String)("Conversion of type=String to type=" + ClassHelper.getPrimitiveName(type) + " failed. Expected value=" + value + ", but got value=" + result));
                }
                message.clearBody();
            }
        }
    }

    public void testInvalidNumericConversion() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        Class[] numerics = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        String[] invalidNos = new String[]{"a", "0x00", "NaN", "-Infinity", "+Infinity"};
        for (int i = 0; i < invalidNos.length; ++i) {
            String value = invalidNos[i];
            message.writeString(value);
            message.reset();
            for (int j = 0; j < numerics.length; ++j) {
                try {
                    this.read(message, numerics[j]);
                    StreamMessageTest.fail((String)("Expected NumberFormatException to be thrown when reading value=" + value + " as type=" + ClassHelper.getPrimitiveName(numerics[j])));
                    continue;
                }
                catch (NumberFormatException expected) {
                    continue;
                }
                catch (Exception exception) {
                    StreamMessageTest.fail((String)("Expected NumberFormatException to be thrown when reading value=" + value + " as type=" + ClassHelper.getPrimitiveName(numerics[j]) + ", but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                }
            }
            String result = message.readString();
            StreamMessageTest.assertEquals((String)value, (String)result);
            message.clearBody();
        }
    }

    public void testNull() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        try {
            message.writeObject(null);
        }
        catch (Exception exception) {
            StreamMessageTest.fail((String)("Failed to write a null value to StreamMessage, exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        message.reset();
        Object result = this.readNull(message, Boolean.class, null);
        StreamMessageTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        message.reset();
        result = this.readNull(message, String.class, null);
        StreamMessageTest.assertEquals(null, (Object)result);
        message.reset();
        byte[] tmp = new byte[]{};
        StreamMessageTest.assertEquals((int)-1, (int)message.readBytes(tmp));
        message.reset();
        this.readNull(message, Byte.class, NumberFormatException.class);
        this.readNull(message, Short.class, NumberFormatException.class);
        this.readNull(message, Character.class, NullPointerException.class);
        this.readNull(message, Integer.class, NumberFormatException.class);
        this.readNull(message, Long.class, NumberFormatException.class);
        this.readNull(message, Float.class, NullPointerException.class);
        this.readNull(message, Double.class, NullPointerException.class);
    }

    public void testWriteObject() throws Exception {
        int j;
        int i;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                message.writeObject(ALL_VALUES[i][j]);
            }
        }
        message.reset();
        for (i = 0; i < ALL_VALUES.length; ++i) {
            for (j = 0; j < ALL_VALUES[i].length; ++j) {
                Object value = message.readObject();
                if (ALL_VALUES[i][j] instanceof byte[]) {
                    byte[] source = (byte[])ALL_VALUES[i][j];
                    byte[] result = (byte[])value;
                    StreamMessageTest.assertTrue((boolean)Arrays.equals(source, result));
                    continue;
                }
                StreamMessageTest.assertEquals((Object)ALL_VALUES[i][j], (Object)value);
            }
        }
    }

    public void testInvalidObject() throws Exception {
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        try {
            message.writeObject((Object)new BigDecimal(0.0));
            StreamMessageTest.fail((String)"StreamMessage.writeObject() should only support objectified primitives");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testReadWriteBytes() throws Exception {
        int count;
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer1 = new byte[bytes.length];
        message.readBytes(buffer1);
        if (!Arrays.equals(bytes, buffer1)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        if ((count = message.readBytes(buffer1)) != -1) {
            StreamMessageTest.fail((String)("Expected readBytes to return count=-1 to indicate end of array field, but returned count=" + count));
        }
        message.clearBody();
        message.writeBytes(bytes, 1, bytes.length - 2);
        message.reset();
        byte[] expected = this.populateByteArray(bytes.length - 2, 1);
        byte[] buffer2 = new byte[expected.length];
        message.readBytes(buffer2);
        if (!Arrays.equals(expected, buffer2)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        if ((count = message.readBytes(buffer2)) != -1) {
            StreamMessageTest.fail((String)("Expected readBytes to return count=-1 to indicate end of array field, but returned count=" + count));
        }
    }

    public void testReadBytesReset1() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        message.reset();
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
    }

    public void testReadBytesReset2() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        message.reset();
        byte[] result = (byte[])message.readObject();
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
    }

    public void testReadBytesClearBody1() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        message.clearBody();
        bytes = this.populateByteArray(256, 1);
        message.writeBytes(bytes);
        message.reset();
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
    }

    public void testReadBytesClearBody2() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        message.clearBody();
        bytes = this.populateByteArray(256, 1);
        message.writeBytes(bytes);
        message.reset();
        byte[] result = (byte[])message.readObject();
        if (!Arrays.equals(bytes, result)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
    }

    public void testWriteBytes() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        byte[] copy = this.populateByteArray(bytes.length, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, copy)) {
            StreamMessageTest.fail((String)"writeBytes(byte[]) modified the source byte array");
        }
        message.clearBody();
        message.writeBytes(bytes, 0, bytes.length);
        message.reset();
        message.readBytes(buffer);
        if (!Arrays.equals(bytes, copy)) {
            StreamMessageTest.fail((String)"writeBytes(byte[], int, int) modified the source byte array");
        }
    }

    public void testFullReadBytes() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        int count = message.readBytes(buffer);
        if (count != buffer.length) {
            StreamMessageTest.fail((String)("Expected readBytes to return count=" + buffer.length + ", but returned count=" + count));
        }
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Read byte array differs to that written");
        }
        if ((count = message.readBytes(buffer)) != -1) {
            StreamMessageTest.fail((String)("Expected readBytes to return count=-1 to indicate end of array field, but returned count=" + count));
        }
    }

    public void testIncrementalReadBytes() throws Exception {
        int chunkSize = 64;
        int remainder = 32;
        int chunks = 8;
        int size = 480;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(480, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[][] buffers = new byte[8][64];
        int total = 0;
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            int expected;
            count = message.readBytes(buffers[i]);
            total += count;
            int n = expected = i < 7 ? 64 : 32;
            if (count == expected) continue;
            StreamMessageTest.fail((String)("Expected readBytes to return count=" + expected + ", but returned count=" + count));
        }
        byte[] read = new byte[480];
        for (int i = 0; i < 8; ++i) {
            int length = i < 7 ? 64 : 32;
            System.arraycopy(buffers[i], 0, read, i * 64, length);
        }
        if (!Arrays.equals(bytes, read)) {
            StreamMessageTest.fail((String)"Byte array read differs to that written");
        }
        try {
            count = message.readBytes(buffers[0]);
            StreamMessageTest.fail((String)("Expected readBytes to throw MessageEOFException, but  returned count=" + count));
        }
        catch (MessageEOFException expected) {
        }
        catch (Exception exception) {
            StreamMessageTest.fail((String)("Expected MessageFormatException to be thrown, but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }

    public void testPartialReadBytes() throws Exception {
        int dataSize = 256;
        TestContext context = this.getContext();
        StreamMessage message = (StreamMessage)context.getMessage();
        byte[] bytes = this.populateByteArray(256, 0);
        message.writeBytes(bytes);
        message.reset();
        byte[] buffer = new byte[bytes.length];
        int size = message.readBytes(buffer);
        if (size != buffer.length) {
            StreamMessageTest.fail((String)("Expected readBytes() to return count=" + buffer.length + ", but returned count=" + size));
        }
        if (!Arrays.equals(bytes, buffer)) {
            StreamMessageTest.fail((String)"Byte array read differs to that written");
        }
        Class[] types = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class, Object.class};
        for (int i = 0; i < types.length; ++i) {
            try {
                this.read(message, types[i]);
                StreamMessageTest.fail((String)("Expected MessageFormatException to be thrown when reading type=" + ClassHelper.getPrimitiveName(types[i]) + " after an incomplete read of a byte array"));
                continue;
            }
            catch (MessageFormatException expected) {
                continue;
            }
            catch (Exception exception) {
                StreamMessageTest.fail((String)("Expected MessageFormatException to be thrown when reading type=" + ClassHelper.getPrimitiveName(types[i]) + " after an incomplete read of a byte array, but got " + "exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        StreamMessageTest.assertEquals((int)-1, (int)message.readBytes(buffer));
    }

    private void write(StreamMessage message, Object value) throws Exception {
        if (value instanceof Boolean) {
            message.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            message.writeByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            message.writeShort(((Short)value).shortValue());
        } else if (value instanceof Character) {
            message.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            message.writeInt(((Integer)value).intValue());
        } else if (value instanceof Long) {
            message.writeLong(((Long)value).longValue());
        } else if (value instanceof Float) {
            message.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            message.writeDouble(((Double)value).doubleValue());
        } else if (value instanceof String) {
            message.writeString((String)value);
        } else if (value instanceof byte[]) {
            message.writeBytes((byte[])value);
        } else {
            message.writeObject(value);
        }
    }

    private Object read(StreamMessage message, Class type) throws Exception {
        int dataSize = 256;
        Object result = null;
        if (type.equals(Boolean.class)) {
            result = new Boolean(message.readBoolean());
        } else if (type.equals(Byte.class)) {
            result = new Byte(message.readByte());
        } else if (type.equals(Short.class)) {
            result = new Short(message.readShort());
        } else if (type.equals(Character.class)) {
            result = new Character(message.readChar());
        } else if (type.equals(Integer.class)) {
            result = new Integer(message.readInt());
        } else if (type.equals(Long.class)) {
            result = new Long(message.readLong());
        } else if (type.equals(Float.class)) {
            result = new Float(message.readFloat());
        } else if (type.equals(Double.class)) {
            result = new Double(message.readDouble());
        } else if (type.equals(String.class)) {
            result = message.readString();
        } else if (type.equals([B.class)) {
            byte[] bytes = null;
            byte[] buffer = new byte[256];
            int length = buffer.length;
            while (length == buffer.length) {
                length = message.readBytes(buffer);
                if (length == -1) continue;
                int size = bytes != null ? bytes.length : 0;
                size += length;
                if (bytes == null) {
                    bytes = new byte[size];
                    System.arraycopy(buffer, 0, bytes, 0, size);
                    continue;
                }
                byte[] tmp = new byte[size];
                System.arraycopy(bytes, 0, tmp, 0, bytes.length);
                System.arraycopy(buffer, 0, tmp, bytes.length, length);
                System.arraycopy(tmp, 0, bytes, 0, size);
                bytes = tmp;
            }
            result = bytes;
        } else if (type.equals(Object.class)) {
            result = message.readObject();
        }
        return result;
    }

    private Object readNull(StreamMessage message, Class type, Class exceptionType) throws Exception {
        Object result;
        block4: {
            result = null;
            try {
                result = this.read(message, type);
                if (exceptionType != null) {
                    StreamMessageTest.fail((String)("Expected exception, type=" + exceptionType.getName() + " to be thrown when reading null as type=" + ClassHelper.getPrimitiveName(type)));
                }
            }
            catch (Exception exception) {
                if (exceptionType == null) {
                    StreamMessageTest.fail((String)("Did not expect exception to be thrown when reading null as type=" + ClassHelper.getPrimitiveName(type) + " but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
                }
                if (exceptionType.isAssignableFrom(exception.getClass())) break block4;
                StreamMessageTest.fail((String)("Expected exception, type=" + exceptionType.getName() + " to be thrown when reading null as type=" + ClassHelper.getPrimitiveName(type) + ", but got " + "exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        return result;
    }

    private byte[] populateByteArray(int length, int start) {
        byte[] result = new byte[length];
        byte j = (byte)start;
        int i = 0;
        while (i < length) {
            result[i] = j;
            ++i;
            j = (byte)(j + 1);
        }
        return result;
    }
}

