/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.util;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.AbstractMessageVerifier;
import org.exolab.jmscts.core.MethodInvoker;

public class EmptyMessageVerifier
extends AbstractMessageVerifier {
    private static final int BYTE_ARRAY_SIZE = 10;

    public EmptyMessageVerifier() {
    }

    public EmptyMessageVerifier(Class exception) {
        super(exception);
    }

    public void verifyMessage(Message message) throws Exception {
    }

    public void verifyBytesMessage(BytesMessage message) throws Exception {
        int size = 10;
        this.expect((Message)message, "readBoolean", null);
        this.expect((Message)message, "readByte", null);
        if (MessageEOFException.class.equals(this.getExpectedException())) {
            MethodInvoker invoker = new MethodInvoker();
            Integer result = new Integer(-1);
            this.equal(invoker.invoke((Object)message, "readBytes", (Object)new byte[10]), result);
            Object[] args = new Object[]{new byte[10], new Integer(10)};
            this.equal(invoker.invoke((Object)message, "readBytes", args), result);
        } else {
            this.expect((Message)message, "readBytes", new Object[]{new byte[10]}, (Object)null);
            Object[] args = new Object[]{new byte[10], new Integer(10)};
            this.expect((Message)message, "readBytes", args, (Object)null);
        }
        this.expect((Message)message, "readChar", null);
        this.expect((Message)message, "readDouble", null);
        this.expect((Message)message, "readFloat", null);
        this.expect((Message)message, "readInt", null);
        this.expect((Message)message, "readLong", null);
        this.expect((Message)message, "readShort", null);
        this.expect((Message)message, "readUTF", null);
    }

    public void verifyMapMessage(MapMessage message) throws Exception {
        Enumeration iter = message.getMapNames();
        if (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            this.expect((Message)message, "getObject", new Object[]{name}, (Object)null);
        }
    }

    public void verifyObjectMessage(ObjectMessage message) throws Exception {
        this.expect((Message)message, "getObject", null);
    }

    public void verifyStreamMessage(StreamMessage message) throws Exception {
        this.expect((Message)message, "readBoolean", null);
        this.expect((Message)message, "readByte", null);
        this.expect((Message)message, "readBytes", new Object[]{new byte[10]}, (Object)null);
        this.expect((Message)message, "readChar", null);
        this.expect((Message)message, "readDouble", null);
        this.expect((Message)message, "readFloat", null);
        this.expect((Message)message, "readInt", null);
        this.expect((Message)message, "readLong", null);
        this.expect((Message)message, "readShort", null);
        this.expect((Message)message, "readString", null);
        this.expect((Message)message, "readObject", null);
    }

    public void verifyTextMessage(TextMessage message) throws Exception {
        this.expect((Message)message, "getText", null);
    }
}

