/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.util;

import java.util.Enumeration;
import javax.jms.Message;
import org.exolab.jmscts.core.MessageVerifier;

public class EmptyPropertyVerifier
implements MessageVerifier {
    private boolean _provider = false;

    public EmptyPropertyVerifier() {
    }

    public EmptyPropertyVerifier(boolean provider) {
        this._provider = provider;
    }

    public void verify(Message message) throws Exception {
        Enumeration iter = message.getPropertyNames();
        if (iter.hasMoreElements() && !this._provider) {
            String names = null;
            while (iter.hasMoreElements()) {
                String name = (String)iter.nextElement();
                if (names == null) {
                    names = name;
                    continue;
                }
                names = names + ", " + name;
            }
            throw new Exception("Expected message to contain no properties, but contains properties for: " + names);
        }
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            if (name.startsWith("JMSX")) {
                if (!name.equals("JMSXGroupID") && !name.equals("JMSXGroupSeq")) continue;
                throw new Exception("Message should not contain property=" + name);
            }
            if (name.startsWith("JMS_")) continue;
            throw new Exception("Expected message to contain no properties");
        }
    }
}

