/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.producer.ttl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.TestProperties;

public class ExpirationTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "ExpirationTest";
    private static final Category log = Category.getInstance((Class)ExpirationTest.class);
    private static final long EXPIRATION_INTERVAL = TestProperties.getLong(ExpirationTest.class, "expirationInterval", 0L);

    public ExpirationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ExpirationTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testExpiration() throws Exception {
        long timeToLive = 1000L;
        int messages = 10;
        boolean receivers = true;
        this.checkExpiration(1000L, 10, 1);
    }

    public void testSingleMessageExpiration() throws Exception {
        long timeToLive = 1000L;
        boolean messages = true;
        boolean receivers = true;
        this.checkExpiration(1000L, 1, 1);
    }

    public void testExpiration2Subscribers() throws Exception {
        long timeToLive = 1000L;
        int messages = 10;
        int subscribers = 2;
        this.checkExpiration(1000L, 10, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpiration2DiffSubscribers() throws Exception {
        long timeToLive = 1000L;
        int messages = 10;
        TestContext context = this.getContext();
        MessageReceiver[] subscribers = new MessageReceiver[2];
        MessagingBehaviour behaviour = new MessagingBehaviour(context.getMessagingBehaviour());
        behaviour.setDurable(false);
        TestContext nondurable = TestContextHelper.createSendReceiveContext(context, false, behaviour);
        try {
            subscribers[0] = this.createReceiver(DESTINATION);
            subscribers[1] = this.createReceiver(nondurable, DESTINATION);
            this.checkExpiration(1000L, 10, subscribers);
        }
        finally {
            this.close(subscribers);
            nondurable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiration(long timeToLive, int messageCount, int receiverCount) throws Exception {
        MessageReceiver[] receivers = new MessageReceiver[receiverCount];
        try {
            for (int i = 0; i < receivers.length; ++i) {
                receivers[i] = this.createReceiver(DESTINATION);
            }
            this.checkExpiration(timeToLive, messageCount, receivers);
        }
        finally {
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiration(long timeToLive, int messageCount, MessageReceiver[] receivers) throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        HashSet<String> expiringIds = new HashSet<String>();
        HashSet<String> nonExpiringIds = new HashSet<String>();
        MessageSender sender = null;
        try {
            int i;
            sender = this.createSender(DESTINATION);
            for (i = 0; i < messageCount; ++i) {
                sender.send(message, 1, timeToLive);
                expiringIds.add(message.getJMSMessageID());
            }
            for (i = 0; i < messageCount; ++i) {
                sender.send(message, 1, 0L);
                nonExpiringIds.add(message.getJMSMessageID());
            }
            if (session.getTransacted()) {
                session.commit();
            }
            ExpirationTest.assertEquals((String)"Duplicate JMSMessageID allocated", (int)messageCount, (int)expiringIds.size());
            ExpirationTest.assertEquals((String)"Duplicate JMSMessageID allocated", (int)messageCount, (int)nonExpiringIds.size());
            long sleepTime = EXPIRATION_INTERVAL + timeToLive;
            try {
                log.debug((Object)("Sleeping for " + sleepTime + "ms to allow messages to expire"));
                Thread.currentThread();
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            for (int i2 = 0; i2 < receivers.length; ++i2) {
                List messages = this.receive(receivers[i2], messageCount);
                Iterator iterator = messages.iterator();
                while (iterator.hasNext()) {
                    Message received = (Message)iterator.next();
                    String id = received.getJMSMessageID();
                    if (nonExpiringIds.contains(id)) continue;
                    if (expiringIds.contains(id)) {
                        ExpirationTest.fail((String)("Received a message which should have expired: " + id));
                        continue;
                    }
                    ExpirationTest.fail((String)("Received a message which wasn't sent by this test: " + id));
                }
            }
        }
        finally {
            this.close(sender);
        }
    }
}

