/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.producer.ttl;

import javax.jms.Message;
import javax.jms.Session;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;

class TimeToLiveTestCase
extends AbstractSendReceiveTestCase {
    public TimeToLiveTestCase(String name) {
        super(name);
    }

    protected void checkExpiration(Message message, long start, long end, long timeToLive) throws Exception {
        long expiryTime = message.getJMSExpiration();
        if (timeToLive == 0L) {
            if (expiryTime != 0L) {
                TimeToLiveTestCase.fail((String)"JMSExpiration should be 0 (never expires) for a time-to-live of 0");
            }
        } else {
            long min = start + timeToLive;
            long max = end + timeToLive;
            if (expiryTime < min) {
                TimeToLiveTestCase.fail((String)("JMSExpiration < expected expiration. Expected value > " + min + ", but got value=" + expiryTime));
            }
            if (expiryTime > max) {
                TimeToLiveTestCase.fail((String)("JMSExpiration > expected expiration. Expected value < " + max + ", but got value=" + expiryTime));
            }
        }
    }

    protected void checkSameExpiration(Message message, MessageReceiver receiver) throws Exception {
        long expected = message.getJMSExpiration();
        Session session = this.getContext().getSession();
        if (session.getTransacted()) {
            session.commit();
        }
        Message received = this.receive(receiver);
        TimeToLiveTestCase.assertEquals((String)"JMSExpiration different to that on send", (long)expected, (long)received.getJMSExpiration());
    }
}

