/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.selector;

import java.util.HashMap;
import junit.framework.Test;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.selector.AbstractSelectorTestCase;

public class StringTest
extends AbstractSelectorTestCase {
    private static final HashMap PROPERTIES = new HashMap();

    public StringTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(StringTest.class);
    }

    public void testEquals() throws Exception {
        this.checkSelector("'abc' = 'abc'", true);
    }

    public void testEqualsProperty() throws Exception {
        this.checkSelector("Country = 'France'", true, PROPERTIES);
    }

    public void testCaseComparison1() throws Exception {
        this.checkSelector("'abc' = 'ABC'", false);
    }

    public void testCaseComparison2() throws Exception {
        this.checkSelector("'abc' <> 'ABC'", true);
    }

    public void testCaseComparison3() throws Exception {
        this.checkSelector("Country = 'france'", false, PROPERTIES);
    }

    public void testCheckSingleQuotes1() throws Exception {
        this.checkSelector("'it''s' = 'it''s'", true);
    }

    public void testCheckSingleQuotes2() throws Exception {
        this.checkSelector("'it''s' = 'its'", false);
    }

    public void testLessThan1() throws Exception {
        this.checkInvalidSelector("'abc' < 'abc'");
    }

    public void testLessThan2() throws Exception {
        this.checkInvalidSelector("dummy < 'abc'");
    }

    public void testLessThan3() throws Exception {
        this.checkInvalidSelector("'abc' < dummy");
    }

    public void testGreaterThan1() throws Exception {
        this.checkInvalidSelector("'abc' > 'abc'");
    }

    public void testGreaterThan2() throws Exception {
        this.checkInvalidSelector("dummy > 'abc'");
    }

    public void testGreaterThan3() throws Exception {
        this.checkInvalidSelector("'abc' < dummy");
    }

    public void testLessEquals1() throws Exception {
        this.checkInvalidSelector("'abc' <= 'abc'");
    }

    public void testLessEquals2() throws Exception {
        this.checkInvalidSelector("dummy <= 'abc'");
    }

    public void testLessEquals3() throws Exception {
        this.checkInvalidSelector("'abc' <= dummy");
    }

    public void testGreaterEquals1() throws Exception {
        this.checkInvalidSelector("'abc' >= 'abc'");
    }

    public void testGreaterEquals2() throws Exception {
        this.checkInvalidSelector("dummy >= 'abc'");
    }

    public void testGreaterEquals3() throws Exception {
        this.checkInvalidSelector("'abc' >= dummy");
    }

    public void testInvalid1() throws Exception {
        this.checkInvalidSelector("'abc'");
    }

    public void testInvalid2() throws Exception {
        this.checkInvalidSelector("'abc' = 'abc");
    }

    public void testInvalid3() throws Exception {
        this.checkInvalidSelector("'abc' = abc'");
    }

    public void testInvalid4() throws Exception {
        this.checkInvalidSelector("'abc = 'abc'");
    }

    public void testInvalid5() throws Exception {
        this.checkInvalidSelector("'abc'''' = 'abc'");
    }

    public void testInvalid6() throws Exception {
        this.checkInvalidSelector("\"abc\" = \"abc\"");
    }

    static {
        PROPERTIES.put("Country", "France");
    }
}

