/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.QueueSession;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSessionTestCase;
import org.exolab.jmscts.core.AckTypes;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.MethodInvoker;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class CloseTest
extends AbstractSessionTestCase {
    private static final Category log = Category.getInstance((Class)CloseTest.class);

    public CloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSessionTest(CloseTest.class);
    }

    public boolean share() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionOnClose() throws Exception {
        String name = "CloseTest";
        TestContext context = this.getContext();
        Session session = context.getSession();
        session.close();
        DestinationHelper.destroy("CloseTest", context.getAdministrator());
        Destination destination = DestinationHelper.create("CloseTest", context.isQueue(), context.getAdministrator());
        try {
            this.invokeSessionMethods(destination);
        }
        finally {
            DestinationHelper.destroy("CloseTest", context.getAdministrator());
        }
    }

    public void testCloseForClosedSession() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        session.close();
        try {
            session.close();
        }
        catch (Exception exception) {
            String msg = "Closing a closed session shouldn't generate an exception";
            log.debug((Object)msg, (Throwable)exception);
            CloseTest.fail((String)msg);
        }
    }

    private void invokeSessionMethods(Destination destination) throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        MethodInvoker invoker = new MethodInvoker(context.getSessionType(), IllegalStateException.class);
        invoker.invoke((Object)session, "createBytesMessage");
        invoker.invoke((Object)session, "createMapMessage");
        invoker.invoke((Object)session, "createObjectMessage");
        invoker.invoke((Object)session, "createObjectMessage", (Object)"ABC");
        invoker.invoke((Object)session, "createStreamMessage");
        invoker.invoke((Object)session, "createTextMessage");
        invoker.invoke((Object)session, "createTextMessage", (Object)"ABC");
        invoker.invoke((Object)session, "getTransacted");
        if (context.getAckType() == AckTypes.TRANSACTED) {
            invoker.invoke((Object)session, "commit");
            invoker.invoke((Object)session, "rollback");
        } else {
            invoker.invoke((Object)session, "recover");
        }
        if (session instanceof QueueSession) {
            invoker.invoke((Object)session, "createBrowser", (Object)destination);
            invoker.invoke((Object)session, "createBrowser", new Object[]{destination, "1=1"});
            invoker.invoke((Object)session, "createQueue", (Object)"dummy");
            invoker.invoke((Object)session, "createReceiver", (Object)destination);
            invoker.invoke((Object)session, "createReceiver", new Object[]{destination, "1=1"});
            invoker.invoke((Object)session, "createSender", (Object)destination);
            invoker.invoke((Object)session, "createTemporaryQueue");
        } else {
            invoker.invoke((Object)session, "createDurableSubscriber", new Object[]{destination, "ABC"});
            invoker.invoke((Object)session, "createDurableSubscriber", new Object[]{destination, "CDE", "1=1", Boolean.TRUE});
            invoker.invoke((Object)session, "createPublisher", (Object)destination);
            invoker.invoke((Object)session, "createSubscriber", (Object)destination);
            invoker.invoke((Object)session, "createSubscriber", new Object[]{destination, "1=1", Boolean.FALSE});
            invoker.invoke((Object)session, "createTemporaryTopic");
            invoker.invoke((Object)session, "createTopic", (Object)"dummy");
            invoker.invoke((Object)session, "unsubscribe", (Object)"ABC");
        }
    }
}

