/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class MessageListenerTest
extends AbstractSendReceiveTestCase {
    private static final String[] DESTINATIONS = new String[]{"dest1", "dest2", "dest3"};
    private static final Category log = Category.getInstance((Class)MessageListenerTest.class);

    public MessageListenerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(MessageListenerTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerialInvocation() throws Exception {
        Object destination;
        int send = 50;
        int expected = 50 * DESTINATIONS.length;
        long sleep = 100L;
        MessageConsumer[] consumers = new MessageConsumer[DESTINATIONS.length];
        TestListener listener = new TestListener(expected, 100L);
        TestContext context = this.getContext();
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        for (int i = 0; i < DESTINATIONS.length; ++i) {
            Destination destination2 = this.getDestination(DESTINATIONS[i]);
            String name = null;
            if (behaviour.getDurable()) {
                name = SessionHelper.getSubscriberName();
            }
            MessageConsumer consumer = SessionHelper.createConsumer(context, destination2, name);
            consumer.setMessageListener((MessageListener)listener);
            consumers[i] = consumer;
        }
        Message message = context.getMessage();
        for (int i = 0; i < DESTINATIONS.length; ++i) {
            destination = this.getDestination(DESTINATIONS[i]);
            MessageSender sender = SessionHelper.createSender(context, destination);
            sender.send(message, 50);
            sender.close();
        }
        Session session = context.getSession();
        if (session.getTransacted()) {
            session.commit();
        }
        destination = listener;
        synchronized (destination) {
            if (listener.getReceived() != expected) {
                listener.wait((long)expected * 100L * 2L);
            }
        }
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].close();
        }
        if (listener.getFailures() != 0) {
            MessageListenerTest.fail((String)"The listener was not invoked serially");
        }
        if (listener.getReceived() != expected) {
            MessageListenerTest.fail((String)("Received " + listener.getReceived() + " messages, but expected " + expected));
        }
    }

    private class TestListener
    implements MessageListener {
        private final int _expected;
        private final long _sleep;
        private boolean _invoked = false;
        private int _failures = 0;
        private int _received = 0;

        public TestListener(int expected, long sleep) {
            this._expected = expected;
            this._sleep = sleep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            TestListener testListener = this;
            synchronized (testListener) {
                if (this._invoked) {
                    ++this._failures;
                }
                this._invoked = true;
                ++this._received;
                if (this._received == this._expected) {
                    this.notify();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this._sleep);
            }
            catch (InterruptedException ignore) {
                log.debug((Object)"TestListener interrupted while sleeping - continuing");
            }
            testListener = this;
            synchronized (testListener) {
                this._invoked = false;
            }
        }

        public int getFailures() {
            return this._failures;
        }

        public int getReceived() {
            return this._received;
        }
    }
}

