/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session;

import javax.jms.IllegalStateException;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSessionTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class NonTransactedTest
extends AbstractSessionTestCase {
    public NonTransactedTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSessionTest(NonTransactedTest.class);
    }

    public void testCommit() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        try {
            session.commit();
            NonTransactedTest.fail((String)"Invoking commit on a non-transacted session should throw IllegalStateException");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            NonTransactedTest.fail((String)("Invoking commit on a non-transacted session should  throw IllegalStateException, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }

    public void testRollback() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        try {
            session.rollback();
            NonTransactedTest.fail((String)"Invoking rollback on a non-transacted session should  throw IllegalStateException");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            NonTransactedTest.fail((String)("Invoking rollback on a non-transacted session should  throw IllegalStateException, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

