/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session;

import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.CompletionListener;
import org.exolab.jmscts.core.DelayedAction;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class ReceiverCloseTest
extends AbstractSendReceiveTestCase {
    private static final Category log = Category.getInstance((Class)ReceiverCloseTest.class);
    private static final String DESTINATION = "ReceiverCloseTest";

    public ReceiverCloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ReceiverCloseTest.class);
    }

    public boolean share() {
        return false;
    }

    public boolean startConnection() {
        return false;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testSessionClose() throws Exception {
        long delayTime = 1000L;
        long completionTime = 30000L;
        TestContext context = this.getContext();
        Connection connection = context.getConnection();
        final Session session = context.getSession();
        Destination destination = this.getDestination(DESTINATION);
        MessageReceiver receiver = SessionHelper.createReceiver(context, destination);
        CompletionListener listener = new CompletionListener(1);
        DelayedAction action = new DelayedAction(1000L, listener){

            public void runProtected() throws Exception {
                log.debug((Object)"Starting to close session");
                session.close();
                log.debug((Object)"Session closed");
            }
        };
        connection.start();
        action.start();
        try {
            log.debug((Object)"Starting to receive messages");
            List result = receiver.receive(0, 0L);
            log.debug((Object)"Receive returned");
        }
        catch (Exception exception) {
            ReceiverCloseTest.fail((String)("Expected synchronous consumer to time out and return null when session closed, but threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        listener.waitForCompletion(30000L);
        if (listener.getCompleted() != 1) {
            context.invalidate();
            ReceiverCloseTest.fail((String)"Session.close() didn't return. Appears to have blocked");
        }
        if (action.getException() != null) {
            exception = action.getException();
            ReceiverCloseTest.fail((String)("Failed to close session, exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            receiver.close();
        }
        catch (Exception exception) {
            ReceiverCloseTest.fail((String)("Attempting to invoke close() for a consumer on a closed session threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

