/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.clientack;

import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.session.clientack.ClientAcknowledgeTestCase;

public class ClientAcknowledgeTest
extends ClientAcknowledgeTestCase {
    private static final String[] DESTINATIONS = new String[]{"clientack1", "clientack2", "clientack3"};
    private static final Category log = Category.getInstance((Class)ClientAcknowledgeTest.class);

    public ClientAcknowledgeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ClientAcknowledgeTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientAcknowledge() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            this.send(10);
            Message last = this.receive(receivers, 10, 1, false);
            last.acknowledge();
            this.receive(receivers, 0);
            session.recover();
            this.receive(receivers, 0);
        }
        finally {
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartialClientAcknowledge() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            this.send(10);
            for (int i = 0; i < receivers.length; ++i) {
                List result = this.receive(receivers[i], 10);
                String name = this.getDestinations()[i];
                this.checkProperties(result, name, 1, false);
                Message received = (Message)result.get(4);
                received.acknowledge();
                log.debug((Object)"Recovering session to receive unacknowledged messages");
                session.recover();
            }
            int remaining = 5;
            int sequence = 10 - remaining + 1;
            Message last = this.receive(receivers, remaining, sequence, true);
            last.acknowledge();
            this.receive(receivers, 0);
            session.recover();
            this.receive(receivers, 0);
        }
        finally {
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecover() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            this.send(10);
            this.receive(receivers, 10, 1, false);
            session.recover();
            this.receive(receivers, 10, 1, true);
        }
        finally {
            this.close(receivers);
        }
    }
}

