/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.transacted;

import java.util.Iterator;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.AckTypes;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class RollbackTest
extends AbstractSendReceiveTestCase {
    private static final String[] DESTINATIONS = new String[]{"rollback1", "rollback2", "rollback3"};
    private static final Category log = Category.getInstance((Class)RollbackTest.class);

    public RollbackTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(RollbackTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollback() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        boolean isBrowser = false;
        if (behaviour.getReceiptType() == ReceiptType.BROWSER) {
            isBrowser = true;
        }
        MessageSender[] senders = this.createSenders();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            List messages;
            int i;
            this.send(senders, message, 10);
            session.rollback();
            this.receive(receivers, 0);
            this.send(senders, message, 10);
            session.commit();
            for (i = 0; i < receivers.length; ++i) {
                messages = this.receive(receivers[i], 10);
                if (isBrowser) continue;
                this.checkRedelivered(messages, false);
            }
            session.rollback();
            for (i = 0; i < receivers.length; ++i) {
                messages = this.receive(receivers[i], 10);
                if (isBrowser) continue;
                this.checkRedelivered(messages, true);
            }
        }
        finally {
            this.close(senders);
            this.close(receivers);
        }
    }

    public void testClose() throws Exception {
        TestContext context = this.getContext();
        Session session = ConnectionHelper.createSession(context, AckTypes.TRANSACTED);
        session.close();
        try {
            session.rollback();
            String msg = "Session.rollback() for a closed session should  throw " + IllegalStateException.class.getName();
            log.debug((Object)msg);
            RollbackTest.fail((String)msg);
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            String msg = "Session.rollback() for a closed session should  throw " + IllegalStateException.class.getName() + ". Thrown exception=" + exception.getClass().getName();
            log.debug((Object)msg, (Throwable)exception);
            RollbackTest.fail((String)msg);
        }
    }

    private void checkRedelivered(List messages, boolean redelivered) throws Exception {
        TestContext context = this.getContext();
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            String msg;
            Message received = (Message)iter.next();
            if (received.getJMSRedelivered() && !redelivered) {
                msg = "The JMSRedelivered property has been set for a message that has not been re-delivered";
                log.debug((Object)msg);
                RollbackTest.fail((String)msg);
                continue;
            }
            if (received.getJMSRedelivered() || !redelivered) continue;
            msg = "The JMSRedelivered property must be set for a message that has been re-delivered";
            log.debug((Object)msg);
            RollbackTest.fail((String)msg);
        }
    }
}

