/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.topic;

import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSessionTestCase;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.DestinationHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class DuplicateDurableSubscriberTest
extends AbstractSessionTestCase {
    private static final String DESTINATION = "DuplicateDurableSubscriberTest";

    public DuplicateDurableSubscriberTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSessionTest(DuplicateDurableSubscriberTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateSubscriberPerSession() throws Exception {
        String name = "duplicate";
        TestContext context = this.getContext();
        TopicSession session = (TopicSession)context.getSession();
        DestinationHelper.destroy(DESTINATION, context.getAdministrator());
        Topic topic = (Topic)DestinationHelper.create(context, DESTINATION);
        TopicSubscriber subscriber1 = session.createDurableSubscriber(topic, "duplicate");
        try {
            TopicSubscriber subscriber2 = session.createDurableSubscriber(topic, "duplicate");
            subscriber2.close();
            DuplicateDurableSubscriberTest.fail((String)"Managed to create a duplicate durable subscriber in the same session");
        }
        catch (JMSException expected) {
        }
        finally {
            subscriber1.close();
            session.unsubscribe("duplicate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateSubscriber() throws Exception {
        String name = "duplicate";
        TestContext context = this.getContext();
        TopicSession session1 = (TopicSession)context.getSession();
        DestinationHelper.destroy(DESTINATION, context.getAdministrator());
        Topic topic = (Topic)DestinationHelper.create(context, DESTINATION);
        TopicSubscriber subscriber1 = session1.createDurableSubscriber(topic, "duplicate");
        TopicSession session2 = (TopicSession)ConnectionHelper.createSession(context);
        try {
            TopicSubscriber subscriber2 = session2.createDurableSubscriber(topic, "duplicate");
            subscriber2.close();
            DuplicateDurableSubscriberTest.fail((String)"Managed to create a duplicate durable subscriber in another session, sharing the same connection");
        }
        catch (JMSException expected) {
        }
        finally {
            subscriber1.close();
            session1.unsubscribe("duplicate");
            session2.close();
        }
    }
}

