/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.tools;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.xml.DOMConfigurator;
import org.exolab.jmscts.tools.MessagingTool;

public abstract class MessagingCommand {
    protected static final String CONFIG = "c";
    protected static final String CONFIG_LONG = "config";
    protected static final String FACTORY = "f";
    protected static final String FACTORY_LONG = "factory";
    protected static final String DESTINATION = "d";
    protected static final String DESTINATION_LONG = "destination";
    protected static final String COUNT = "c";
    protected static final String COUNT_LONG = "count";
    protected static final String VERBOSE = "v";
    protected static final String VERBOSE_LONG = "verbose";

    public MessagingCommand() {
        DOMConfigurator.configure((String)(this.getHome() + "/config/log4j.xml"));
    }

    public void invoke(String[] args) throws Exception {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine commands = null;
        try {
            commands = parser.parse(options, args);
        }
        catch (ParseException exception) {
            this.usage(options, exception.getMessage());
        }
        MessagingTool tool = this.create();
        this.parse(tool, commands);
        tool.invoke();
    }

    protected abstract MessagingTool create();

    protected void parse(MessagingTool tool, CommandLine commands) throws ParseException {
        String config = commands.getOptionValue(CONFIG_LONG, this.getHome() + "/config/providers.xml");
        tool.setConfig(config);
        tool.setConnectionFactory(commands.getOptionValue(FACTORY));
        tool.setDestination(commands.getOptionValue(DESTINATION));
        tool.setCount(Integer.parseInt(commands.getOptionValue("c")));
        if (commands.hasOption(VERBOSE)) {
            tool.setVerbose(true);
        }
    }

    protected Options getOptions() {
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CONFIG_LONG);
        OptionBuilder.withDescription((String)"the provider configuration path");
        Option config = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)FACTORY_LONG);
        OptionBuilder.withDescription((String)"the connection factory name");
        Option factory = OptionBuilder.create((String)FACTORY);
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)DESTINATION_LONG);
        OptionBuilder.withDescription((String)"the destination name");
        Option destination = OptionBuilder.create((String)DESTINATION);
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)COUNT_LONG);
        OptionBuilder.withDescription((String)"the number of messages to process");
        Option count = OptionBuilder.create((String)"c");
        OptionBuilder.withDescription((String)"use verbose logging");
        OptionBuilder.withLongOpt((String)VERBOSE_LONG);
        Option verbose = OptionBuilder.create((String)VERBOSE);
        Options options = new Options();
        options.addOption(config);
        options.addOption(factory);
        options.addOption(destination);
        options.addOption(count);
        options.addOption(verbose);
        return options;
    }

    protected abstract String getUsage();

    protected void usage(Options options, String message) {
        if (message != null) {
            System.err.println(message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getUsage(), options);
        System.exit(1);
    }

    protected String getHome() {
        return System.getProperty("jmscts.home", System.getProperty("user.dir"));
    }
}

