/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.tools.receive;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.tools.MessagingCommand;
import org.exolab.jmscts.tools.MessagingTool;
import org.exolab.jmscts.tools.receive.Receive;

public class Main
extends MessagingCommand {
    protected static final String RECEIPT = "r";
    protected static final String RECEIPT_LONG = "receipt";
    protected static final String SELECTOR = "s";
    protected static final String SELECTOR_LONG = "selector";

    protected MessagingTool create() {
        return new Receive();
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.withLongOpt((String)RECEIPT_LONG);
        OptionBuilder.withDescription((String)"Receipt type. One of sync or async. Defaults to sync.");
        Option receipt = OptionBuilder.create((String)RECEIPT);
        OptionBuilder.withArgName((String)SELECTOR_LONG);
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SELECTOR_LONG);
        OptionBuilder.withDescription((String)"Specifies the selector. Defaults to no selector");
        Option selector = OptionBuilder.create((String)SELECTOR);
        options.addOption(receipt);
        options.addOption(selector);
        return options;
    }

    protected String getUsage() {
        return "usage: receive [-config <path>] [-f <name>] -d <name> [-receipt <type>] -c <number> [-s <selector>] [-v]";
    }

    protected void parse(MessagingTool tool, CommandLine commands) throws ParseException {
        super.parse(tool, commands);
        Receive receive = (Receive)tool;
        receive.setReceiptType(Main.getReceiptType(commands));
        receive.setSelector(commands.getOptionValue(SELECTOR));
    }

    private static ReceiptType getReceiptType(CommandLine commands) throws ParseException {
        ReceiptType receipt = null;
        String type = commands.getOptionValue(RECEIPT, "sync");
        if (type.equals("sync")) {
            receipt = ReceiptType.SYNCHRONOUS;
        } else if (type.equals("async")) {
            receipt = ReceiptType.ASYNCHRONOUS;
        } else {
            throw new ParseException("Invalid receipt type: " + type);
        }
        return receipt;
    }

    public static void main(String[] args) throws Exception {
        Main command = new Main();
        command.invoke(args);
    }
}

