/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.tools.receive;

import javax.jms.Message;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.CountingListener;
import org.exolab.jmscts.core.MessageCreator;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.tools.MessagingTool;

public class Receive
extends MessagingTool {
    private ReceiptType _receipt;
    private String _selector;

    public void setReceiptType(ReceiptType type) {
        this._receipt = type;
    }

    public void setSelector(String selector) {
        this._selector = selector;
    }

    protected void doInvoke() throws Exception {
        TestContext connectionContext = TestContextHelper.createConnectionContext(this.getContext());
        TestContext sessionContext = TestContextHelper.createSessionContext(connectionContext, AckType.AUTO_ACKNOWLEDGE);
        MessageCreator creator = new MessageCreator(sessionContext.getSession(), null);
        MessagingBehaviour behaviour = new MessagingBehaviour();
        behaviour.setReceiptType(this._receipt);
        TestContext messageContext = new TestContext(sessionContext, creator.create(Message.class), behaviour);
        int count = this.getCount();
        MessageReceiver receiver = SessionHelper.createReceiver(messageContext, this.getDestination(), this._selector, false);
        Listener listener = new Listener(count);
        messageContext.getConnection().start();
        long timeout = behaviour.getTimeout();
        receiver.receive(timeout, listener);
        listener.waitForCompletion(timeout * (long)(count + 1));
        connectionContext.close();
    }

    private class Listener
    extends CountingListener {
        public Listener(int expected) {
            super(expected);
        }

        public void onMessage(Message message) {
            super.onMessage(message);
            Receive.this.log(message);
        }
    }
}

