/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Category;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.EventProducer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class ConfigExpander
implements EventProducer {
    private DocumentHandler _handler = null;
    private Reader _reader = null;
    private String _name = null;
    private static final Category log = Category.getInstance((Class)ConfigExpander.class);

    public ConfigExpander(Reader reader) {
        this._reader = reader;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this._handler = handler;
    }

    public void start() throws SAXException {
        Parser parser = Configuration.getDefaultParser();
        if (parser == null) {
            throw new SAXException("Unable to create parser");
        }
        Expander handler = new Expander();
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(this._reader));
        }
        catch (IOException exception) {
            throw new SAXException(exception.getMessage(), exception);
        }
    }

    private class Expander
    implements DocumentHandler {
        private Expander() {
        }

        public void setDocumentLocator(Locator locator) {
            ConfigExpander.this._handler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            ConfigExpander.this._handler.startDocument();
        }

        public void endDocument() throws SAXException {
            ConfigExpander.this._handler.endDocument();
        }

        public void startElement(String name, AttributeList list) throws SAXException {
            AttributeListImpl replaced = new AttributeListImpl();
            for (int i = 0; i < list.getLength(); ++i) {
                String value = this.expand(list.getName(i), list.getValue(i));
                replaced.addAttribute(list.getName(i), list.getType(i), value);
            }
            ConfigExpander.this._name = name;
            ConfigExpander.this._handler.startElement(name, replaced);
        }

        public void endElement(String name) throws SAXException {
            ConfigExpander.this._handler.endElement(name);
            ConfigExpander.this._name = null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String content = new String(ch, start, length);
            content = this.expand(ConfigExpander.this._name, content);
            ConfigExpander.this._handler.characters(content.toCharArray(), 0, content.length());
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            ConfigExpander.this._handler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            ConfigExpander.this._handler.processingInstruction(target, data);
        }

        private String expand(String name, String value) {
            int pos;
            StringBuffer buffer = new StringBuffer();
            int prev = 0;
            while ((pos = value.indexOf("${", prev)) >= 0) {
                int index;
                if (pos > 0) {
                    buffer.append(value.substring(prev, pos));
                }
                if ((index = value.indexOf(125, pos)) < 0) {
                    log.debug((Object)("Cannot expand as format is invalid: name=" + name + ", value=" + value));
                    buffer.append("${");
                    prev = pos + 2;
                    continue;
                }
                String propertyName = value.substring(pos + 2, index);
                String propertyValue = System.getProperty(propertyName);
                if (propertyValue != null) {
                    buffer.append(propertyValue);
                } else {
                    log.debug((Object)("Cannot expand " + name + " as property=" + propertyName + " is not defined"));
                    buffer.append("${");
                    buffer.append(propertyName);
                    buffer.append("}");
                }
                prev = index + 1;
            }
            if (prev < value.length()) {
                buffer.append(value.substring(prev));
            }
            String result = buffer.toString();
            return result;
        }
    }
}

