/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoFilterAdapter;
import org.apache.mina.io.IoSession;

public class BlacklistFilter
extends IoFilterAdapter {
    private final Set blacklist = new HashSet();

    public synchronized void block(InetAddress address) {
        this.blacklist.add(address);
    }

    public synchronized void unblock(InetAddress address) {
        this.blacklist.remove(address);
    }

    public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) throws Exception {
        if (!this.isBlocked(session)) {
            super.dataRead(nextFilter, session, buf);
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (this.isBlocked(session)) {
            session.close();
        } else {
            super.sessionOpened(nextFilter, session);
        }
    }

    private boolean isBlocked(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        return remoteAddress instanceof InetSocketAddress && this.blacklist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

