/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;

public class ObjectName
implements Serializable {
    static final long serialVersionUID = -5467795090068647408L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("propertyList", class$java$util$Hashtable == null ? (class$java$util$Hashtable = ObjectName.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("propertyListString", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("canonicalName", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final Comparator STRING_ARRAY = new /* Unavailable Anonymous Inner Class!! */;
    private static SortedMap canonicalKeys = new TreeMap(STRING_ARRAY);
    private String domain;
    private String[] keys;
    private String[] values;
    private int hash;
    private String nonCanonicalKeyPropertyListString = null;
    private boolean pattern = false;
    private boolean propertyPattern = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;

    private static synchronized String[] intern(String[] stringArray) {
        String[] stringArray2 = (String[])canonicalKeys.get(stringArray);
        if (stringArray2 == null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].intern();
                ++n;
            }
            canonicalKeys.put(stringArray, stringArray);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    /*
     * Unable to fully structure code
     */
    public ObjectName(String var1_1) throws MalformedObjectNameException {
        super();
        var2_2 = "";
        var3_3 = new Hashtable<String, String>();
        var4_4 = new ArrayList<String>();
        if (var1_1 == null) {
            throw new MalformedObjectNameException("ObjectName: Name cannot be null");
        }
        if (var1_1.equals(" ") || var1_1.equals("")) {
            var1_1 = "*:*";
        }
        if (var1_1.indexOf("*") != -1 || var1_1.indexOf("?") != -1) {
            this.pattern = true;
        }
        if ((var5_5 = var1_1.indexOf(":")) == -1) {
            throw new MalformedObjectNameException("ObjectName: domain part must be specified");
        }
        var2_2 = var1_1.substring(0, var5_5);
        if ((var1_1 = var1_1.substring(var5_5 + 1, var1_1.length())).length() == 0) {
            throw new MalformedObjectNameException("ObjectName: Key properties cannot be null");
        }
        var6_6 = new StringTokenizer(var1_1, ",", true);
        var8_7 = var6_6.nextToken();
        var7_8 = new StringTokenizer(var8_7, "=", true);
        try {
            var9_9 = var7_8.nextToken();
            var10_10 = var7_8.nextToken();
            var11_11 = var7_8.nextToken();
            if (!ObjectName.isValid(var11_11)) {
                throw new MalformedObjectNameException("ObjectName: Invalid value -> " + var11_11);
            }
            if (var7_8.hasMoreTokens()) {
                throw new MalformedObjectNameException("ObjectName: Invalid (key,value) pair -> " + var8_7);
            }
            var4_4.add(var9_9);
            var3_3.put(var9_9, var11_11);
            ** GOTO lbl43
        }
        catch (MalformedObjectNameException var12_12) {
            throw var12_12;
        }
        catch (Exception var13_15) {
            if (!this.pattern) {
                throw new MalformedObjectNameException("ObjectName: Invalid (key,value) pair -> " + var8_7);
            }
            if (var8_7.compareTo("*") != 0) {
                throw new MalformedObjectNameException("ObjectName: Invalid pattern -> " + var8_7);
            }
            this.propertyPattern = true;
lbl43:
            // 4 sources

            ** while (var6_6.hasMoreTokens())
        }
lbl-1000:
        // 1 sources

        {
            try {
                var8_7 = var6_6.nextToken();
                if (!var8_7.equals(",")) {
                    throw new MalformedObjectNameException("ObjectName: Invalid property list");
                }
                var8_7 = var6_6.nextToken();
            }
            catch (Exception var12_13) {
                throw new MalformedObjectNameException("ObjectName: Invalid property list");
            }
            var7_8 = new StringTokenizer(var8_7, "=", true);
            try {
                var9_9 = var7_8.nextToken();
                var10_10 = var7_8.nextToken();
                var11_11 = var7_8.nextToken();
                if (!ObjectName.isValid(var11_11)) {
                    throw new MalformedObjectNameException("ObjectName: Invalid value -> " + var11_11);
                }
                if (var7_8.hasMoreTokens()) {
                    throw new MalformedObjectNameException("ObjectName: Invalid (key,value) pair -> " + var8_7);
                }
                if (var3_3.containsKey(var9_9)) {
                    throw new MalformedObjectNameException("ObjectName: key -> " + var9_9 + " already exists");
                }
                var4_4.add(var9_9);
                var3_3.put(var9_9, var11_11);
            }
            catch (MalformedObjectNameException var12_14) {
                throw var12_14;
            }
            catch (Exception var13_17) {
                if (!this.pattern) {
                    throw new MalformedObjectNameException("ObjectName: Invalid (key,value) pair -> " + var8_7);
                }
                if (var8_7.compareTo("*") != 0) {
                    throw new MalformedObjectNameException("ObjectName: Invalid pattern -> " + var8_7);
                }
                this.propertyPattern = true;
            }
            continue;
        }
lbl77:
        // 1 sources

        this.initObjectName(var2_2, var3_3, var4_4);
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            hashtable.put(string2, string3);
        }
        catch (NullPointerException nullPointerException) {
            throw new MalformedObjectNameException("ObjectName: Neither the key nor the value can be null");
        }
        this.initObjectName(string, hashtable, null);
    }

    public ObjectName(String string, Hashtable hashtable) throws MalformedObjectNameException {
        if (hashtable == null) {
            throw new MalformedObjectNameException("ObjectName: Hashtable is null");
        }
        if (hashtable.isEmpty()) {
            throw new MalformedObjectNameException("ObjectName: Empty Hashtable");
        }
        this.initObjectName(string, hashtable, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        if (this.keys != objectName.keys || this.domain != objectName.domain) {
            return false;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (!this.values[n].equals(objectName.values[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.domain.hashCode();
            int n2 = 0;
            while (n2 < this.keys.length) {
                n = 31 * n + this.keys[n2].hashCode();
                n = 31 * n + this.values[n2].hashCode();
                ++n2;
            }
            this.hash = n;
        }
        return n;
    }

    public String toString() {
        return this.toString(this.domain + ":");
    }

    private String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string);
        String string2 = "";
        int n = 0;
        while (n < this.keys.length) {
            stringBuffer.append(string2).append(this.keys[n]).append('=').append(this.values[n]);
            string2 = ",";
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isPattern() {
        return this.pattern;
    }

    public String getCanonicalName() {
        return this.toString();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String string) {
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] == string || this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Hashtable getKeyPropertyList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.keys.length);
        int n = 0;
        while (n < this.keys.length) {
            hashtable.put(this.keys[n], this.values[n]);
            ++n;
        }
        return hashtable;
    }

    public String getKeyPropertyListString() {
        return this.nonCanonicalKeyPropertyListString != null ? this.nonCanonicalKeyPropertyListString : this.getCanonicalKeyPropertyListString();
    }

    public String getCanonicalKeyPropertyListString() {
        return this.toString("");
    }

    public boolean isPropertyPattern() {
        return this.propertyPattern;
    }

    private void initObjectName(String string, Hashtable hashtable, ArrayList arrayList) throws MalformedObjectNameException {
        Object object;
        if (string == null || hashtable == null) {
            throw new MalformedObjectNameException("ObjectName: Invalid object name");
        }
        if (!this.isDomain(string)) {
            throw new MalformedObjectNameException("ObjectName: Invalid domain -> " + string);
        }
        this.setDomain(string);
        TreeMap treeMap = new TreeMap();
        if (arrayList == null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                ObjectName.validateAndAdd(object.nextElement(), hashtable, treeMap);
            }
        } else {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ObjectName.validateAndAdd(object.next(), hashtable, treeMap);
            }
        }
        this.keys = ObjectName.intern(treeMap.keySet().toArray(new String[treeMap.size()]));
        this.values = treeMap.values().toArray(new String[treeMap.size()]);
        int n = 0;
        while (n < this.values.length) {
            this.values[n] = this.values[n].intern();
            ++n;
        }
        if (arrayList != null) {
            this.nonCanonicalKeyPropertyListString = ObjectName.stringify(arrayList, hashtable);
        }
    }

    private static void validateAndAdd(Object object, Hashtable hashtable, Map map) throws MalformedObjectNameException {
        String string = null;
        try {
            string = (String)object;
        }
        catch (ClassCastException classCastException) {
            throw new MalformedObjectNameException("ObjectName: Invalid key : Not a String");
        }
        if (!ObjectName.isValid(string)) {
            throw new MalformedObjectNameException("ObjectName: Invalid key -> " + string);
        }
        Object v = hashtable.get(object);
        if (!(v instanceof String)) {
            throw new MalformedObjectNameException("ObjectName: Invalid value : Not a String");
        }
        if (!ObjectName.isValid((String)v)) {
            throw new MalformedObjectNameException("ObjectName: Invalid value -> " + v);
        }
        map.put(string, v);
    }

    private static String stringify(List list, Hashtable hashtable) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n = 0;
        while (n < list.size()) {
            object = list.get(n);
            stringBuffer.append(string).append(object).append('=').append(hashtable.get(object));
            string = ",";
            ++n;
        }
        object = stringBuffer.substring(0, stringBuffer.length());
        return object;
    }

    private void setDomain(String string) {
        this.domain = string.intern();
    }

    private boolean isDomain(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":=,", true);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return true;
        }
        return n == 1 && !(string2 = stringTokenizer.nextToken()).equals(":") && !string2.equals("=") && !string2.equals(",");
    }

    private static boolean isValid(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":=,*?", true);
        int n = stringTokenizer.countTokens();
        return n == 1 && !(string2 = stringTokenizer.nextToken()).equals(":") && !string2.equals("=") && !string2.equals(",") && !string2.equals("*") && !string2.equals("?");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("domain", this.domain);
        putField.put("propertyList", this.getKeyPropertyList());
        putField.put("propertyListString", this.getKeyPropertyListString());
        putField.put("canonicalName", this.getCanonicalName());
        putField.put("pattern", this.pattern);
        putField.put("propertyPattern", this.propertyPattern);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            this.initObjectName((String)getField.get("domain", ""), (Hashtable)getField.get("propertyList", null), null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IOException(malformedObjectNameException.toString());
        }
        this.pattern = getField.get("pattern", false);
        this.propertyPattern = getField.get("propertyPattern", false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

