/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import weblogic.utils.NestedThrowable;
import weblogic.utils.StackTraceUtils;

public class T3Exception
extends IOException
implements NestedThrowable {
    private Throwable nestedException;
    private String nestedStackTrace;

    protected void setNestedException(Throwable throwable) {
        this.nestedException = throwable;
    }

    public T3Exception(String string) {
        this(string, null);
    }

    public T3Exception() {
    }

    public T3Exception(String string, Throwable throwable) {
        super(string);
        this.nestedException = throwable;
        if (throwable != null) {
            this.nestedStackTrace = StackTraceUtils.throwable2StackTrace(throwable);
        }
    }

    public Throwable getNestedException() {
        return this.nestedException;
    }

    public String toString() {
        return this.nestedException == null ? super.toString() : super.toString() + "\n - with nested exception:\n[" + this.nestedException.toString() + "]";
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.nestedStackTrace != null) {
            printStream.println(this.nestedStackTrace);
            printStream.println("--------------- nested within: ------------------");
        }
        super.printStackTrace(printStream);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public Throwable getNested() {
        return this.nestedException;
    }

    public String superToString() {
        return super.toString();
    }

    public void superPrintStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public void superPrintStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }
}

