/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.utils.StringUtils;

public final class PeerInfo
extends VersionInfo
implements Serializable,
Comparable {
    static final long serialVersionUID = 6364840763020871921L;
    private int major;
    private int minor;
    private int servicePack;
    private int rollingPatch;
    private boolean temporaryPatch;
    private transient boolean isServer;
    private PackageInfo[] packages;
    private static PeerInfo singleton = null;
    private static PeerInfo singletonForWire = null;
    public static final PeerInfo VERSION_60 = new PeerInfo(6, 0, 0);
    public static final PeerInfo VERSION_61 = new PeerInfo(6, 1, 0);
    public static final PeerInfo VERSION_612 = new PeerInfo(6, 1, 2);
    public static final PeerInfo VERSION_613 = new PeerInfo(6, 1, 3);
    public static final PeerInfo VERSION_614 = new PeerInfo(6, 1, 4);
    public static final PeerInfo VERSION_70 = new PeerInfo(7, 0, 0);
    public static final PeerInfo VERSION_701 = new PeerInfo(7, 0, 1);
    public static final PeerInfo VERSION_81 = new PeerInfo(8, 1, 0);
    public static final PeerInfo VERSION_811 = new PeerInfo(8, 1, 1);
    public static final PeerInfo FOREIGN = new PeerInfo(0, 0, 0);
    static /* synthetic */ Class class$weblogic$common$internal$PeerInfo;

    private PeerInfo() {
    }

    private PeerInfo(int n, int n2, int n3) {
        this(n, n2, n3, 0, false, null);
    }

    private PeerInfo(int n, int n2, int n3, int n4, boolean bl, PackageInfo[] packageInfoArray) {
        super(n, n2, n3, n4, bl, packageInfoArray);
        this.major = n;
        this.minor = n2;
        this.servicePack = n3;
        this.rollingPatch = n4;
        this.temporaryPatch = bl;
        this.packages = packageInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerInfo getPeerInfo() {
        if (singleton != null) {
            return singleton;
        }
        Class clazz = class$weblogic$common$internal$PeerInfo == null ? (class$weblogic$common$internal$PeerInfo = PeerInfo.class$("weblogic.common.internal.PeerInfo")) : class$weblogic$common$internal$PeerInfo;
        synchronized (clazz) {
            PeerInfo peerInfo;
            if (singleton != null) {
                return singleton;
            }
            PeerInfo peerInfo2 = peerInfo = new PeerInfo(VersionInfo.theOne().getMajor(), VersionInfo.theOne().getMinor(), VersionInfo.theOne().getServicePack(), VersionInfo.theOne().getRollingPatch(), VersionInfo.theOne().hasTemporaryPatch(), VersionInfo.theOne().getPackages());
            synchronized (peerInfo2) {
                singleton = peerInfo;
            }
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerInfo getPeerInfoForWire() {
        if (singletonForWire != null) {
            return singletonForWire;
        }
        Class clazz = class$weblogic$common$internal$PeerInfo == null ? (class$weblogic$common$internal$PeerInfo = PeerInfo.class$("weblogic.common.internal.PeerInfo")) : class$weblogic$common$internal$PeerInfo;
        synchronized (clazz) {
            PeerInfo peerInfo;
            if (singletonForWire != null) {
                return singletonForWire;
            }
            PeerInfo peerInfo2 = peerInfo = new PeerInfo(VersionInfo.theOne().getMajor(), VersionInfo.theOne().getMinor(), VersionInfo.theOne().getServicePack(), VersionInfo.theOne().getRollingPatch(), VersionInfo.theOne().hasTemporaryPatch(), null);
            synchronized (peerInfo2) {
                singletonForWire = peerInfo;
            }
        }
        return singletonForWire;
    }

    public static PeerInfo getPeerInfo(String string) {
        String[] stringArray = StringUtils.splitCompletely(string, ",");
        if (stringArray.length < 3) {
            return null;
        }
        return new PeerInfo(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
    }

    public PeerInfo(int n, int n2, int n3, Serializable serializable) {
        super(n, n2, n3, 0, false);
        this.major = n;
        this.minor = n2;
        this.servicePack = n3;
    }

    public int compareTo(Object object) {
        PeerInfo peerInfo = (PeerInfo)object;
        int n = this.major - peerInfo.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - peerInfo.minor;
        if (n != 0) {
            return n;
        }
        n = this.servicePack - peerInfo.servicePack;
        if (n != 0) {
            return n;
        }
        n = this.rollingPatch - peerInfo.rollingPatch;
        if (n != 0) {
            return n;
        }
        if (!(this.temporaryPatch ^ peerInfo.temporaryPatch)) {
            return 0;
        }
        return this.temporaryPatch ? 1 : -1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PeerInfo(");
        stringBuffer.append(this.major).append(".");
        stringBuffer.append(this.minor).append(".");
        stringBuffer.append(this.servicePack).append(".");
        stringBuffer.append(this.rollingPatch);
        if (this.temporaryPatch) {
            stringBuffer.append("t");
        }
        stringBuffer.append(", [");
        if (this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                stringBuffer.append(this.packages[i].toString());
                if (i == this.packages.length - 1) continue;
                stringBuffer.append(", ");
            }
        } else {
            stringBuffer.append("none");
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public void setIsServer(boolean bl) {
        this.isServer = bl;
    }

    public boolean isServer() {
        return this.isServer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

