/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersioningError;

public class VersionInfo
extends PackageInfo
implements Serializable {
    private static final long serialVersionUID = -7556401008896489922L;
    private static final String BEA_VENDOR_STRING = "BEA Systems";
    private static final String WEBLOGIC = "WebLogic";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String TEMPORARY_PATCH = "PATCH FOR CR";
    private static VersionInfo theOne;
    private final PackageInfo[] packages;
    private String releaseVersion;
    private byte[] versionInfoAsBytes = null;
    static /* synthetic */ Class class$weblogic$common$internal$VersionInfo;
    static /* synthetic */ Class class$weblogic$common$internal$PackageInfo;

    protected VersionInfo() {
        this.packages = null;
    }

    public VersionInfo(boolean bl) throws VersioningError {
        try {
            this.packages = VersionInfo.getLocalWLPackages();
        }
        catch (IOException iOException) {
            throw new VersioningError("Cannot read manifests from CLASSPATH: " + iOException.getMessage());
        }
        if (this.packages.length == 0) {
            throw new VersioningError("No WebLogic packages defined in CLASSPATH");
        }
        this.implVendor = this.packages[0].getImplementationVendor();
        this.implTitle = this.packages[0].getImplementationTitle();
        this.implVersion = this.packages[0].getImplementationVersion();
        this.major = this.packages[0].getMajor();
        this.minor = this.packages[0].getMinor();
        this.servicePack = this.packages[0].getServicePack();
        this.rollingPatch = this.packages[0].getRollingPatch();
        this.releaseVersion = this.major + "." + this.minor + "." + this.servicePack + "." + this.rollingPatch;
        boolean bl2 = this.temporaryPatch = this.packages[0].getImplementationTitle().toUpperCase().indexOf(TEMPORARY_PATCH) != -1;
        if (!this.temporaryPatch) {
            this.verifyPackages();
        }
    }

    public VersionInfo(int n, int n2, int n3, int n4) throws VersioningError {
        super(n, n2, n3, n4, false);
        this.implVendor = BEA_VENDOR_STRING;
        this.implTitle = "WebLogic Server 8.1 SP4  Mon Nov 29 16:21:29 PST 2004 471647 ";
        this.implVersion = "8.1.4.0";
        this.major = n;
        this.minor = n2;
        this.servicePack = n3;
        this.rollingPatch = n4;
        this.packages = this.initializePackages("8.1.4.0");
        this.releaseVersion = "8.1.4";
    }

    public VersionInfo(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4, bl);
        this.packages = null;
    }

    public VersionInfo(int n, int n2, int n3, int n4, boolean bl, PackageInfo[] packageInfoArray) {
        super(n, n2, n3, n4, bl);
        this.packages = packageInfoArray;
    }

    public static VersionInfo theOne() {
        if (theOne == null) {
            VersionInfo.initialize(true);
        }
        return theOne;
    }

    public VersionInfo(String string) {
        super(BEA_VENDOR_STRING, "WebLogic Server 8.1 SP4  Mon Nov 29 16:21:29 PST 2004 471647 ", string);
        this.packages = this.initializePackages(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean bl) {
        if (theOne == null) {
            Class clazz = class$weblogic$common$internal$VersionInfo == null ? (class$weblogic$common$internal$VersionInfo = VersionInfo.class$("weblogic.common.internal.VersionInfo")) : class$weblogic$common$internal$VersionInfo;
            synchronized (clazz) {
                if (theOne == null) {
                    VersionInfo versionInfo = null;
                    versionInfo = bl ? new VersionInfo(true) : new VersionInfo(8, 1, 4, 0);
                    VersionInfo versionInfo2 = versionInfo;
                    synchronized (versionInfo2) {
                        theOne = versionInfo;
                    }
                }
            }
        }
    }

    private PackageInfo[] initializePackages(String string) {
        return new PackageInfo[]{new PackageInfo(BEA_VENDOR_STRING, "WebLogic Server 8.1 SP4  Mon Nov 29 16:21:29 PST 2004 471647 ", string)};
    }

    public final boolean compatible(String string) {
        try {
            VersionInfo versionInfo = new VersionInfo(string);
            int n = versionInfo.getMajor();
            int n2 = versionInfo.getMinor();
            return (n > 6 || n == 6 && n2 > 0) && Math.abs(n - this.getMajor()) <= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void verifyPackages() {
        for (int i = 1; i < this.packages.length; ++i) {
            if (this.packages[i].getMajor() != this.major || this.packages[i].getMinor() != this.minor) {
                throw new VersioningError("Incompatible packages in CLASSPATH: " + this.packages[0] + " not compatible with " + this.packages[i]);
            }
            if (this.packages[i].getServicePack() != 0 && this.packages[i - 1].getServicePack() != 0 && this.packages[i].getServicePack() != this.packages[i - 1].getServicePack()) {
                throw new VersioningError("Incompatible service packs in CLASSPATH: " + this.packages[0] + " not compatible with " + this.packages[i]);
            }
            if (this.packages[i].getRollingPatch() == 0 || this.packages[i - 1].getRollingPatch() == 0 || this.packages[i].getRollingPatch() == this.packages[i - 1].getRollingPatch()) continue;
            throw new VersioningError("Incompatible rolling patches in CLASSPATH: " + this.packages[0] + " not compatible with " + this.packages[i]);
        }
    }

    public final PackageInfo[] getPackages() {
        return this.packages;
    }

    public final String getReleaseVersion() {
        return this.releaseVersion;
    }

    private static final PackageInfo[] getLocalWLPackages() throws IOException {
        PackageInfo[] packageInfoArray;
        Object object;
        ClassLoader classLoader = (class$weblogic$common$internal$PackageInfo == null ? (class$weblogic$common$internal$PackageInfo = VersionInfo.class$("weblogic.common.internal.PackageInfo")) : class$weblogic$common$internal$PackageInfo).getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> enumeration = classLoader.getResources(MANIFEST);
        ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
        while (enumeration.hasMoreElements()) {
            String string;
            object = enumeration.nextElement();
            packageInfoArray = ((URL)object).openStream();
            Manifest manifest = new Manifest((InputStream)packageInfoArray);
            Attributes attributes = manifest.getMainAttributes();
            String string2 = (String)attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
            if (string2 == null || !string2.equals(BEA_VENDOR_STRING) || !(string = (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE)).startsWith(WEBLOGIC)) continue;
            arrayList.add(new PackageInfo((String)attributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION)));
        }
        object = arrayList.toArray();
        packageInfoArray = new PackageInfo[((Object[])object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            packageInfoArray[i] = (PackageInfo)object[i];
        }
        return packageInfoArray;
    }

    public final byte[] getVersionInfoForNetworkClassLoader() {
        if (this.versionInfoAsBytes == null) {
            String string = Attributes.Name.IMPLEMENTATION_VENDOR + ": " + this.packages[0].getImplementationVendor();
            String string2 = Attributes.Name.IMPLEMENTATION_TITLE + ": " + this.packages[0].getImplementationTitle();
            String string3 = Attributes.Name.IMPLEMENTATION_VERSION + ": " + this.packages[0].getImplementationVersion();
            this.versionInfoAsBytes = (string + "\n" + string2 + "\n" + string3 + "\n").getBytes();
        }
        return this.versionInfoAsBytes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

