/*
 * Decompiled with CFR 0.152.
 */
package weblogic.health;

import java.io.Serializable;

public class HealthState
implements Serializable {
    private static final long serialVersionUID = -8954060526499390055L;
    public static final int HEALTH_OK = 0;
    public static final int HEALTH_WARN = 1;
    public static final int HEALTH_CRITICAL = 2;
    public static final int HEALTH_FAILED = 3;
    private static final String[] NULL_REASONS = new String[0];
    private int state;
    private String[] reasonCode;

    public HealthState(int n) {
        this(n, NULL_REASONS);
    }

    public HealthState(int n, String string) {
        this.state = n;
        this.reasonCode = new String[]{string};
    }

    public HealthState(int n, String[] stringArray) {
        this.state = n;
        this.reasonCode = stringArray;
    }

    public int getState() {
        return this.state;
    }

    public String[] getReasonCode() {
        return this.reasonCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("State:" + this.mapToString(this.state) + ",");
        stringBuffer.append("ReasonCode:[");
        if (this.reasonCode != null && this.reasonCode.length > 0) {
            for (int i = 0; i < this.reasonCode.length - 1; ++i) {
                stringBuffer.append(this.reasonCode[i] + ",");
            }
            stringBuffer.append(this.reasonCode[this.reasonCode.length - 1] + "]");
        }
        return stringBuffer.toString();
    }

    private String mapToString(int n) {
        switch (n) {
            case 0: {
                return "HEALTH_OK";
            }
            case 1: {
                return "HEALTH_WARN";
            }
            case 2: {
                return "HEALTH_CRITICAL";
            }
            case 3: {
                return "HEALTH_FAILED";
            }
        }
        return "UNKNOWN";
    }
}

