/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n;

import java.text.DecimalFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Localizer {
    public static final String VERSION = "version";
    public static final String L10N_PACKAGE = "L10nPackage";
    public static final String I18N_PACKAGE = "I18nPackage";
    public static final String SUBSYSTEM = "subsystem";
    public static final String PREFIX = "prefix";
    public static final String SEVERITY = "severity";
    public static final String MESSAGE_BODY = "messagebody";
    public static final String MESSAGE_DETAIL = "messagedetail";
    public static final String CAUSE = "cause";
    public static final String ACTION = "action";
    public static final String STACKTRACE = "stack";
    public static final String[] SERVER_SEVERITIES = new String[]{"Emergency".toLowerCase(), "Alert".toLowerCase(), "Critical".toLowerCase(), "Notice".toLowerCase(), "Error".toLowerCase(), "Warning".toLowerCase(), "Info".toLowerCase(), "Debug".toLowerCase()};
    public static final String[] NON_SERVER_SEVERITIES = new String[]{"Error".toLowerCase(), "Warning".toLowerCase(), "Info".toLowerCase(), "Debug".toLowerCase()};
    public static final String PREFIX_DELIM = "-";
    private ResourceBundle bundle;

    public Localizer(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getVersion() throws MissingResourceException {
        return (String)this.bundle.getObject(VERSION);
    }

    public String getL10nPackage() throws MissingResourceException {
        return (String)this.bundle.getObject(L10N_PACKAGE);
    }

    public String getI18nPackage() throws MissingResourceException {
        return (String)this.bundle.getObject(I18N_PACKAGE);
    }

    public String getSubSystem() throws MissingResourceException {
        return (String)this.bundle.getObject(SUBSYSTEM);
    }

    public String getPrefix() {
        String string = null;
        try {
            string = (String)this.bundle.getObject(PREFIX);
            if (string != null && string.length() == 0) {
                string = null;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    public Object getObject(String string, String string2) throws MissingResourceException {
        return this.bundle.getObject(string + this.prune(string2));
    }

    public Object getObject(String string, int n) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getObject(string, decimalFormat.format(n));
    }

    public String getString(String string, String string2) throws MissingResourceException {
        return this.getObject(string, string2).toString();
    }

    public String getString(String string, int n) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getString(string, decimalFormat.format(n));
    }

    public String get(String string) {
        return this.getString("", string);
    }

    public String getBody(String string) {
        try {
            return (String)this.getObject(MESSAGE_BODY, string);
        }
        catch (MissingResourceException missingResourceException) {
            return new String();
        }
    }

    public String getDetail(String string) {
        try {
            return (String)this.getObject(MESSAGE_DETAIL, string);
        }
        catch (MissingResourceException missingResourceException) {
            return new String();
        }
    }

    public String getCause(String string) {
        try {
            return (String)this.getObject(CAUSE, string);
        }
        catch (MissingResourceException missingResourceException) {
            return new String();
        }
    }

    public String getAction(String string) {
        try {
            return (String)this.getObject(ACTION, string);
        }
        catch (MissingResourceException missingResourceException) {
            return new String();
        }
    }

    public int getSeverity(String string) {
        try {
            return new Integer((String)this.getObject(SEVERITY, string));
        }
        catch (MissingResourceException missingResourceException) {
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean getStackTrace(String string) {
        try {
            return ((String)this.getObject(STACKTRACE, string)).equals("true");
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    private String prune(String string) {
        String string2 = this.getPrefix();
        String string3 = string;
        if (string2 != null && string.indexOf(string2 + PREFIX_DELIM) != -1) {
            string3 = string.substring(string2.length() + 1);
        }
        return string3;
    }
}

