/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18ntools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;

public final class L10nLookup
extends Properties {
    private static boolean verbose = false;
    private static final String path = "weblogic/i18n/i18n.properties";
    private static final String userPath = "i18n_user.properties";
    private static final int CACHE_SIZE = 50;
    private static L10nLookup l10nLookup = null;
    private static int hits = 0;
    private static int misses = 0;
    private Map localizers;
    private Vector subSystems;
    static /* synthetic */ Class class$weblogic$i18ntools$L10nLookup;

    public static L10nLookup getL10n() {
        L10nLookup.init();
        return l10nLookup;
    }

    private static void init(URLConnection uRLConnection) {
    }

    public void load(String string) throws IOException {
        L10nLookup.init();
        this.loadProps(string, false);
    }

    public void load(InputStream inputStream) throws IOException {
        L10nLookup.init();
        super.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(String string, boolean bl) throws IOException {
        URL uRL;
        Object object;
        Enumeration<URL> enumeration;
        InputStream inputStream = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (verbose) {
            L10nLookup.logger("Loading props from " + string);
        }
        if ((enumeration = Thread.currentThread().getContextClassLoader().getResources(string)) != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (verbose) {
                    L10nLookup.logger("Adding " + object);
                }
                hashSet.add(object);
            }
        }
        if (bl) {
            object = (class$weblogic$i18ntools$L10nLookup == null ? (class$weblogic$i18ntools$L10nLookup = L10nLookup.class$("weblogic.i18ntools.L10nLookup")) : class$weblogic$i18ntools$L10nLookup).getClassLoader();
            if (object == null) {
                object = ClassLoader.getSystemClassLoader();
            }
            if ((enumeration = ((ClassLoader)object).getResources(string)) != null) {
                while (enumeration.hasMoreElements()) {
                    uRL = enumeration.nextElement();
                    if (verbose) {
                        L10nLookup.logger("Adding " + uRL);
                    }
                    hashSet.add(uRL);
                }
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            uRL = (URL)object.next();
            if (verbose) {
                L10nLookup.logger("Loading from " + uRL);
            }
            try {
                inputStream = uRL.openStream();
                super.load(inputStream);
            }
            catch (IOException iOException) {
                if (verbose) {
                    L10nLookup.logger("Skipping " + uRL);
                }
                if (!bl) continue;
                throw iOException;
            }
            finally {
                this.closeIS(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (l10nLookup == null) {
            Class clazz = class$weblogic$i18ntools$L10nLookup == null ? (class$weblogic$i18ntools$L10nLookup = L10nLookup.class$("weblogic.i18ntools.L10nLookup")) : class$weblogic$i18ntools$L10nLookup;
            synchronized (clazz) {
                if (l10nLookup == null) {
                    l10nLookup = new L10nLookup();
                    if (verbose) {
                        L10nLookup.logger("I18n properties: weblogic/i18n/i18n.properties");
                        L10nLookup.logger("I18n user properties: i18n_user.properties");
                    }
                }
            }
        }
    }

    public Object put(Object object, Object object2) {
        return super.put(object, ((String)object2).intern());
    }

    private void closeIS(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void logger(String string) {
        System.out.println(string);
    }

    private L10nLookup() {
        block4: {
            this.localizers = Collections.synchronizedMap(new HashMap(50, 1.0f));
            try {
                this.loadProps(path, true);
            }
            catch (IOException iOException) {
                L10nLookup.logger("Unable to access I18n properties file, weblogic/i18n/i18n.properties: " + iOException.toString());
            }
            try {
                this.loadProps(userPath, true);
            }
            catch (IOException iOException) {
                if (!verbose) break block4;
                L10nLookup.logger("Unable to access I18n user properties file, i18n_user.properties: " + iOException.toString());
            }
        }
    }

    public Localizer getLocalizer(String string, Locale locale) throws MissingResourceException {
        return this.getLocalizer(string, locale, false);
    }

    public Localizer getLocalizer(String string, Locale locale, boolean bl) throws MissingResourceException {
        String string2;
        String string3 = string;
        String string4 = null;
        if (string3.indexOf("-") != -1) {
            string3 = string3.substring(string.indexOf("-") + 1);
            string4 = string.substring(0, string.indexOf("-"));
        }
        if ((string2 = this.getProperty(string3)) == null) {
            try {
                if (Integer.valueOf(string3) < 500000) {
                    this.loadProps(path, false);
                } else {
                    this.loadProps(userPath, false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string2 = this.getProperty(string3);
            if (string2 == null) {
                throw new MissingResourceException("No localizer class found for message id.", "unknown", string3);
            }
        }
        if (verbose) {
            L10nLookup.logger("Localizer is " + string2);
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != ':') continue;
            String string5 = string2.substring(++i);
            if (bl) {
                string5 = string5.concat("Detail");
            }
            if (verbose) {
                L10nLookup.logger("Getting bundle for " + string5);
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string5, locale, Thread.currentThread().getContextClassLoader());
            Localizer localizer = new Localizer(resourceBundle);
            if (string4 != null && !string4.equals(localizer.getPrefix())) {
                throw new MissingResourceException("Prefix (" + string4 + ") in message id, " + string + ", does not match prefix in Localizer, " + localizer.getPrefix(), localizer.getClass().getName(), string3);
            }
            return localizer;
        }
        throw new MissingResourceException("Invalid I18n resource for " + string3 + ". Resource is " + string2, "weblogic.i18n.Localizer", string3);
    }

    public Localizer getLocalizer(int n, Locale locale) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getLocalizer(decimalFormat.format(n), locale, false);
    }

    public Localizer getLocalizer(String string) throws MissingResourceException {
        return this.getLocalizer(string, Locale.getDefault(), false);
    }

    public Localizer getLocalizer(int n) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getLocalizer(decimalFormat.format(n), Locale.getDefault(), false);
    }

    public static Localizer getLocalizer(Locale locale, String string) throws MissingResourceException {
        Localizer localizer;
        ClassLoader classLoader;
        L10nLookup.init();
        if (string == null) {
            throw new NullPointerException("No class name provided");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((classLoader = (class$weblogic$i18ntools$L10nLookup == null ? (class$weblogic$i18ntools$L10nLookup = L10nLookup.class$("weblogic.i18ntools.L10nLookup")) : class$weblogic$i18ntools$L10nLookup).getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            if (verbose) {
                L10nLookup.logger("no system loader");
            }
            if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                if (verbose) {
                    L10nLookup.logger("no context loader");
                }
            } else if (verbose) {
                L10nLookup.logger("Using context loader");
            }
        }
        if ((localizer = l10nLookup.getLocalizerBundle(string, locale, classLoader)) == null && (localizer = l10nLookup.getLocalizerBundle(string, locale, classLoader = Thread.currentThread().getContextClassLoader())) == null) {
            throw new MissingResourceException("Can't locate bundle for class", string, "");
        }
        return localizer;
    }

    private Localizer getLocalizerBundle(String string, Locale locale, ClassLoader classLoader) {
        LocalizerKey localizerKey = new LocalizerKey(string, locale, classLoader);
        Localizer localizer = this.getCachedLocalizer(localizerKey);
        if (localizer == null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
                localizer = new Localizer(resourceBundle);
                this.addCachedLocalizer(localizerKey, localizer);
                ++misses;
            }
            catch (MissingResourceException missingResourceException) {}
        } else {
            ++hits;
        }
        if (verbose) {
            L10nLookup.logger("hit ratio: " + hits + "/" + misses);
        }
        return localizer;
    }

    private Localizer getCachedLocalizer(LocalizerKey localizerKey) {
        return (Localizer)this.localizers.get(localizerKey);
    }

    private void addCachedLocalizer(LocalizerKey localizerKey, Localizer localizer) {
        this.localizers.put(localizerKey, localizer);
    }

    public Vector getSubSystems() {
        if (this.subSystems == null) {
            this.subSystems = new Vector();
            Enumeration<Object> enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String string2 = string.substring(0, n = string.indexOf(58));
                if (this.subSystems.contains(string2)) continue;
                this.subSystems.add(string2);
            }
        }
        return this.subSystems;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

