/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.Context;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSConnectionConsumerCreateResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.DispatcherWrapperState;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManager;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.frontend.FEConnectionCloseRequest;
import weblogic.jms.frontend.FEConnectionConsumerCreateRequest;
import weblogic.jms.frontend.FEConnectionSetClientIdRequest;
import weblogic.jms.frontend.FEConnectionStartRequest;
import weblogic.jms.frontend.FEConnectionStopRequest;
import weblogic.jms.frontend.FERemoveSubscriptionRequest;
import weblogic.jms.frontend.FESessionCreateRequest;
import weblogic.jms.frontend.FESessionCreateResponse;
import weblogic.jms.frontend.FETemporaryDestinationDestroyRequest;
import weblogic.kernel.Kernel;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class JMSConnection
implements QueueConnection,
TopicConnection,
ConnectionMetaData,
JMSPeerGoneListener,
Externalizable,
Invocable {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private final SubjectManager subjectManager = SubjectManager.getSubjectManager();
    static final long serialVersionUID = 7025750175126041724L;
    public static final byte EXTVERSION61 = 1;
    public static final byte EXTVERSION70 = 3;
    public static final byte EXTVERSION81 = 4;
    private static final byte VERSION_MASK = 15;
    public static final byte TIMEOUT_MASK = 64;
    private static final byte EXTVERSION = 4;
    private static final String JMS_PROVIDER_NAME = "BEA Systems, Inc.";
    private static final String PROVIDER_VERSION = "8.1.0";
    private static final int PROVIDER_MAJOR_VERSION = 8;
    private static final int PROVIDER_MINOR_VERSION = 1;
    static final int TYPE_QUEUE = 1;
    static final int TYPE_TOPIC = 2;
    private JMSID connectionId;
    private String clientId;
    protected int type;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver;
    private long timeToLive;
    private long sendTimeout;
    private long redeliveryDelay;
    private boolean userTransactionsEnabled;
    private boolean allowCloseInOnMessage;
    private long transactionTimeout;
    private boolean isLocal;
    private int messagesMaximum;
    private int overrunPolicy;
    private int acknowledgePolicy;
    private String wlsServerName;
    private String runtimeMBeanName;
    private boolean flowControl;
    private int flowMinimum;
    private int flowMaximum;
    private double flowDecrease;
    private int flowIncrease;
    private long flowInterval;
    private boolean xaServerEnabled;
    private boolean stopped = true;
    private String sublock = new String("");
    protected transient ExceptionListener exceptionListener = null;
    private HashMap sessions = new HashMap();
    private HashMap durableSubscribers = new HashMap();
    private Dispatcher dispatcher;
    private DispatcherWrapper dispatcherWrapper;
    private ClassLoader exceptionListenerClassLoader;
    private Context exceptionListenerContext;
    private AbstractSubject exceptionListenerSubject;
    private PeerVersionable peerVersionable;
    private byte version = (byte)4;
    private PeerInfo peerInfo;
    private static int connectionCount = 0;
    private String dispatchPolicyName = "weblogic.kernel.Default";
    private transient int refCount;

    public JMSConnection(JMSID jMSID, String string, int n, int n2, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2, int n3, int n4, int n5, boolean bl3, DispatcherWrapper dispatcherWrapper, boolean bl4, int n6, int n7, int n8, int n9, boolean bl5, PeerVersionable peerVersionable, String string2, String string3, PeerInfo peerInfo) {
        this.peerVersionable = peerVersionable;
        this.connectionId = jMSID;
        this.clientId = string;
        this.deliveryMode = n;
        this.priority = n2;
        this.timeToDeliver = l;
        this.timeToLive = l2;
        this.sendTimeout = l3;
        this.redeliveryDelay = l4;
        this.transactionTimeout = l5;
        this.userTransactionsEnabled = bl;
        this.allowCloseInOnMessage = bl2;
        this.messagesMaximum = n3;
        this.overrunPolicy = n4;
        this.acknowledgePolicy = n5;
        this.isLocal = bl3;
        this.dispatcherWrapper = dispatcherWrapper;
        this.xaServerEnabled = bl5;
        this.flowControl = bl4;
        this.flowMinimum = n6;
        this.flowMaximum = n7;
        this.wlsServerName = string2;
        this.runtimeMBeanName = string3;
        this.flowIncrease = (n7 - n6) / n9;
        if (this.flowIncrease < 1) {
            this.flowIncrease = 1;
        }
        this.flowDecrease = (double)n6 / (double)n7;
        this.flowDecrease = Math.pow(this.flowDecrease, 1.0 / (double)n9);
        this.flowInterval = n8 * 1000 / n9;
        if (this.flowInterval < 1L) {
            this.flowInterval = 1L;
        }
        this.peerInfo = peerInfo;
    }

    void setupDispatcher() throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.getLocalDispatcher().getId().equals(this.dispatcherWrapper.getId()) ? DispatcherManager.getLocalDispatcher() : new DispatcherWrapperState(this.dispatcherWrapper);
        this.dispatcher = DispatcherManager.get().addDispatcherReference(dispatcher);
        this.dispatcher.addDispatcherPeerGoneListener(this);
    }

    static synchronized void incrementConnectionCount() {
        if (++connectionCount == 1) {
            DispatcherManager.create();
            DispatcherManager.exportLocalDispatcher();
        }
    }

    static synchronized void decrementConnectionCount() {
        if (--connectionCount == 0) {
            DispatcherManager.get();
            DispatcherManager.unexportLocalDispatcher();
        }
    }

    void setType(int n) {
        this.type = n;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Destination destination, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException("Unsupported topic operation for QueueConnection");
        }
        throw new weblogic.jms.common.JMSException("Durable connection consumers are not supported");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, string, serverSessionPool, n);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createDurableConnectionConsumer((Destination)topic, string, string2, serverSessionPool, n);
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (n == 128) {
            throw new weblogic.jms.common.JMSException("QueueSessions do not support multicast");
        }
        JMSSession jMSSession = this.createSessionInternal(bl, n, false);
        jMSSession.setType(2);
        return jMSSession;
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        JMSSession jMSSession = this.createSessionInternal(bl, n, false);
        jMSSession.setType(1);
        return jMSSession;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return this.createSessionInternal(bl, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSSession createSessionInternal(boolean bl, int n, boolean bl2) throws JMSException {
        JMSSession jMSSession;
        if (bl2) {
            bl = false;
            n = 2;
            jMSSession = new JMSXASession(this, bl, n, this.isStopped());
        } else {
            jMSSession = new JMSSession(this, bl, n, this.isStopped());
        }
        if (this.xaServerEnabled && Kernel.isServer()) {
            jMSSession.setUserTransactionsEnabled(true);
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FESessionCreateRequest(this.connectionId, bl, n));
        jMSSession.setId(((FESessionCreateResponse)response).getSessionId());
        jMSSession.setRuntimeMBeanName(((FESessionCreateResponse)response).getRuntimeMBeanName());
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSConnection (id: " + this.connectionId + ") : " + "Created JMSSession (id: " + jMSSession.getId() + ")");
        }
        JMSConnection jMSConnection = this;
        synchronized (jMSConnection) {
            this.sessionAdd(jMSSession);
        }
        return jMSSession;
    }

    public Dispatcher getFrontEndDispatcher() throws JMSException {
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher != null) {
            return dispatcher;
        }
        throw new IllegalStateException("Connection is closed");
    }

    private void sessionAdd(JMSSession jMSSession) throws JMSException {
        if (this.sessions.put(jMSSession.getId(), jMSSession) != null) {
            throw new weblogic.jms.common.JMSException("Duplicate session");
        }
        InvocableManager.invocableAdd(4, jMSSession);
    }

    synchronized void sessionRemove(JMSID jMSID) throws JMSException {
        if (this.sessions.remove(jMSID) == null) {
            throw new weblogic.jms.common.JMSException("Session not found");
        }
        InvocableManager.invocableRemove(4, jMSID);
    }

    synchronized JMSSession sessionFind(JMSID jMSID) {
        return (JMSSession)this.sessions.get(jMSID);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, string, serverSessionPool, n);
    }

    public synchronized String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientId;
    }

    public synchronized void setClientID(String string) throws JMSException {
        if (this.clientId != null) {
            throw new IllegalStateException("ClientID is already set");
        }
        if (string == null) {
            throw new weblogic.jms.common.JMSException("ClientID is null");
        }
        if (string.length() == 0) {
            throw new weblogic.jms.common.JMSException("Zero length clientID");
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionSetClientIdRequest(this.connectionId, string));
        this.clientId = string;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this;
    }

    public synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = exceptionListener;
        this.saveContext();
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void start() throws JMSException {
        Object object;
        JMSException jMSException = null;
        this.checkClosed();
        if (!this.stopped) {
            return;
        }
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            object = (JMSSession)iterator.next();
            try {
                ((JMSSession)object).start();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        object = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStartRequest(this.connectionId));
        this.stopped = false;
        if (jMSException != null) {
            throw jMSException;
        }
    }

    public synchronized void stop() throws JMSException {
        this.checkClosed();
        JMSException jMSException = null;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStopRequest(this.connectionId));
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            JMSSession jMSSession = (JMSSession)iterator.next();
            try {
                jMSSession.stop();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        block15: {
            if (this.isClosed()) {
                return;
            }
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "CLIENT/JMSConnection (id: " + this.connectionId + ") : Closing");
            }
            Dispatcher dispatcher = null;
            try {
                JMSException jMSException = null;
                Externalizable externalizable = this;
                synchronized (externalizable) {
                    Iterator iterator = ((HashMap)this.sessions.clone()).values().iterator();
                    while (iterator.hasNext()) {
                        JMSSession jMSSession = (JMSSession)iterator.next();
                        try {
                            jMSSession.close();
                        }
                        catch (JMSException jMSException2) {
                            if (jMSException != null) continue;
                            jMSException = jMSException2;
                        }
                    }
                    dispatcher = this.dispatcher;
                    this.closeDispatcher();
                    this.exceptionListener = null;
                    this.stopped = true;
                }
                if (JMSDebug.debugJMSCommon) {
                    JMSDebug.debug(16, "CLIENT/JMSConnection (id: " + this.connectionId + ") : " + "Dispatching the connection close request to frontend");
                }
                externalizable = dispatcher.dispatchSync(new FEConnectionCloseRequest(this.connectionId));
                if (jMSException != null) {
                    throw jMSException;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                InvocableManager.invocableRemove(3, this.getId());
                DispatcherManager dispatcherManager = DispatcherManager.get();
                if (dispatcher != null) {
                    dispatcherManager.dispatcherRemoveReference(dispatcher, false);
                    if (!this.isLocal) {
                        dispatcher.removeDispatcherPeerGoneListener(this);
                    }
                }
                throw throwable;
            }
            InvocableManager.invocableRemove(3, this.getId());
            DispatcherManager dispatcherManager = DispatcherManager.get();
            if (dispatcher == null) break block15;
            dispatcherManager.dispatcherRemoveReference(dispatcher, false);
            if (!this.isLocal) {
                dispatcher.removeDispatcherPeerGoneListener(this);
            }
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    protected void saveContext() {
        this.exceptionListenerSubject = this.subjectManager.getCurrentSubject(KERNEL_ID);
        if (Kernel.isServer() && this.exceptionListener != null) {
            this.exceptionListenerClassLoader = this.exceptionListener.getClass().getClassLoader();
            this.exceptionListenerContext = JMSServerUtilities.getLocalJNDIContext();
        }
    }

    protected ClassLoader pushContext() {
        if (Kernel.isServer()) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (this.exceptionListenerClassLoader != classLoader) {
                Thread.currentThread().setContextClassLoader(this.exceptionListenerClassLoader);
            }
            JMSServerUtilities.pushLocalJNDIContext((Context)this.exceptionListenerContext);
            return classLoader;
        }
        return null;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (!Kernel.isServer()) {
            throw new IllegalStateException("connection consumer only supported on server");
        }
        this.checkClosed();
        if (n == 0 || n < -1) {
            throw new weblogic.jms.common.JMSException("Invalid value for messagesMaximum, " + n);
        }
        if (destination == null) {
            throw new InvalidDestinationException("Destination is null");
        }
        if (!(destination instanceof DestinationImpl)) {
            throw new InvalidDestinationException("Foreign destination");
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionConsumerCreateRequest(this.getId(), serverSessionPool, (DestinationImpl)destination, false, string, n, true));
        return ((JMSConnectionConsumerCreateResponse)response).getConnectionConsumer();
    }

    protected void popContext(ClassLoader classLoader) {
        if (Kernel.isServer()) {
            JMSServerUtilities.popLocalJNDIContext();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(JMSException jMSException) {
        Object object;
        Object object2;
        Object object3 = this;
        synchronized (object3) {
            this.closeDispatcher();
            object2 = ((HashMap)this.sessions.clone()).values().iterator();
            while (object2.hasNext()) {
                object = (JMSSession)object2.next();
                try {
                    ((JMSSession)object).close();
                }
                catch (Throwable throwable) {}
            }
        }
        ExceptionListener exceptionListener = this.exceptionListener;
        if (exceptionListener != null) {
            object3 = this.pushContext();
            try {
                object2 = exceptionListener;
                synchronized (object2) {
                    object = exceptionListener;
                    JMSException jMSException2 = jMSException;
                    try {
                        try {
                            this.exceptionListenerSubject.doAs(KERNEL_ID, new PrivilegedExceptionAction((ExceptionListener)object, jMSException2){
                                private final /* synthetic */ ExceptionListener val$finalExceptionListener;
                                private final /* synthetic */ JMSException val$finalException;
                                {
                                    this.val$finalExceptionListener = exceptionListener;
                                    this.val$finalException = jMSException;
                                }

                                public Object run() throws JMSException {
                                    this.val$finalExceptionListener.onException(this.val$finalException);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.popContext((ClassLoader)object3);
            }
        }
    }

    private boolean isJMS110() {
        Field field;
        try {
            Class<?> clazz = Class.forName("javax.jms.Session");
            field = clazz.getDeclaredField("SESSION_TRANSACTED");
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field != null;
    }

    public String getJMSVersion() {
        if (this.isJMS110()) {
            return "1.1";
        }
        return "1.0.2b";
    }

    public int getJMSMajorVersion() {
        return 1;
    }

    public int getJMSMinorVersion() {
        if (this.isJMS110()) {
            return 1;
        }
        return 0;
    }

    public String getJMSProviderName() {
        return JMS_PROVIDER_NAME;
    }

    public String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    public int getProviderMajorVersion() {
        return 8;
    }

    public int getProviderMinorVersion() {
        return 1;
    }

    public Enumeration getJMSXPropertyNames() {
        Vector<String> vector = new Vector<String>(2);
        vector.add(0, "JMSXGroupID");
        vector.add(0, "JMSXGroupSeq");
        return vector.elements();
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void jmsPeerGone(Exception exception, Dispatcher dispatcher) {
        this.onException(new LostServerException(exception.toString()));
    }

    public synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    public String getWLSServerName() {
        return this.wlsServerName;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public String toString() {
        return this.getRuntimeMBeanName();
    }

    int getDeliveryMode() {
        return this.deliveryMode;
    }

    int getPriority() {
        return this.priority;
    }

    long getTimeToDeliver() {
        return this.timeToDeliver;
    }

    long getTimeToLive() {
        return this.timeToLive;
    }

    long getSendTimeout() {
        return this.sendTimeout;
    }

    long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    int getAcknowledgePolicy() {
        return this.acknowledgePolicy;
    }

    int getOverrunPolicy() {
        return this.overrunPolicy;
    }

    public boolean isXAServerEnabled() {
        return this.xaServerEnabled;
    }

    boolean isFlowControlEnabled() {
        return this.flowControl;
    }

    int getFlowMinimum() {
        return this.flowMinimum;
    }

    int getFlowMaximum() {
        return this.flowMaximum;
    }

    int getFlowIncrease() {
        return this.flowIncrease;
    }

    double getFlowDecrease() {
        return this.flowDecrease;
    }

    long getFlowInterval() {
        return this.flowInterval;
    }

    int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public boolean getUserTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    public boolean getAllowCloseInOnMessage() {
        return this.allowCloseInOnMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDurableSubscriber(String string) {
        String string2 = this.sublock;
        synchronized (string2) {
            return this.durableSubscribers.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markDurableSubscriber(String string) {
        String string2 = this.sublock;
        synchronized (string2) {
            if (this.durableSubscribers.get(string) != null) {
                return false;
            }
            return this.durableSubscribers.put(string, new Object()) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addDurableSubscriber(String string, Object object) {
        String string2 = this.sublock;
        synchronized (string2) {
            return this.durableSubscribers.put(string, object) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeDurableSubscriber(String string) {
        String string2 = this.sublock;
        synchronized (string2) {
            return this.durableSubscribers.remove(string) != null;
        }
    }

    synchronized String getDispatchPolicy() {
        return this.dispatchPolicyName;
    }

    public synchronized void setDispatchPolicy(String string) {
        this.dispatchPolicyName = string;
    }

    public JMSID getId() {
        return this.connectionId;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public void destroyTemporaryDestination(JMSServerId jMSServerId, JMSID jMSID) throws JMSException {
        this.checkClosed();
        Response response = this.dispatcher.dispatchSync(new FETemporaryDestinationDestroyRequest(this.getId(), jMSID));
    }

    void consumerRemove(String string) throws JMSException {
        Response response = this.dispatcher.dispatchSync(new FERemoveSubscriptionRequest(this.clientId, string));
    }

    private void closeDispatcher() {
        this.dispatcher = null;
        JMSConnection.decrementConnectionCount();
    }

    boolean isClosed() {
        return this.dispatcher == null;
    }

    void checkClosed() throws JMSException {
        this.getFrontEndDispatcher();
    }

    public byte getPeerVersion() {
        return this.version;
    }

    public JMSConnection() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte by;
        byte by2 = by = this.getVersion(objectOutput);
        if (by >= 4 && this.sendTimeout != 10L) {
            by2 = (byte)(by2 | 0x40);
        }
        if (this.peerVersionable != null) {
            this.peerVersionable.setPeerVersion(by);
        }
        objectOutput.writeByte(by2);
        this.connectionId.writeExternal(objectOutput);
        if (this.clientId == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.clientId);
        }
        objectOutput.writeInt(this.deliveryMode);
        objectOutput.writeInt(this.priority);
        objectOutput.writeInt(this.messagesMaximum);
        objectOutput.writeInt(this.overrunPolicy);
        objectOutput.writeLong(this.timeToDeliver);
        objectOutput.writeLong(this.timeToLive);
        objectOutput.writeLong(this.redeliveryDelay);
        objectOutput.writeLong(this.transactionTimeout);
        objectOutput.writeBoolean(this.userTransactionsEnabled);
        objectOutput.writeBoolean(this.allowCloseInOnMessage);
        objectOutput.writeInt(this.acknowledgePolicy);
        this.dispatcherWrapper.writeExternal(objectOutput);
        if (by >= 3) {
            objectOutput.writeBoolean(this.flowControl);
            if (this.flowControl) {
                objectOutput.writeInt(this.flowMinimum);
                objectOutput.writeInt(this.flowMaximum);
                objectOutput.writeInt(this.flowIncrease);
                objectOutput.writeDouble(this.flowDecrease);
                objectOutput.writeLong(this.flowInterval);
            }
            objectOutput.writeBoolean(this.xaServerEnabled);
        }
        if (by >= 4) {
            objectOutput.writeUTF(this.wlsServerName);
            objectOutput.writeUTF(this.runtimeMBeanName);
            if (this.sendTimeout != 10L) {
                objectOutput.writeLong(this.sendTimeout);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0xF);
        switch (by2) {
            case 1: 
            case 3: 
            case 4: {
                this.version = by2;
                break;
            }
            default: {
                throw JMSUtilities.versionIOException(by2, 1, 4);
            }
        }
        this.connectionId = new JMSID();
        this.connectionId.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.clientId = objectInput.readUTF();
        }
        this.deliveryMode = objectInput.readInt();
        this.priority = objectInput.readInt();
        this.messagesMaximum = objectInput.readInt();
        this.overrunPolicy = objectInput.readInt();
        this.timeToDeliver = objectInput.readLong();
        this.timeToLive = objectInput.readLong();
        this.redeliveryDelay = objectInput.readLong();
        this.transactionTimeout = objectInput.readLong();
        this.userTransactionsEnabled = objectInput.readBoolean();
        this.allowCloseInOnMessage = objectInput.readBoolean();
        this.acknowledgePolicy = objectInput.readInt();
        this.dispatcherWrapper = new DispatcherWrapper();
        this.dispatcherWrapper.readExternal(objectInput);
        if (by2 >= 3) {
            this.flowControl = objectInput.readBoolean();
            if (this.flowControl) {
                this.flowMinimum = objectInput.readInt();
                this.flowMaximum = objectInput.readInt();
                this.flowIncrease = objectInput.readInt();
                this.flowDecrease = objectInput.readDouble();
                this.flowInterval = objectInput.readLong();
            }
            this.xaServerEnabled = objectInput.readBoolean();
        }
        if (by2 >= 4) {
            this.wlsServerName = objectInput.readUTF();
            this.runtimeMBeanName = objectInput.readUTF();
            this.sendTimeout = (by & 0x40) != 0 ? objectInput.readLong() : 10L;
        }
    }

    public int pushException(Request request) throws JMSException {
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        weblogic.jms.common.JMSException jMSException = jMSPushExceptionRequest.getException();
        try {
            this.onException(jMSPushExceptionRequest.getException());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15363: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
    }

    protected byte getVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        PeerInfo peerInfo2 = this.peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()) != null) {
            peerInfo2 = peerInfo;
        }
        if (peerInfo2 != null) {
            if (peerInfo2.compareTo(PeerInfo.VERSION_81) >= 0) {
                return 4;
            }
            if (peerInfo2.compareTo(PeerInfo.VERSION_70) >= 0) {
                return 3;
            }
            return 1;
        }
        return 4;
    }
}

