/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherException;
import weblogic.jms.dispatcher.DispatcherManager;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.InvocableManager;
import weblogic.jms.frontend.FEConnectionCreateRequest;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.rmi.extensions.server.RemoteWrapper;

public class JMSConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
Externalizable,
RemoteWrapper {
    static final long serialVersionUID = 2752718129231506407L;
    static final byte EXTVERSION1 = 1;
    static final byte EXTVERSION2 = 2;
    private static final byte INTERFACE_VERSION_PRE_81 = 0;
    private static final byte INTERFACE_VERSION_81 = 1;
    private static final byte INTERFACE_VERSION_CURRENT = 1;
    private FEConnectionFactoryRemote feConnectionFactoryRemote;
    private byte interfaceVersion = 1;

    public JMSConnectionFactory() {
    }

    public JMSConnectionFactory(FEConnectionFactoryRemote fEConnectionFactoryRemote) {
        this.feConnectionFactoryRemote = fEConnectionFactoryRemote;
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(string, string2, false);
        jMSConnection.setType(1);
        return jMSConnection;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(null, null, false);
        jMSConnection.setType(1);
        return jMSConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(string, string2, false);
        jMSConnection.setType(2);
        return jMSConnection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(null, null, false);
        jMSConnection.setType(2);
        return jMSConnection;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnectionInternal(null, null, false);
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return this.createConnectionInternal(string, string2, false);
    }

    protected JMSConnection createConnectionInternal(String string, String string2, boolean bl) throws JMSException {
        JMSConnection jMSConnection;
        JMSConnection.incrementConnectionCount();
        try {
            DispatcherWrapper dispatcherWrapper = DispatcherManager.create().getLocalDispatcherWrapper();
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "CLIENT/JMSConnectionFactory: Creating connection to the frontend");
            }
            if (this.interfaceVersion >= 1) {
                FEConnectionCreateRequest fEConnectionCreateRequest = new FEConnectionCreateRequest(dispatcherWrapper, string, string2, bl);
                jMSConnection = this.feConnectionFactoryRemote.connectionCreateRequest(fEConnectionCreateRequest);
            } else {
                jMSConnection = string != null ? this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper, string, string2) : this.feConnectionFactoryRemote.connectionCreate(dispatcherWrapper);
            }
        }
        catch (DispatcherException dispatcherException) {
            JMSConnection.decrementConnectionCount();
            throw new weblogic.jms.common.JMSException("Error creating connection on the server", dispatcherException);
        }
        catch (RemoteException remoteException) {
            JMSConnection.decrementConnectionCount();
            throw new weblogic.jms.common.JMSException("Error creating connection on the server", remoteException);
        }
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSConnectionFactory: Successfully created the connection (id: " + jMSConnection.getId() + ") to the frontend");
        }
        try {
            jMSConnection.setupDispatcher();
        }
        catch (Throwable throwable) {
            throw new weblogic.jms.common.JMSException("Error finding dispatcher", throwable);
        }
        InvocableManager.invocableAdd(3, jMSConnection);
        return jMSConnection;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo = null;
        if (objectOutput instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)((Object)objectOutput)).getPeerInfo();
        }
        int n = 1;
        if (peerInfo != null && peerInfo.compareTo(PeerInfo.VERSION_81) >= 0) {
            n = 2;
        }
        objectOutput.writeByte(n);
        if (n >= 2) {
            objectOutput.writeByte(1);
        }
        objectOutput.writeObject(this.feConnectionFactoryRemote);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by < 1 || by > 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        this.interfaceVersion = by >= 2 ? objectInput.readByte() : (byte)0;
        this.feConnectionFactoryRemote = (FEConnectionFactoryRemote)objectInput.readObject();
    }

    public Remote getRemoteDelegate() {
        return this.feConnectionFactoryRemote;
    }
}

