/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidSelectorException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.frontend.FEConsumerSetListenerRequest;
import weblogic.kernel.Kernel;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.expressions.ExpressionEvaluator;
import weblogic.utils.expressions.ExpressionParserException;

public class JMSConsumer
implements MessageConsumer,
TopicSubscriber,
QueueReceiver,
Invocable {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private final SubjectManager subjectManager = SubjectManager.getSubjectManager();
    private static final String EXPRESSION_PARSER_CLASS = "weblogic.utils.expressions.ExpressionParser";
    protected JMSID consumerId;
    private long expectedSequenceNumber;
    protected JMSSession session;
    protected DestinationImpl destination;
    protected MessageListener listener;
    private String selector;
    private String name;
    protected boolean noLocal;
    private ExpressionEvaluator expressionEvaluator;
    private int windowMaximum;
    private int windowCurrent;
    private int windowThreshold;
    private String runtimeMBeanName;
    private AbstractSubject listenerSubject;
    private Context listenerContext;
    private ClassLoader listenerClassLoader;
    public static final int RETRIEVE = 0;
    public static final int CREATE = 1;
    public static final int REMOVE_SUBSCRIPTION = 2;
    public static final long TIMEOUT_NEVER = Long.MAX_VALUE;
    public static final long TIMEOUT_NO_WAIT = 0x7FFFFFFFFFFFFFFEL;
    public static final long TIMEOUT_NO_VALUE = 0x7FFFFFFFFFFFFFFDL;
    public static final long TIMEOUT_RESERVED = 0x7FFFFFFFFFFFFFFDL;
    static /* synthetic */ Class class$java$lang$String;

    JMSConsumer(JMSSession jMSSession, String string, DestinationImpl destinationImpl, String string2, boolean bl, int n) throws JMSException {
        this.name = string;
        this.session = jMSSession;
        this.destination = destinationImpl;
        this.selector = string2;
        this.noLocal = bl;
        if (jMSSession.getAcknowledgeMode() != 128) {
            this.windowMaximum = n;
            this.windowCurrent = n;
            this.windowThreshold = n + 1 >> 1;
        } else if (string2 != null && string2.trim().length() > 0) {
            this.expressionEvaluator = this.createExpressionEvaluator(string2);
        }
    }

    public JMSSession getSession() {
        return this.session;
    }

    public void setRuntimeMBeanName(String string) {
        this.runtimeMBeanName = string;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    private void incrementWindowCurrent(int n, boolean bl) throws JMSException {
        this.session.consumerIncrementWindowCurrent(this.consumerId, n, bl);
        this.windowCurrent += n;
        if (this.windowCurrent > this.windowMaximum) {
            this.windowCurrent = this.windowMaximum;
        }
    }

    void decrementWindowCurrent(boolean bl) throws JMSException {
        if (--this.windowCurrent < this.windowThreshold) {
            this.incrementWindowCurrent(this.windowMaximum - this.windowCurrent, bl);
        }
    }

    void setWindowCurrent(int n) {
        this.windowCurrent = n;
    }

    int getWindowCurrent() {
        return this.windowCurrent;
    }

    int getWindowMaximum() {
        return this.windowMaximum;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    void setId(JMSID jMSID) {
        this.consumerId = jMSID;
    }

    public JMSID getId() {
        return this.consumerId;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    boolean isClosed() {
        return this.consumerId == null;
    }

    boolean isDurable() {
        return this.name != null;
    }

    synchronized long getExpectedSequenceNumber() {
        return this.expectedSequenceNumber;
    }

    synchronized void setExpectedSequenceNumber(long l) {
        this.setExpectedSequenceNumber(l, false);
    }

    synchronized void setExpectedSequenceNumber(long l, boolean bl) {
        if (bl || l > this.expectedSequenceNumber) {
            this.expectedSequenceNumber = l;
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    MessageListener getListener() {
        return this.listener;
    }

    AbstractSubject getListenerSubject() {
        return this.listenerSubject;
    }

    final Context getListenerContext() {
        return this.listenerContext;
    }

    final ClassLoader getListenerClassLoader() {
        return this.listenerClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        JMSSession jMSSession = this.session;
        synchronized (jMSSession) {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.checkClosed();
                if (this.session.getMessageListener() != null) {
                    throw new IllegalStateException("Session has message listener");
                }
                try {
                    if (this.listener == null && messageListener != null) {
                        this.session.incrementConsumerListenerCount();
                    } else if (this.listener != null && messageListener == null) {
                        this.session.decrementConsumerListenerCount();
                    } else {
                        Object var6_4 = null;
                        this.listener = messageListener;
                        if (this.listener != null) {
                            this.saveMLContext();
                        }
                        return;
                    }
                    try {
                        Response response = this.session.getConnection().getFrontEndDispatcher().dispatchSync(new FEConsumerSetListenerRequest(this.consumerId, messageListener != null, this.session.getLastSequenceNumber()));
                    }
                    catch (JMSException jMSException) {
                        messageListener = null;
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.listener = messageListener;
                    if (this.listener != null) {
                        this.saveMLContext();
                    }
                    throw throwable;
                }
                Object var6_5 = null;
                this.listener = messageListener;
                if (this.listener != null) {
                    this.saveMLContext();
                }
            }
        }
    }

    private final void saveMLContext() {
        this.listenerSubject = this.subjectManager.getCurrentSubject(KERNEL_ID);
        if (Kernel.isServer()) {
            this.listenerContext = JMSServerUtilities.getLocalJNDIContext();
            this.listenerClassLoader = this.listener.getClass().getClassLoader();
        }
    }

    public Message receive() throws JMSException {
        return this.receive(Long.MAX_VALUE);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(0x7FFFFFFFFFFFFFFEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long l) throws JMSException {
        Object object = this.session;
        synchronized (object) {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.checkClosed();
                if (this.session.getAcknowledgeMode() == 128) {
                    throw new weblogic.jms.common.JMSException("Multicast sessions do not support synchronous receive");
                }
                if (l == 0L) {
                    l = Long.MAX_VALUE;
                } else if (l < 0L) {
                    throw new weblogic.jms.common.JMSException("Timeout is negative");
                }
                if (this.listener != null) {
                    throw new IllegalStateException("Consumer has listener");
                }
                this.session.setState(2);
            }
        }
        object = null;
        try {
            object = this.session.receiveMessage(this, l);
        }
        catch (Exception exception) {
            this.session.handleException(exception);
        }
        finally {
            this.session.clearState(2);
        }
        if (object != null) {
            ((MessageImpl)object).setSerializeDestination(true);
            if (JMSDebug.debugJMSMessagePath) {
                JMSDebug.debug(16384, "CLIENT/JMSConsumer (id: " + this.consumerId + ") : Received message " + object.getJMSMessageID());
            }
        }
        return object;
    }

    public void close() throws JMSException {
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSConsumer (id: " + this.consumerId + ") : Closing");
        }
        this.session.consumerClose(this);
        if (this.isDurable()) {
            this.removeDurableConsumer();
        }
    }

    private synchronized void checkClosed() throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException("Consumer is closed");
    }

    void removeDurableConsumer() {
        this.session.getConnection().removeDurableSubscriber(this.name);
    }

    String getName() {
        return this.name;
    }

    public Topic getTopic() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public boolean privateGetNoLocal() {
        return this.noLocal;
    }

    public boolean getNoLocal() throws JMSException {
        this.checkClosed();
        return this.noLocal;
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request request) throws JMSException {
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        weblogic.jms.common.JMSException jMSException = jMSPushExceptionRequest.getException();
        if (jMSException instanceof ConsumerClosedException) {
            ((ConsumerClosedException)jMSException).setConsumer(this);
        }
        try {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.setId(null);
            }
            this.session.onException(jMSException);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15366: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
    }

    private ExpressionEvaluator createExpressionEvaluator(String string) throws weblogic.jms.common.JMSException, InvalidSelectorException {
        Class<?> clazz;
        ExpressionEvaluator expressionEvaluator = null;
        try {
            clazz = Class.forName(EXPRESSION_PARSER_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new weblogic.jms.common.JMSException("multicast selectors not supported in thin client");
        }
        try {
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("parse", class$java$lang$String == null ? (class$java$lang$String = JMSConsumer.class$("java.lang.String")) : class$java$lang$String);
            expressionEvaluator = (ExpressionEvaluator)method.invoke(obj, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new weblogic.jms.common.JMSException("internal error: " + illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new weblogic.jms.common.JMSException("internal error: " + noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new weblogic.jms.common.JMSException("internal error: " + instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string2 = throwable instanceof ExpressionParserException ? ((ExpressionParserException)throwable).getMessage() : "Invalid selector: " + throwable;
            throw new InvalidSelectorException(string2);
        }
        return expressionEvaluator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

