/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.client.JMSQueueBrowser;
import weblogic.jms.common.JMSEnumerationNextElementResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.frontend.FEEnumerationNextElementRequest;

public final class JMSEnumeration
implements Enumeration {
    private Dispatcher frontEndDispatcher;
    private JMSID enumerationId;
    private JMSQueueBrowser browser;
    private MessageImpl message;

    public JMSEnumeration(JMSQueueBrowser jMSQueueBrowser, JMSID jMSID, Dispatcher dispatcher) {
        this.browser = jMSQueueBrowser;
        this.enumerationId = jMSID;
        this.frontEndDispatcher = dispatcher;
    }

    public boolean hasMoreElements() {
        if (this.message != null) {
            return true;
        }
        if (!this.isClosed()) {
            this.message = this.getNextMessage();
        }
        return this.message != null;
    }

    public Object nextElement() {
        if (this.message == null) {
            if (!this.isClosed()) {
                this.message = this.getNextMessage();
            }
            if (this.message == null) {
                throw new NoSuchElementException();
            }
        }
        MessageImpl messageImpl = this.message;
        this.message = null;
        try {
            messageImpl.setJMSDestination(this.browser.getQueue());
            if (this.isClosed() || this.browser.getSession().getConnection().isLocal()) {
                messageImpl = messageImpl.copy();
            }
        }
        catch (JMSException jMSException) {
            JMSLogger.logStackTrace(jMSException);
        }
        return messageImpl;
    }

    private boolean isClosed() {
        if (this.enumerationId == null) {
            return true;
        }
        if (this.browser.isClosed()) {
            this.close();
        }
        return this.enumerationId == null;
    }

    private void close() {
        this.enumerationId = null;
    }

    private MessageImpl getNextMessage() {
        MessageImpl messageImpl = null;
        try {
            Response response = this.frontEndDispatcher.dispatchSync(new FEEnumerationNextElementRequest(this.enumerationId));
            messageImpl = ((JMSEnumerationNextElementResponse)response).getMessage();
        }
        catch (JMSException jMSException) {
            return null;
        }
        if (messageImpl == null) {
            this.close();
        }
        return messageImpl;
    }
}

