/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.frontend.FEProducerSendRequest;

public final class JMSProducer
implements TopicPublisher,
QueueSender,
WLMessageProducer,
Invocable {
    private JMSSession session;
    private JMSID producerId;
    private DestinationImpl destination;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver = -1L;
    private long timeToLive;
    private int redeliveryLimit = -1;
    private long sendTimeout;
    private boolean messageIdsDisabled;
    private boolean messageTimestampsDisabled;
    private boolean flowControlEnabled;
    private int flowMinimum;
    private int flowMaximum;
    private double flowDecrease;
    private int flowIncrease;
    private long flowInterval;
    private double flowRateCurrent;
    private long backOffTime;
    private boolean backedOffLastTime;
    private boolean needsFlowControl;
    private long lastTimeChanged;
    private long lastTimeLeave;
    private String runtimeMBeanName;

    JMSProducer(JMSSession jMSSession, JMSID jMSID, DestinationImpl destinationImpl, String string) {
        this.session = jMSSession;
        this.producerId = jMSID;
        this.destination = destinationImpl;
        this.runtimeMBeanName = string;
        this.deliveryMode = jMSSession.getDeliveryMode();
        this.priority = jMSSession.getPriority();
        this.timeToLive = jMSSession.getTimeToLive();
        this.sendTimeout = jMSSession.getSendTimeout();
        JMSConnection jMSConnection = jMSSession.getConnection();
        this.flowControlEnabled = jMSConnection.isFlowControlEnabled();
        this.flowMinimum = jMSConnection.getFlowMinimum();
        this.flowMaximum = jMSConnection.getFlowMaximum();
        this.flowIncrease = jMSConnection.getFlowIncrease();
        this.flowDecrease = jMSConnection.getFlowDecrease();
        this.flowInterval = jMSConnection.getFlowInterval();
        this.flowRateCurrent = this.flowMaximum;
        this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
    }

    void setId(JMSID jMSID) {
        this.producerId = jMSID;
    }

    public JMSID getId() {
        return this.producerId;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    boolean isClosed() {
        return this.producerId == null;
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.checkClosed();
        if (this.destination != null) {
            throw new UnsupportedOperationException("Cannot override producer destination");
        }
        this.sendInternal(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        this.checkClosed();
        if (this.destination != null) {
            throw new UnsupportedOperationException("Cannot override producer destination");
        }
        if (l < 0L) {
            if (l == -9223372036854775807L) {
                l = -100L;
            } else {
                throw new weblogic.jms.common.JMSException("Invalid time to live");
            }
        }
        this.sendInternal(destination, message, n, n2, l);
    }

    public void send(Message message) throws JMSException {
        this.checkClosed();
        if (this.destination == null) {
            throw new UnsupportedOperationException("Must provide destination");
        }
        this.sendInternal(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        this.checkClosed();
        if (this.destination == null) {
            throw new UnsupportedOperationException("Must provide destination");
        }
        if (l < 0L) {
            if (l == -9223372036854775807L) {
                l = -100L;
            } else {
                throw new weblogic.jms.common.JMSException("Invalid time to live");
            }
        }
        this.sendInternal(this.destination, message, n, n2, l);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        this.send((Destination)queue, message, n, n2, l);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        this.send(message, n, n2, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send(topic, message);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        this.send(topic, message, n, n2, l);
    }

    private void sendInternal(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        Response response;
        Dispatcher dispatcher;
        MessageImpl messageImpl;
        if (destination == null) {
            throw new InvalidDestinationException("Destination is null");
        }
        if (!(destination instanceof DestinationImpl)) {
            throw new InvalidDestinationException("Foreign destination, " + destination);
        }
        if (this.session.getType() == 2 && !((DestinationImpl)destination).isQueue()) {
            throw new InvalidDestinationException("Destination must be a queue, " + destination);
        }
        if (this.session.getType() == 1 && !((DestinationImpl)destination).isTopic()) {
            throw new InvalidDestinationException("Destination must be a topic, " + destination);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.lastTimeLeave;
        if (this.flowControlEnabled && (this.needsFlowControl || this.flowRateCurrent <= (double)this.flowMaximum) && l3 <= this.backOffTime) {
            try {
                Thread.sleep(this.backOffTime - l3);
                l2 = System.currentTimeMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            messageImpl = (MessageImpl)message;
            messageImpl.resetUserPropertySize();
            if (this.session.getConnection().isLocal()) {
                messageImpl = messageImpl.copy();
            }
        }
        catch (ClassCastException classCastException) {
            messageImpl = this.convertMessage(message);
        }
        if (l == 0L) {
            l = 0L;
        }
        messageImpl.setJMSExpiration(l);
        long l4 = this.getTimeToDeliverInternal();
        messageImpl.setDeliveryTime(l4);
        messageImpl.setJMSRedeliveryLimit(this.redeliveryLimit);
        messageImpl.setJMSDestinationImpl(null);
        messageImpl.setId(null);
        messageImpl.setJMSDeliveryMode(n);
        messageImpl.setJMSPriority(n2);
        messageImpl.setJMSRedelivered(false);
        messageImpl.setForwarded(false);
        if (JMSDebug.debugJMSMessagePath) {
            JMSDebug.debug(16384, "CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Sending message deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l + " timeToDeliver = " + l4 + " redeliveryLimit = " + this.redeliveryLimit);
        }
        if (!(dispatcher = this.session.getConnection().getFrontEndDispatcher()).ready()) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException("using closed dispatcher");
            throw jMSException;
        }
        try {
            messageImpl.setSerializeDestination(false);
            if (JMSDebug.debugJMSMessagePath) {
                JMSDebug.debug(16384, "CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Dispatching message to FRONTEND/FEProducer");
            }
            response = !this.session.isTransacted() && this.session.userTransactionsEnabled() ? dispatcher.dispatchSyncTran(new FEProducerSendRequest(this.producerId, messageImpl, this.destination == null ? (DestinationImpl)destination : null, this.sendTimeout)) : dispatcher.dispatchSyncNoTran(new FEProducerSendRequest(this.producerId, messageImpl, this.destination == null ? (DestinationImpl)destination : null, this.sendTimeout));
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)exception;
            }
            throw new weblogic.jms.common.JMSException("Error sending message", exception);
        }
        finally {
            messageImpl.setSerializeDestination(true);
        }
        JMSProducerSendResponse jMSProducerSendResponse = (JMSProducerSendResponse)response;
        JMSMessageId jMSMessageId = jMSProducerSendResponse.getMessageId();
        messageImpl.setId(jMSMessageId);
        if (message == messageImpl) {
            if (l4 != 0L) {
                messageImpl.setDeliveryTime(jMSMessageId.getTimestamp() + l4);
            }
            messageImpl.setJMSDestinationImpl((DestinationImpl)destination);
        } else {
            try {
                message.setJMSDestination((DestinationImpl)destination);
            }
            catch (ClassCastException classCastException) {
            }
            catch (javax.jms.InvalidDestinationException invalidDestinationException) {
                // empty catch block
            }
            message.setJMSDeliveryMode(messageImpl.getJMSDeliveryMode());
            message.setJMSPriority(messageImpl.getJMSPriority());
            if (message instanceof MessageImpl) {
                ((MessageImpl)message).setId(jMSMessageId);
            } else {
                message.setJMSTimestamp(messageImpl.getJMSTimestamp());
                try {
                    message.setJMSMessageID(messageImpl.getJMSMessageID());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (message.getJMSExpiration() > 0L) {
            message.setJMSExpiration(jMSMessageId.getTimestamp());
        } else {
            message.setJMSExpiration(0L);
        }
        try {
            n = jMSProducerSendResponse.getDeliveryMode();
            if (n != -1) {
                message.setJMSDeliveryMode(n);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        n2 = jMSProducerSendResponse.getPriority();
        if (n2 != -1) {
            message.setJMSPriority(n2);
        }
        if ((l = jMSProducerSendResponse.getTimeToLive()) != -1L) {
            message.setJMSExpiration(jMSMessageId.getTimestamp() + l);
        }
        if (message instanceof MessageImpl) {
            int n3;
            l4 = jMSProducerSendResponse.getTimeToDeliver();
            if (l4 != -1L) {
                ((MessageImpl)message).setDeliveryTime(jMSMessageId.getTimestamp() + l4);
            }
            if ((n3 = jMSProducerSendResponse.getRedeliveryLimit()) != 0) {
                ((MessageImpl)message).setJMSRedeliveryLimit(n3);
            }
        }
        if (JMSDebug.debugJMSMessagePath) {
            JMSDebug.debug(16384, "CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Successfully sent message " + message.getJMSMessageID());
        }
        if (!this.flowControlEnabled) {
            return;
        }
        if (jMSProducerSendResponse.getNeedsFlowControl()) {
            this.needsFlowControl = true;
            if (jMSProducerSendResponse.getFlowControlTime() == -1L) {
                if (this.flowRateCurrent > (double)this.flowMaximum) {
                    this.flowRateCurrent = this.flowMaximum;
                }
                if (l2 - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent > (double)this.flowMinimum) {
                    this.flowRateCurrent *= this.flowDecrease;
                    if (this.flowRateCurrent < (double)this.flowMinimum) {
                        this.flowRateCurrent = this.flowMinimum;
                    }
                    this.lastTimeChanged = l2;
                    this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
                }
            } else {
                this.backOffTime = jMSProducerSendResponse.getFlowControlTime();
            }
            this.lastTimeLeave = l2;
        } else {
            this.needsFlowControl = false;
            if (l2 - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent < (double)this.flowMaximum) {
                this.flowRateCurrent += (double)this.flowIncrease;
                this.lastTimeChanged = l2;
                this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
            }
        }
    }

    private MessageImpl convertMessage(Message message) throws JMSException {
        try {
            if (message instanceof BytesMessage) {
                return new BytesMessageImpl((BytesMessage)message);
            }
            if (message instanceof MapMessage) {
                return new MapMessageImpl((MapMessage)message);
            }
            if (message instanceof ObjectMessage) {
                return new ObjectMessageImpl((ObjectMessage)message);
            }
            if (message instanceof StreamMessage) {
                return new StreamMessageImpl((StreamMessage)message);
            }
            if (message instanceof TextMessage) {
                return new TextMessageImpl((TextMessage)message);
            }
            return new HdrMessageImpl(message);
        }
        catch (IOException iOException) {
            throw JMSUtilities.jmsException("Error converting foreign message ", iOException);
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.checkClosed();
        this.messageIdsDisabled = bl;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.messageIdsDisabled;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkClosed();
        this.messageTimestampsDisabled = bl;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.messageTimestampsDisabled;
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.checkClosed();
        if (n == 2 || n == 1) {
            this.deliveryMode = n;
        } else if (n == -1) {
            this.deliveryMode = 2;
        } else {
            throw new weblogic.jms.common.JMSException("Invalid delivery mode");
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        this.checkClosed();
        if (n >= 0 && n <= 9) {
            this.priority = n;
        } else if (n == -1) {
            this.priority = 4;
        } else {
            throw new weblogic.jms.common.JMSException("Invalid priority");
        }
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public long getTimeToDeliver() throws JMSException {
        this.checkClosed();
        return this.getTimeToDeliverInternal();
    }

    long getTimeToDeliverInternal() {
        return this.timeToDeliver == -1L ? this.session.getConnection().getTimeToDeliver() : this.timeToDeliver;
    }

    public void setTimeToDeliver(long l) throws JMSException {
        this.checkClosed();
        if (l < -1L) {
            throw new JMSException("Invalid time to deliver, must be >= -1");
        }
        this.timeToDeliver = l;
    }

    public int getRedeliveryLimit() throws JMSException {
        this.checkClosed();
        return this.redeliveryLimit;
    }

    public void setRedeliveryLimit(int n) throws JMSException {
        this.checkClosed();
        if (n < -1) {
            throw new JMSException("Invalid redelivery limit,  must be >= -1");
        }
        this.redeliveryLimit = n;
    }

    public long getSendTimeout() throws JMSException {
        this.checkClosed();
        return this.sendTimeout;
    }

    public void setSendTimeout(long l) throws JMSException {
        this.checkClosed();
        if (l < 0L) {
            throw new JMSException("Invalid send timeout, must be >= 0");
        }
        this.sendTimeout = l;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkClosed();
        if (l < 0L) {
            if (l == -9223372036854775807L) {
                l = -100L;
            } else {
                throw new weblogic.jms.common.JMSException("Invalid time to live");
            }
        }
        this.timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        JMSID jMSID;
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSProducer (id: " + this.producerId + ") : Closing");
        }
        JMSProducer jMSProducer = this;
        synchronized (jMSProducer) {
            if (this.isClosed()) {
                return;
            }
            jMSID = this.producerId;
            this.producerId = null;
        }
        this.session.producerClose(jMSID);
    }

    public JMSSession getSession() {
        return this.session;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
    }

    public int invoke(Request request) {
        return Integer.MAX_VALUE;
    }
}

