/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import weblogic.jms.JMSLogger;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSMessageReference;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.JMSQueueBrowser;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageList;
import weblogic.jms.common.MessageReference;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManager;
import weblogic.jms.dispatcher.InvocableMonitor;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.extensions.DataOverrunException;
import weblogic.jms.extensions.MDBTransaction;
import weblogic.jms.extensions.WLQueueSession;
import weblogic.jms.extensions.WLSession;
import weblogic.jms.extensions.WLTopicSession;
import weblogic.jms.extensions.XMLMessage;
import weblogic.jms.frontend.FEBrowserCloseRequest;
import weblogic.jms.frontend.FEBrowserCreateRequest;
import weblogic.jms.frontend.FEConsumerCloseRequest;
import weblogic.jms.frontend.FEConsumerCreateRequest;
import weblogic.jms.frontend.FEConsumerCreateResponse;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentOneWayRequest;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.frontend.FEConsumerReceiveRequest;
import weblogic.jms.frontend.FEDestinationCreateRequest;
import weblogic.jms.frontend.FEProducerCloseRequest;
import weblogic.jms.frontend.FEProducerCreateRequest;
import weblogic.jms.frontend.FEProducerCreateResponse;
import weblogic.jms.frontend.FESessionAcknowledgeRequest;
import weblogic.jms.frontend.FESessionCloseRequest;
import weblogic.jms.frontend.FESessionRecoverRequest;
import weblogic.jms.frontend.FESessionSetRedeliveryDelayRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateResponse;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTDMSocketIPM;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class JMSSession
implements WLSession,
WLQueueSession,
WLTopicSession,
ExecuteRequest,
Invocable,
MDBTransaction {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private final SubjectManager subjectManager = SubjectManager.getSubjectManager();
    private long expectedSequenceNumber = 1L;
    private long nextSequenceNumber;
    private JMSPushRequest firstPushRequest;
    private JMSPushRequest lastPushRequest;
    private JMSPushRequest firstReceivePushRequest;
    private JMSPushRequest lastReceivePushRequest;
    private UnackedMessage firstUnackedMessage;
    private JMSID sessionId;
    private int messagesMaximum;
    private int overrunPolicy;
    private int acknowledgePolicy;
    private int pushRequestCount;
    protected JMSConnection connection;
    private boolean transacted;
    private int acknowledgeMode;
    protected int deliveryMode;
    protected int priority;
    protected long timeToLive;
    private long sendTimeout;
    private boolean userTransactionsEnabled;
    private boolean allowCloseInOnMessage;
    private long redeliveryDelay = -1L;
    private String clientID;
    private boolean decrementWindow;
    private int dispatchPolicyIndex;
    private String dispatchPolicyName;
    private ExecuteThreadManager dispatchPolicyManager;
    private Object lockObject;
    protected HashMap consumers = new HashMap();
    protected HashMap producers = new HashMap();
    protected HashMap browsers = new HashMap();
    static final int IDLE = 0;
    static final int IN_CLOSE = 1;
    static final int IN_RECEIVE = 2;
    static final int IN_LISTENER = 4;
    static final int TYPE_TOPIC = 1;
    static final int TYPE_QUEUE = 2;
    protected MessageListener messageListener;
    private AbstractSubject messageListenerSubject;
    private ClassLoader messageListenerClassLoader;
    private Context messageListenerContext;
    protected ExceptionListener exceptionListener;
    private AbstractSubject exceptionListenerSubject;
    private ClassLoader exceptionListenerClassLoader;
    private Context exceptionListenerContext;
    private int consumerListenerCount;
    private int state = 0;
    private Thread listenerThread;
    private String runtimeMBeanName;
    private int waiterCount;
    private boolean stopped;
    private boolean running;
    private boolean recovering;
    private int type;
    private long lastSequenceNumber;
    MessageList messageList;
    private JMSMessageReference mRefCache;
    private JMSTDMSocket dgmSock;
    private JMSTMSocket mSock;

    protected JMSSession(JMSConnection jMSConnection, boolean bl, int n, boolean bl2) throws JMSException {
        this.connection = jMSConnection;
        this.transacted = bl;
        this.acknowledgeMode = bl ? 2 : n;
        this.stopped = bl2;
        this.userTransactionsEnabled = jMSConnection.getUserTransactionsEnabled();
        this.allowCloseInOnMessage = jMSConnection.getAllowCloseInOnMessage();
        this.messagesMaximum = jMSConnection.getMessagesMaximum();
        this.deliveryMode = jMSConnection.getDeliveryMode();
        this.priority = jMSConnection.getPriority();
        this.timeToLive = jMSConnection.getTimeToLive();
        this.acknowledgePolicy = jMSConnection.getAcknowledgePolicy();
        this.overrunPolicy = jMSConnection.getOverrunPolicy();
        this.clientID = jMSConnection.getClientID();
        this.sendTimeout = jMSConnection.getSendTimeout();
        this.dispatchPolicyName = jMSConnection.getDispatchPolicy();
        this.dispatchPolicyIndex = Kernel.getDispatchPolicyIndex(this.dispatchPolicyName);
        this.dispatchPolicyManager = Kernel.getExecuteThreadManager(this.dispatchPolicyName);
        this.lockObject = new Object();
    }

    public synchronized int getMessagesMaximum() throws JMSException {
        this.checkClosed();
        return this.messagesMaximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMessagesMaximum(int n) throws JMSException {
        this.checkClosed();
        Object object = this.lockObject;
        synchronized (object) {
            if (n < -1 || n == 0) {
                throw new weblogic.jms.common.JMSException("Invalid messagesMaximum value");
            }
            this.messagesMaximum = n;
        }
    }

    public synchronized int getOverrunPolicy() throws JMSException {
        this.checkClosed();
        return this.overrunPolicy;
    }

    public synchronized void setOverrunPolicy(int n) throws JMSException {
        this.checkClosed();
        if (n != 0 && n != 1) {
            throw new weblogic.jms.common.JMSException("Invalid overrunPolicy value, " + n);
        }
        this.overrunPolicy = n;
    }

    public long getRedeliveryDelay() throws JMSException {
        this.checkClosed();
        return this.getRedeliveryDelayInternal();
    }

    private long getRedeliveryDelayInternal() {
        return this.redeliveryDelay == -1L ? this.getConnection().getRedeliveryDelay() : this.redeliveryDelay;
    }

    public void setRedeliveryDelay(long l) throws JMSException {
        this.checkClosed();
        if (l < -1L) {
            throw new JMSException("Invalid redelivery delay, must be >= -1");
        }
        long l2 = this.getRedeliveryDelayInternal();
        if (l != l2 && this.consumers.size() != 0) {
            this.redeliveryDelay = l;
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FESessionSetRedeliveryDelayRequest(this.sessionId, l));
        }
    }

    final int getDeliveryMode() {
        return this.deliveryMode;
    }

    final int getPriority() {
        return this.priority;
    }

    final long getTimeToLive() {
        return this.timeToLive;
    }

    final long getSendTimeout() {
        return this.sendTimeout;
    }

    final void setId(JMSID jMSID) {
        this.sessionId = jMSID;
    }

    public JMSID getId() {
        return this.sessionId;
    }

    public void setType(int n) {
        this.type = n;
    }

    final int getType() {
        return this.type;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    final boolean isStopped() {
        return this.stopped;
    }

    final long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    final boolean isTransacted() {
        return this.transacted;
    }

    final boolean userTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    final void setUserTransactionsEnabled(boolean bl) {
        this.userTransactionsEnabled = bl;
    }

    public void setRuntimeMBeanName(String string) {
        this.runtimeMBeanName = string;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public JMSConnection getConnection() {
        return this.connection;
    }

    public String toString() {
        return this.connection.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MessageImpl receiveMessage(JMSConsumer jMSConsumer, long l) throws RemoteException, JMSException {
        MessageImpl messageImpl;
        MessageImpl messageImpl2 = null;
        JMSID jMSID = jMSConsumer.getId();
        Response response = null;
        Object object = this;
        synchronized (object) {
            Object object2 = this.lockObject;
            synchronized (object2) {
                JMSPushEntry jMSPushEntry;
                JMSPushRequest jMSPushRequest;
                JMSPushRequest jMSPushRequest2 = null;
                for (jMSPushRequest = this.firstReceivePushRequest; jMSPushRequest != null; jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) {
                    jMSPushEntry = jMSPushRequest.getFirstPushEntry();
                    if (jMSConsumer.getId().equals(jMSPushEntry.getConsumerId())) {
                        jMSPushEntry = jMSPushRequest.removePushEntry();
                        response = new JMSConsumerReceiveResponse(jMSPushRequest.getMessage(), jMSPushEntry.getFrontEndSequenceNumber(), false);
                        break;
                    }
                    jMSPushRequest2 = jMSPushRequest;
                }
                if (response != null && (jMSPushEntry = jMSPushRequest.getFirstPushEntry()) == null) {
                    JMSPushRequest jMSPushRequest3 = (JMSPushRequest)jMSPushRequest.getNext();
                    jMSPushRequest.setNext(null);
                    if (jMSPushRequest2 == null) {
                        this.firstReceivePushRequest = jMSPushRequest3;
                    } else {
                        jMSPushRequest2.setNext(jMSPushRequest3);
                    }
                    if (jMSPushRequest3 == null) {
                        this.lastReceivePushRequest = null;
                    }
                }
            }
        }
        if (response == null) {
            response = !this.transacted && this.userTransactionsEnabled ? this.connection.getFrontEndDispatcher().dispatchSyncTran(new FEConsumerReceiveRequest(jMSID, l)) : this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEConsumerReceiveRequest(jMSID, l));
        }
        if ((messageImpl = ((JMSConsumerReceiveResponse)(object = (JMSConsumerReceiveResponse)response)).getMessage()) != null) {
            if (this.connection.isLocal()) {
                messageImpl2 = messageImpl.copy();
                messageImpl2.setSequenceNumber(messageImpl.getSequenceNumber());
                messageImpl2.setClientResponsibleForAcknowledge(messageImpl.getClientResponsibleForAcknowledge());
                messageImpl2.setJMSRedelivered(messageImpl.getJMSRedelivered());
            } else {
                messageImpl2 = messageImpl;
            }
            long l2 = ((JMSConsumerReceiveResponse)object).getSequenceNumber();
            messageImpl2.setSequenceNumber(l2);
            messageImpl2.setForwarded(false);
            this.lastSequenceNumber = l2;
            if (!((JMSConsumerReceiveResponse)object).isTransactional()) {
                this.addUnackedMessage(jMSConsumer, messageImpl2);
                if (this.acknowledgeMode == 2) {
                    messageImpl2.setSession(this);
                } else if (this.acknowledgeMode != 4) {
                    this.acknowledge(messageImpl2, this.acknowledgePolicy, false);
                }
            }
        }
        if (messageImpl2 != null) {
            messageImpl2.setJMSDestinationImpl((DestinationImpl)jMSConsumer.getDestination());
            if (JMSDebug.debugJMSMessagePath) {
                JMSDebug.debug(16384, "CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Received message " + messageImpl2.getJMSMessageID());
            }
        }
        return messageImpl2;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new HdrMessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setObject(serializable);
        return objectMessageImpl;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        return new TextMessageImpl(string);
    }

    public XMLMessage createXMLMessage() throws JMSException {
        this.checkClosed();
        return new XMLMessageImpl();
    }

    public XMLMessage createXMLMessage(String string) throws JMSException {
        this.checkClosed();
        return new XMLMessageImpl(string);
    }

    public TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        this.checkClosed();
        return new TextMessageImpl(stringBuffer.toString());
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws JMSException {
        this.checkClosed();
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        this.firstUnackedMessage = null;
        try {
            Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getId(), this.lastSequenceNumber, 1, true));
            this.decrementWindow = false;
        }
        catch (JMSException jMSException) {
            String string = jMSException.getErrorCode();
            try {
                if (string != null) {
                    if ("ReservedRollbackOnly".equals(string)) {
                        this.recoverGuts(false);
                    }
                }
            }
            finally {
                throw jMSException;
            }
        }
    }

    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        this.recoverGuts(false);
    }

    final void consumerIncrementWindowCurrent(JMSID jMSID, int n, boolean bl) throws JMSException {
        byte by = this.connection.getPeerVersion();
        if (by < 3) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerIncrementWindowCurrentRequest(jMSID, n, bl));
        } else {
            this.connection.getFrontEndDispatcher().dispatchNoReply(new FEConsumerIncrementWindowCurrentOneWayRequest(jMSID, n, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            if (this.stopped) {
                return;
            }
            if (!this.inListener() || !this.allowCloseInOnMessage) {
                this.waitForState(-5);
            }
            this.checkClosed();
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                if (!this.stopped) {
                    return;
                }
                this.checkClosed();
                this.stopped = false;
                if (this.running || !this.havePushRequests()) {
                    return;
                }
                this.running = true;
            }
        }
        Kernel.execute((ExecuteRequest)this, this.dispatchPolicyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        boolean bl;
        JMSID jMSID;
        block15: {
            jMSID = null;
            bl = false;
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "CLIENT/JMSSession (id: " + this.sessionId + ") : Closing");
            }
            try {
                JMSSession jMSSession = this;
                // MONITORENTER : jMSSession
                if (!this.inListener() || !this.allowCloseInOnMessage) {
                    this.waitForState(-5);
                }
                if (!this.isClosed()) break block15;
                // MONITOREXIT : jMSSession
                if (!bl) return;
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                try {
                    this.connection.sessionRemove(jMSID);
                    throw throwable;
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.connection.sessionRemove(jMSID);
                return;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return;
        }
        bl = true;
        jMSID = this.poisonSession();
        if (this.mSock != null) {
            this.mSock.close();
            this.mSock = null;
        }
        this.poisonConsumersAndCloseLocaly();
        this.poisonProducers();
        this.poisonBrowsers();
        this.dispatchSessionCloseRequest(jMSID);
        this.waitForOutstandingReceives();
        this.removeDurableConsumers();
        this.consumers.clear();
        this.producers.clear();
        this.browsers.clear();
        // MONITOREXIT : jMSSession
        if (!bl) return;
        try {
            this.connection.sessionRemove(jMSID);
            return;
        }
        catch (JMSException jMSException) {
            return;
        }
    }

    private JMSID poisonSession() {
        JMSID jMSID = this.sessionId;
        this.sessionId = null;
        return jMSID;
    }

    private void removeDurableConsumers() {
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            JMSConsumer jMSConsumer = (JMSConsumer)iterator.next();
            if (!jMSConsumer.isDurable()) continue;
            jMSConsumer.removeDurableConsumer();
        }
    }

    private void poisonBrowsers() {
        Iterator iterator = this.browsers.values().iterator();
        while (iterator.hasNext()) {
            JMSQueueBrowser jMSQueueBrowser = (JMSQueueBrowser)iterator.next();
            jMSQueueBrowser.setId(null);
        }
    }

    private void poisonConsumersAndCloseLocaly() throws JMSException {
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            JMSConsumer jMSConsumer = (JMSConsumer)iterator.next();
            this.consumerCloseLocal(jMSConsumer, false);
        }
    }

    private void poisonProducers() {
        Iterator iterator = this.producers.values().iterator();
        while (iterator.hasNext()) {
            JMSProducer jMSProducer = (JMSProducer)iterator.next();
            jMSProducer.setId(null);
        }
    }

    private void dispatchSessionCloseRequest(JMSID jMSID) throws JMSException {
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionCloseRequest(jMSID, this.lastSequenceNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingReceives() throws JMSException {
        try {
            this.setState(1);
            this.waitForState(-3);
        }
        finally {
            this.clearState(1);
        }
    }

    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Session is transacted");
        }
        this.recoverGuts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void recoverGuts(boolean bl) throws JMSException {
        MessageList messageList;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        this.checkClosed();
        this.decrementWindow = false;
        long l = this.lastSequenceNumber;
        this.lastSequenceNumber = 0L;
        boolean bl3 = bl2 = this.transacted || this.firstUnackedMessage != null;
        if (bl2) {
            object3 = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionRecoverRequest(this.getId(), l, !bl));
            this.setExpectedSequenceNumber(((JMSSessionRecoverResponse)object3).getSequenceNumber(), false);
            object2 = this.consumers.values().iterator();
            while (object2.hasNext()) {
                object = (JMSConsumer)object2.next();
                ((JMSConsumer)object).setWindowCurrent(((JMSConsumer)object).getWindowMaximum());
                ((JMSConsumer)object).setExpectedSequenceNumber(this.expectedSequenceNumber);
            }
            this.firstUnackedMessage = null;
        }
        if ((messageList = this.messageList) == null) {
            return;
        }
        this.messageList = null;
        object = null;
        JMSPushRequest jMSPushRequest = null;
        JMSPushRequest jMSPushRequest2 = null;
        long l2 = this.expectedSequenceNumber;
        boolean bl4 = this.consumerListenerCount == 0;
        for (object3 = (JMSMessageReference)messageList.getLast(); object3 != null; object3 = (JMSMessageReference)((MessageReference)object3).getPrev()) {
            object2 = ((JMSMessageReference)object3).getConsumer();
            l2 = ((MessageReference)object3).getSequenceNumber();
            ((JMSConsumer)object2).setExpectedSequenceNumber(l2, true);
        }
        this.setExpectedSequenceNumber(l2, true);
        for (object3 = (JMSMessageReference)messageList.getFirst(); object3 != null; object3 = (JMSMessageReference)((MessageReference)object3).getNext()) {
            MessageImpl messageImpl = ((MessageReference)object3).getMessage();
            messageImpl.setRedelivered(true);
            messageImpl = ((MessageReference)object3).getMessage();
            messageImpl.reset();
            jMSPushRequest = new JMSPushRequest(0, null, messageImpl);
            if (object != null) {
                ((Request)object).setNext(jMSPushRequest);
            } else {
                jMSPushRequest2 = jMSPushRequest;
            }
            object = jMSPushRequest;
            jMSPushRequest = null;
            object2 = ((JMSMessageReference)object3).getConsumer();
            long l3 = ((MessageReference)object3).getSequenceNumber();
            JMSPushEntry jMSPushEntry = new JMSPushEntry(null, ((JMSConsumer)object2).getId(), 0L, l3, true);
            jMSPushEntry.setClientResponsibleForAcknowledge(true);
            ((JMSPushRequest)object).setPushEntries(jMSPushEntry);
        }
        if (jMSPushRequest2 != null) {
            Object object4 = this.lockObject;
            synchronized (object4) {
                if (this.inState(4)) {
                    this.recovering = true;
                }
                this.pushMessage(jMSPushRequest2, bl4);
            }
        }
    }

    public void acknowledge() throws JMSException {
        this.acknowledge(null, 1, false);
    }

    public void acknowledge(MessageImpl messageImpl) throws JMSException {
        this.acknowledge(messageImpl, this.acknowledgePolicy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(MessageImpl messageImpl, int n, boolean bl) throws JMSException {
        long l;
        boolean bl2;
        if (messageImpl == null) {
            bl2 = false;
            l = this.lastSequenceNumber;
        } else {
            bl2 = messageImpl.getClientResponsibleForAcknowledge();
            l = n == 1 ? this.lastSequenceNumber : messageImpl.getSequenceNumber();
        }
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            this.checkClosed();
            if (this.transacted) {
                return;
            }
            try {
                if (!bl2) {
                    if (JMSDebug.debugJMSCommon) {
                        JMSDebug.debug(16, "CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Dispatching the acknowledge to the frontend");
                    }
                    if (bl) {
                        this.connection.getFrontEndDispatcher().dispatchSyncTran(new FESessionAcknowledgeRequest(this.getId(), l, n, false));
                    } else {
                        this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getId(), l, n, false));
                    }
                    if (l == this.lastSequenceNumber) {
                        this.decrementWindow = false;
                    }
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            finally {
                this.removeUnackedMessage(l, bl2, bl);
            }
        }
    }

    public void associateTransaction(Message message) throws JMSException {
        this.acknowledge((MessageImpl)message, 1, true);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        if (this.consumerListenerCount > 0) {
            throw new IllegalStateException("Session has consumer listeners");
        }
        this.messageListener = messageListener;
        this.saveMLContext();
    }

    protected void saveELContext() {
        this.exceptionListenerSubject = this.subjectManager.getCurrentSubject(KERNEL_ID);
        if (Kernel.isServer() && this.exceptionListener != null) {
            this.exceptionListenerClassLoader = this.exceptionListener.getClass().getClassLoader();
            this.exceptionListenerContext = JMSServerUtilities.getLocalJNDIContext();
        }
    }

    protected ClassLoader pushELContext() {
        if (Kernel.isServer()) {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            if (this.exceptionListenerClassLoader != classLoader) {
                thread.setContextClassLoader(this.exceptionListenerClassLoader);
            }
            JMSServerUtilities.pushLocalJNDIContext((Context)this.exceptionListenerContext);
            return classLoader;
        }
        return null;
    }

    protected void popELContext(ClassLoader classLoader) {
        if (Kernel.isServer()) {
            JMSServerUtilities.popLocalJNDIContext();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void saveMLContext() {
        this.messageListenerSubject = this.subjectManager.getCurrentSubject(KERNEL_ID);
        if (Kernel.isServer() && this.messageListener != null) {
            this.messageListenerClassLoader = this.messageListener.getClass().getClassLoader();
            this.messageListenerContext = JMSServerUtilities.getLocalJNDIContext();
        }
    }

    protected ClassLoader pushMLContext() {
        if (Kernel.isServer()) {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            if (this.messageListenerClassLoader != classLoader) {
                thread.setContextClassLoader(this.messageListenerClassLoader);
            }
            JMSServerUtilities.pushLocalJNDIContext((Context)this.messageListenerContext);
            return classLoader;
        }
        return null;
    }

    protected void popMLContext(ClassLoader classLoader) {
        if (Kernel.isServer()) {
            JMSServerUtilities.popLocalJNDIContext();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Thread thread = Thread.currentThread();
        Object object2 = this;
        synchronized (object2) {
            object = this.lockObject;
            synchronized (object) {
                this.lastPushRequest = null;
                this.firstPushRequest = null;
            }
            this.setState(4);
        }
        object2 = null;
        try {
            MessageListener messageListener = this.getMessageListener();
            if (messageListener == null) {
                return;
            }
            object2 = this.pushMLContext();
            try {
                for (JMSPushRequest jMSPushRequest = this.firstPushRequest; jMSPushRequest != null; jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) {
                    object = jMSPushRequest.getMessage().copy();
                    ((MessageImpl)object).setForwarded(false);
                    JMSPushEntry jMSPushEntry = jMSPushRequest.getFirstPushEntry();
                    ((MessageImpl)object).setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
                    ((MessageImpl)object).setJMSRedelivered(jMSPushEntry.getRedelivered());
                    final MessageListener messageListener2 = messageListener;
                    Object object3 = object;
                    try {
                        this.messageListenerSubject.doAs(KERNEL_ID, new PrivilegedExceptionAction((MessageImpl)object3){
                            private final /* synthetic */ MessageImpl val$finalMessage;
                            {
                                this.val$finalMessage = messageImpl;
                            }

                            public Object run() throws JMSException {
                                JMSSession.this.onMessage(messageListener2, this.val$finalMessage);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.clearState(4);
            this.popMLContext((ClassLoader)object2);
        }
    }

    public synchronized Topic createTopic(String string) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException("Unsupported topic operation from QueueSession");
        }
        return (Topic)this.createDestination(string, 2);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        byte by = 5;
        return (TopicSubscriber)this.createConsumer(topic, null, false, null, by);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        this.checkClosed();
        byte by = 5;
        return (TopicSubscriber)this.createConsumer(topic, string, bl, null, by);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException("Unsupported topic operation from QueueSession");
        }
        return this.createDurableSubscriber(topic, string, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (string == null) {
            throw new weblogic.jms.common.JMSException("Name must not be null");
        }
        if (string.length() == 0) {
            throw new weblogic.jms.common.JMSException("Name must not be empty string");
        }
        if (topic instanceof DistributedDestinationImpl) {
            throw new weblogic.jms.common.JMSException("Topic must not be Distributed Topic");
        }
        byte by = 5;
        return (TopicSubscriber)this.createConsumer(topic, string2, bl, string, by);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        byte by = 4;
        return (TopicPublisher)this.createProducer(topic, by);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException("Unsupported topic operation from QueueSession");
        }
        return (TemporaryTopic)this.createTemporaryDestination(8);
    }

    public synchronized void unsubscribe(String string) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException("Unsupported topic operation from QueueSession");
        }
        if (string == null || string.length() == 0) {
            throw new InvalidDestinationException("Invalid subscription, null");
        }
        if (this.clientID == null) {
            throw new weblogic.jms.common.JMSException("Connection clientID is null");
        }
        this.subscriptionRemove(string, 2);
    }

    public synchronized Queue createQueue(String string) throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException("Unsupported queue operation from TopicSession");
        }
        return (Queue)this.createDestination(string, 1);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        byte by = 3;
        return (QueueReceiver)this.createConsumer(queue, null, false, null, by);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        byte by = 3;
        return (QueueReceiver)this.createConsumer(queue, string, false, null, by);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        byte by = 2;
        return (QueueSender)this.createProducer(queue, by);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException("Unsupported queue operation from TopicSession");
        }
        byte by = 3;
        Destination.checkDestinationType(queue, by);
        JMSQueueBrowser jMSQueueBrowser = new JMSQueueBrowser(queue, string, this);
        this.browsers.put(jMSQueueBrowser.getId(), jMSQueueBrowser);
        try {
            InvocableManager.invocableAdd(22, jMSQueueBrowser);
        }
        catch (Exception exception) {
            JMSLogger.logStackTrace(exception);
        }
        return jMSQueueBrowser;
    }

    synchronized void closeBrowser(JMSID jMSID, boolean bl) throws JMSException {
        if (this.browsers.remove(jMSID) == null) {
            return;
        }
        if (!bl) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCloseRequest(jMSID));
        }
        try {
            InvocableManager.invocableRemove(22, jMSID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination) throws JMSException {
        this.checkClosed();
        return this.createConsumer(destination, null, false, null, (byte)0);
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination, String string) throws JMSException {
        return this.createConsumer(destination, string, false, null, (byte)0);
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        return this.createConsumer(destination, string, bl, null, (byte)0);
    }

    private synchronized MessageConsumer createConsumer(javax.jms.Destination destination, String string, boolean bl, String string2, byte by) throws JMSException {
        Object object;
        JMSConsumer jMSConsumer;
        this.checkClosed();
        Destination.checkDestinationType(destination, by);
        if (this.acknowledgeMode != 128) {
            if (!((DestinationImpl)destination).isTopic()) {
                string2 = null;
            } else if (string2 != null) {
                if (string2.length() == 0) {
                    string2 = null;
                } else if (this.clientID == null) {
                    throw new weblogic.jms.common.JMSException("Connection clientID is null");
                }
            }
            jMSConsumer = this.createConsumerInternal(this, string2, (DestinationImpl)destination, string, bl, this.messagesMaximum);
        } else {
            if (((DestinationImpl)destination).isQueue()) {
                throw new weblogic.jms.common.JMSException("Queues do not support multicast");
            }
            if (string2 != null) {
                string2 = null;
            }
            object = ((DestinationImpl)destination).getMulticastAddress();
            int n = ((DestinationImpl)destination).getPort();
            if (object == null || n <= 0) {
                throw new weblogic.jms.common.JMSException("Topic " + destination + " does not support multicast");
            }
            try {
                if (this.mSock == null) {
                    this.dgmSock = new JMSTDMSocketIPM(n);
                    this.dgmSock.setSoTimeout(1000);
                    this.mSock = new JMSTMSocket(this, this.dgmSock, 1, n);
                    Kernel.execute((ExecuteRequest)this.mSock, this.dispatchPolicyIndex);
                }
            }
            catch (IOException iOException) {
                if (this.mSock != null) {
                    this.mSock.close();
                }
                if (this.dgmSock != null) {
                    this.dgmSock.close();
                }
                throw new weblogic.jms.common.JMSException("Cannot open multicast socket", iOException);
            }
            jMSConsumer = this.createConsumerInternal(this, string2, (DestinationImpl)destination, string, bl, this.messagesMaximum);
            try {
                this.mSock.joinGroup((DestinationImpl)destination, jMSConsumer);
            }
            catch (IOException iOException) {
                throw new weblogic.jms.common.JMSException("Can not join multicasting group <" + (String)object + "> " + iOException.toString());
            }
        }
        object = this.consumerCreate(string2, (DestinationImpl)destination, string, bl, this.messagesMaximum);
        jMSConsumer.setId(((FEConsumerCreateResponse)object).getConsumerId());
        jMSConsumer.setRuntimeMBeanName(((FEConsumerCreateResponse)object).getRuntimeMBeanName());
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Created JMSConsumer (id: " + jMSConsumer.getId() + ")");
        }
        this.consumerAdd(jMSConsumer);
        return jMSConsumer;
    }

    protected JMSConsumer createConsumerInternal(JMSSession jMSSession, String string, DestinationImpl destinationImpl, String string2, boolean bl, int n) throws JMSException {
        return new JMSConsumer(jMSSession, string, destinationImpl, string2, bl, n);
    }

    public synchronized MessageProducer createProducer(javax.jms.Destination destination) throws JMSException {
        return this.createProducer(destination, (byte)0);
    }

    private synchronized MessageProducer createProducer(javax.jms.Destination destination, byte by) throws JMSException {
        this.checkClosed();
        Destination.checkDestinationType(destination, by);
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCreateRequest(this.sessionId, (DestinationImpl)destination));
        JMSID jMSID = ((FEProducerCreateResponse)response).getProducerId();
        JMSProducer jMSProducer = new JMSProducer(this, jMSID, (DestinationImpl)destination, ((FEProducerCreateResponse)response).getRuntimeMBeanName());
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "CLIENT/JMSSession (id: " + this.sessionId + ") : " + "Created JMSProducer (id: " + jMSID + ")");
        }
        this.producerAdd(jMSProducer);
        return jMSProducer;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException("Unsupported queue operation from TopicSession");
        }
        return (TemporaryQueue)this.createTemporaryDestination(4);
    }

    public synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = exceptionListener;
        this.saveELContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        block10: {
            ClassLoader classLoader = this.pushELContext();
            try {
                ExceptionListener exceptionListener = this.exceptionListener;
                if (exceptionListener == null) break block10;
                ExceptionListener exceptionListener2 = exceptionListener;
                synchronized (exceptionListener2) {
                    final ExceptionListener exceptionListener3 = exceptionListener;
                    final JMSException jMSException2 = jMSException;
                    try {
                        try {
                            this.exceptionListenerSubject.doAs(KERNEL_ID, new PrivilegedExceptionAction(){

                                public Object run() throws JMSException {
                                    exceptionListener3.onException(jMSException2);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.popELContext(classLoader);
            }
        }
    }

    private FEConsumerCreateResponse consumerCreate(String string, DestinationImpl destinationImpl, String string2, boolean bl, int n) throws JMSException {
        Response response;
        if (!(destinationImpl.getType() != 4 && destinationImpl.getType() != 8 || destinationImpl.getConnection() != null && this.connection.getId().equals(destinationImpl.getConnection().getId()))) {
            throw new InvalidDestinationException("Wrong connection for this temporary destination");
        }
        if (string != null && !this.connection.markDurableSubscriber(string)) {
            throw new weblogic.jms.common.JMSException("Subscription " + string + " is in use");
        }
        try {
            response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerCreateRequest(this.sessionId, this.clientID, string, destinationImpl, string2, bl, n, this.getRedeliveryDelay()));
        }
        catch (JMSException jMSException) {
            if (string != null) {
                this.connection.removeDurableSubscriber(string);
            }
            throw jMSException;
        }
        if (!(response instanceof FEConsumerCreateResponse)) {
            if (string != null) {
                this.connection.removeDurableSubscriber(string);
            }
            throw new weblogic.jms.common.JMSException("Unexpected response " + response);
        }
        JMSID jMSID = ((FEConsumerCreateResponse)response).getConsumerId();
        if (string != null) {
            this.connection.addDurableSubscriber(string, jMSID);
        }
        return (FEConsumerCreateResponse)response;
    }

    private synchronized void consumerAdd(JMSConsumer jMSConsumer) {
        this.consumers.put(jMSConsumer.getId(), jMSConsumer);
        try {
            InvocableManager.invocableAdd(6, jMSConsumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void consumerClose(JMSConsumer jMSConsumer) throws JMSException {
        JMSID jMSID;
        if (!this.inListener() || !this.allowCloseInOnMessage) {
            this.waitForState(-5);
        }
        Object object = jMSConsumer;
        synchronized (object) {
            if (jMSConsumer.isClosed()) {
                return;
            }
            jMSID = this.consumerCloseLocal(jMSConsumer, true);
        }
        object = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEConsumerCloseRequest(jMSID, this.lastSequenceNumber));
        this.waitForOutstandingReceives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSID consumerCloseLocal(JMSConsumer jMSConsumer, boolean bl) throws JMSException {
        JMSID jMSID;
        JMSConsumer jMSConsumer2 = jMSConsumer;
        synchronized (jMSConsumer2) {
            this.consumerRemove(jMSConsumer, bl);
            jMSID = jMSConsumer.getId();
            jMSConsumer.setId(null);
            if (bl && this.acknowledgeMode == 128) {
                this.leaveGroup((DestinationImpl)jMSConsumer.getDestination(), jMSConsumer);
            }
        }
        return jMSID;
    }

    synchronized JMSConsumer consumerFind(JMSID jMSID) {
        return (JMSConsumer)this.consumers.get(jMSID);
    }

    synchronized void consumerRemove(JMSConsumer jMSConsumer, boolean bl) {
        if (bl) {
            this.consumers.remove(jMSConsumer.getId());
        }
        try {
            InvocableManager.invocableRemove(6, jMSConsumer.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void producerAdd(JMSProducer jMSProducer) {
        this.producers.put(jMSProducer.getId(), jMSProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void producerClose(JMSID jMSID) throws JMSException {
        this.checkClosed();
        Object object = this;
        synchronized (object) {
            this.producers.remove(jMSID);
        }
        object = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCloseRequest(jMSID));
    }

    public void handleException(Exception exception) throws JMSException {
        if (exception instanceof JMSException) {
            throw (JMSException)exception;
        }
        throw new weblogic.jms.common.JMSException("System error: " + exception.toString(), exception);
    }

    private javax.jms.Destination createDestination(String string, int n) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEDestinationCreateRequest(string, n, false));
        return ((JMSDestinationCreateResponse)response).getDestination();
    }

    final JMSID createBackEndBrowser(DestinationImpl destinationImpl, String string) throws JMSException {
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCreateRequest(this.connection.getId(), this.sessionId, destinationImpl, string));
        return ((JMSBrowserCreateResponse)response).getBrowserId();
    }

    private synchronized javax.jms.Destination createTemporaryDestination(int n) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FETemporaryDestinationCreateRequest(this.connection.getId(), n, true));
        ((FETemporaryDestinationCreateResponse)response).getDestination().setConnection(this.connection);
        return ((FETemporaryDestinationCreateResponse)response).getDestination();
    }

    final void setDeliveryMode(int n) {
        this.deliveryMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscriptionRemove(String string, int n) throws JMSException {
        if (!this.connection.markDurableSubscriber(string)) {
            throw new weblogic.jms.common.JMSException("Subscription " + string + " is in use");
        }
        try {
            this.connection.consumerRemove(string);
        }
        finally {
            this.connection.removeDurableSubscriber(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushMessage(MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        JMSPushRequest jMSPushRequest = new JMSPushRequest(0, this.sessionId, messageImpl);
        jMSPushRequest.setPushEntries(jMSPushEntry);
        Object object = this.lockObject;
        synchronized (object) {
            this.addSelfSequencePushRequest(jMSPushRequest);
        }
    }

    public final JMSPushRequest getFirstPushRequest() {
        return this.firstPushRequest;
    }

    private final void addSelfSequencePushRequest(JMSPushRequest jMSPushRequest) {
        if (this.acknowledgeMode == 128) {
            if (this.messagesMaximum != -1 && this.pushRequestCount >= this.messagesMaximum) {
                if (this.overrunPolicy == 0) {
                    this.onException(new DataOverrunException("Dropping newer message", jMSPushRequest.getMessage().getJMSMessageID(), jMSPushRequest.getMessage().getJMSCorrelationID(), jMSPushRequest.getMessage().getJMSDestination()));
                    return;
                }
                this.onException(new DataOverrunException("Dropping older message", this.firstPushRequest.getMessage().getJMSMessageID(), this.firstPushRequest.getMessage().getJMSCorrelationID(), this.firstPushRequest.getMessage().getJMSDestination()));
                this.firstPushRequest = (JMSPushRequest)this.firstPushRequest.getNext();
                --this.pushRequestCount;
            }
            ++this.pushRequestCount;
        }
        if (this.firstPushRequest == null) {
            this.firstPushRequest = jMSPushRequest;
        } else {
            this.lastPushRequest.setNext(jMSPushRequest);
        }
        this.lastPushRequest = jMSPushRequest;
    }

    private final void addPushRequests(JMSPushRequest jMSPushRequest, boolean bl) {
        JMSPushRequest jMSPushRequest2 = jMSPushRequest;
        while (jMSPushRequest2.getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
            if ((jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext()) != null) continue;
            return;
        }
        JMSPushRequest jMSPushRequest3 = jMSPushRequest2;
        while (jMSPushRequest3.getNext() != null) {
            jMSPushRequest3 = (JMSPushRequest)jMSPushRequest3.getNext();
        }
        if (bl) {
            if (this.firstReceivePushRequest == null) {
                this.firstReceivePushRequest = jMSPushRequest2;
                this.lastReceivePushRequest = jMSPushRequest3;
                return;
            }
        } else if (this.firstPushRequest == null) {
            this.firstPushRequest = jMSPushRequest2;
            this.lastPushRequest = jMSPushRequest3;
            return;
        }
        if (bl) {
            if (jMSPushRequest2.getFrontEndSequenceNumber() < this.firstReceivePushRequest.getFrontEndSequenceNumber()) {
                jMSPushRequest3.setNext(this.firstReceivePushRequest);
                this.firstReceivePushRequest = jMSPushRequest2;
                return;
            }
        } else if (jMSPushRequest2.getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
            jMSPushRequest3.setNext(this.firstPushRequest);
            this.firstPushRequest = jMSPushRequest2;
            return;
        }
        if (bl) {
            if (jMSPushRequest2.getFrontEndSequenceNumber() > this.lastReceivePushRequest.getFrontEndSequenceNumber()) {
                this.lastReceivePushRequest.setNext(jMSPushRequest2);
                this.lastReceivePushRequest = jMSPushRequest3;
                return;
            }
        } else if (jMSPushRequest2.getFrontEndSequenceNumber() > this.lastPushRequest.getFrontEndSequenceNumber()) {
            this.lastPushRequest.setNext(jMSPushRequest2);
            this.lastPushRequest = jMSPushRequest3;
            return;
        }
        JMSPushRequest jMSPushRequest4 = bl ? this.firstReceivePushRequest : this.firstPushRequest;
        while (jMSPushRequest4.getNext() != null) {
            if (jMSPushRequest2.getFrontEndSequenceNumber() < ((JMSPushRequest)jMSPushRequest4.getNext()).getFrontEndSequenceNumber()) {
                jMSPushRequest3.setNext(jMSPushRequest4.getNext());
                jMSPushRequest4.setNext(jMSPushRequest2);
                break;
            }
            jMSPushRequest4 = (JMSPushRequest)jMSPushRequest4.getNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearPushRequests() {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                this.removePushRequests();
            }
        }
    }

    private final JMSPushRequest removePushRequests() {
        JMSPushRequest jMSPushRequest = this.firstPushRequest;
        if (jMSPushRequest == null) {
            return null;
        }
        if (this.acknowledgeMode == 128) {
            this.lastPushRequest = null;
            this.firstPushRequest = null;
            this.pushRequestCount = 0;
            return jMSPushRequest;
        }
        JMSPushRequest jMSPushRequest2 = null;
        do {
            this.expectedSequenceNumber = this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() + 1L;
            jMSPushRequest2 = this.firstPushRequest;
            this.firstPushRequest = (JMSPushRequest)this.firstPushRequest.getNext();
        } while (this.firstPushRequest != null && this.firstPushRequest.getFrontEndSequenceNumber() == this.expectedSequenceNumber);
        if (this.firstPushRequest == null) {
            this.lastPushRequest = null;
        } else {
            jMSPushRequest2.setNext(null);
        }
        return jMSPushRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setExpectedSequenceNumber(long l, boolean bl) {
        Object object = this.lockObject;
        synchronized (object) {
            JMSPushRequest jMSPushRequest = this.firstPushRequest;
            JMSPushRequest jMSPushRequest2 = null;
            if (bl || l > this.expectedSequenceNumber) {
                this.expectedSequenceNumber = l;
            }
            if (bl || jMSPushRequest == null) {
                return;
            }
            while (jMSPushRequest.getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
                boolean bl2 = true;
                JMSPushEntry jMSPushEntry = null;
                for (JMSPushEntry jMSPushEntry2 = jMSPushRequest.getFirstPushEntry(); jMSPushEntry2 != null; jMSPushEntry2 = jMSPushEntry2.getNext()) {
                    if (jMSPushEntry2.getClientResponsibleForAcknowledge()) {
                        bl2 = false;
                    } else if (jMSPushEntry == null) {
                        jMSPushRequest.removePushEntry();
                    } else {
                        jMSPushEntry.setNext(jMSPushEntry2.getNext());
                    }
                    jMSPushEntry = jMSPushEntry2;
                }
                if (bl2) {
                    if (jMSPushRequest2 == null) {
                        this.firstPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                        if (this.firstPushRequest == null) {
                            this.lastPushRequest = null;
                            return;
                        }
                    } else {
                        jMSPushRequest2.setNext(jMSPushRequest.getNext());
                    }
                } else {
                    jMSPushRequest2 = jMSPushRequest;
                }
                jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
            }
        }
    }

    private final boolean havePushRequests() {
        if (this.firstPushRequest == null) {
            return false;
        }
        if (this.acknowledgeMode == 128) {
            return true;
        }
        return this.firstPushRequest.getFrontEndSequenceNumber() == this.expectedSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushMessage(Request request, boolean bl) {
        JMSPushRequest jMSPushRequest = (JMSPushRequest)request;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.acknowledgeMode == 128) {
                this.addSelfSequencePushRequest(jMSPushRequest);
            } else {
                this.addPushRequests(jMSPushRequest, bl);
            }
            if (this.running || this.stopped) {
                return;
            }
            if (!this.havePushRequests()) {
                return;
            }
            this.running = true;
        }
        try {
            object = Thread.currentThread();
            if (this.connection.isLocal() || !(object instanceof ExecuteThread) || ((ExecuteThread)object).getExecuteThreadManager() != this.dispatchPolicyManager) {
                Kernel.execute((ExecuteRequest)this, this.dispatchPolicyIndex);
            } else {
                Kernel.execute((ExecuteRequest)this, "direct");
            }
        }
        catch (Throwable throwable) {
            Object object2 = this.lockObject;
            synchronized (object2) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ExecuteThread executeThread) {
        ExecuteThreadManager executeThreadManager = executeThread.getExecuteThreadManager();
        AbstractSubject abstractSubject = null;
        ClassLoader classLoader = null;
        Context context = null;
        ClassLoader classLoader2 = null;
        if (Kernel.isServer()) {
            classLoader = classLoader2 = executeThread.getContextClassLoader();
        }
        try {
            JMSPushRequest jMSPushRequest;
            Object object;
            Object object2 = this;
            synchronized (object2) {
                object = this.lockObject;
                synchronized (object) {
                    jMSPushRequest = this.removePushRequests();
                }
                this.setState(4);
            }
            try {
                do {
                    object = jMSPushRequest.getMessage();
                    JMSPushEntry jMSPushEntry = null;
                    if (this.connection.isLocal()) {
                        object = ((MessageImpl)object).copy();
                    }
                    ((MessageImpl)object).setForwarded(false);
                    jMSPushEntry = jMSPushRequest.removePushEntry();
                    while (jMSPushEntry != null) {
                        JMSConsumer jMSConsumer = this.consumerFind(jMSPushEntry.getConsumerId());
                        boolean bl = jMSPushEntry.getClientResponsibleForAcknowledge();
                        if (jMSConsumer != null && !jMSConsumer.isClosed()) {
                            ((MessageImpl)object).setJMSDestinationImpl((DestinationImpl)jMSConsumer.getDestination());
                            if (jMSPushEntry.getFrontEndSequenceNumber() >= jMSConsumer.getExpectedSequenceNumber() && (object2 = jMSConsumer.getListener()) != null) {
                                Object object3 = jMSPushEntry.getNext() == null ? object : ((MessageImpl)object).copy();
                                ((MessageImpl)object3).setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
                                ((MessageImpl)object3).setJMSRedelivered(jMSPushEntry.getRedelivered());
                                ((MessageImpl)object3).setClientResponsibleForAcknowledge(bl);
                                this.addUnackedMessage(jMSConsumer, (MessageImpl)object3);
                                Context context2 = jMSConsumer.getListenerContext();
                                ClassLoader classLoader3 = jMSConsumer.getListenerClassLoader();
                                AbstractSubject abstractSubject2 = jMSConsumer.getListenerSubject();
                                if (abstractSubject2 != abstractSubject) {
                                    if (abstractSubject != null) {
                                        this.subjectManager.popSubject(KERNEL_ID);
                                    }
                                    this.subjectManager.pushSubject(KERNEL_ID, abstractSubject2);
                                    abstractSubject = abstractSubject2;
                                }
                                if (Kernel.isServer()) {
                                    if (context2 != context) {
                                        if (context != null) {
                                            JMSServerUtilities.popLocalJNDIContext();
                                        }
                                        JMSServerUtilities.pushLocalJNDIContext((Context)context2);
                                        context = context2;
                                    }
                                    if (classLoader3 != classLoader) {
                                        executeThread.setContextClassLoader(classLoader3);
                                        classLoader = classLoader3;
                                    }
                                }
                                try {
                                    this.decrementWindow = true;
                                    this.onMessage((MessageListener)object2, (MessageImpl)object3);
                                }
                                catch (Exception exception) {
                                    JMSLogger.logStackTrace(exception);
                                }
                                finally {
                                    if (this.decrementWindow) {
                                        jMSConsumer.decrementWindowCurrent(bl);
                                    }
                                }
                                if (this.recovering) {
                                    JMSSession jMSSession = this;
                                    synchronized (jMSSession) {
                                        Object object4 = this.lockObject;
                                        synchronized (object4) {
                                            if (this.recovering) {
                                                if (jMSPushRequest.getFirstPushEntry() == null) {
                                                    jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                                                }
                                                if (jMSPushRequest != null) {
                                                    this.addPushRequests(jMSPushRequest, false);
                                                }
                                                jMSPushRequest = null;
                                                this.recovering = false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        jMSPushEntry = jMSPushRequest.removePushEntry();
                    }
                    if (jMSPushRequest == null) continue;
                    jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                } while (jMSPushRequest != null);
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                this.clearState(4);
                Object object5 = this.lockObject;
                synchronized (object5) {
                    if (!this.stopped && this.havePushRequests()) {
                        throw throwable;
                    }
                    this.running = false;
                }
                Object var26_26 = null;
                executeThread.setContextClassLoader(classLoader2);
                if (Kernel.isServer()) {
                    if (context != null) {
                        JMSServerUtilities.popLocalJNDIContext();
                    }
                    if (abstractSubject != null) {
                        this.subjectManager.popSubject(KERNEL_ID);
                    }
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var26_28 = null;
            executeThread.setContextClassLoader(classLoader2);
            if (Kernel.isServer()) {
                if (context != null) {
                    JMSServerUtilities.popLocalJNDIContext();
                }
                if (abstractSubject != null) {
                    this.subjectManager.popSubject(KERNEL_ID);
                }
            }
            throw throwable;
        }
    }

    private void onMessage(MessageListener messageListener, MessageImpl messageImpl) throws JMSException {
        if (!this.transacted && this.acknowledgeMode == 2) {
            messageImpl.setSession(this);
        }
        this.lastSequenceNumber = messageImpl.getSequenceNumber();
        try {
            messageImpl.setSerializeDestination(true);
            messageListener.onMessage(messageImpl);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = new RuntimeException("Client possibly malfunctioning as RuntimeException thrown from the onMessage routine of the client");
            JMSLogger.logStackTrace(runtimeException);
            if (!(this.transacted || this.acknowledgeMode != 1 && this.acknowledgeMode != 3)) {
                messageImpl.setJMSRedelivered(true);
                try {
                    messageListener.onMessage(messageImpl);
                }
                catch (RuntimeException runtimeException3) {
                    // empty catch block
                }
            }
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(runtimeException2.getMessage());
            this.onException(jMSException);
        }
        if (this.lastSequenceNumber != 0L && this.acknowledgeMode != 2 && this.acknowledgeMode != 4 && this.acknowledgeMode != 128 && !this.transacted) {
            try {
                this.acknowledge(messageImpl);
            }
            catch (JMSException jMSException) {
                this.onException(jMSException);
            }
        }
    }

    void decrementConsumerListenerCount() {
        --this.consumerListenerCount;
    }

    void incrementConsumerListenerCount() {
        ++this.consumerListenerCount;
    }

    void setState(int n) {
        this.state |= n;
        if ((n & 4) != 0) {
            this.listenerThread = Thread.currentThread();
        }
    }

    private boolean inState(int n) {
        return (this.state & n) != 0;
    }

    private boolean inListener() {
        return Thread.currentThread().equals(this.listenerThread);
    }

    synchronized void clearState(int n) {
        this.state &= ~n;
        if ((n & 4) != 0) {
            this.listenerThread = null;
        }
        if (this.waiterCount > 0) {
            this.notifyAll();
        }
    }

    void waitForState(int n) throws JMSException {
        while ((this.state & ~n) != 0) {
            ++this.waiterCount;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new weblogic.jms.common.JMSException(interruptedException.toString());
            }
            finally {
                --this.waiterCount;
            }
        }
    }

    private boolean isClosed() {
        return this.sessionId == null;
    }

    synchronized void checkClosed() throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException("Session is closed");
    }

    void leaveGroup(DestinationImpl destinationImpl, JMSConsumer jMSConsumer) throws JMSException {
        try {
            this.mSock.leaveGroup(destinationImpl, jMSConsumer);
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException("Cannot leave IP Multicast group <" + destinationImpl.getMulticastAddress() + ">");
        }
    }

    synchronized void leaveAllGroup() throws JMSException {
        try {
            this.mSock.stop();
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException(iOException.toString());
        }
    }

    synchronized void joinAllGroup() throws JMSException {
        try {
            this.mSock.start();
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException(iOException.toString());
        }
    }

    private synchronized void addUnackedMessage(JMSConsumer jMSConsumer, MessageImpl messageImpl) throws JMSException {
        if (this.acknowledgeMode == 3 || this.acknowledgeMode == 4 || this.acknowledgeMode == 128) {
            return;
        }
        if (!messageImpl.getClientResponsibleForAcknowledge()) {
            UnackedMessage unackedMessage = new UnackedMessage(jMSConsumer, messageImpl.getSequenceNumber());
            unackedMessage.next = this.firstUnackedMessage;
            this.firstUnackedMessage = unackedMessage;
        } else {
            JMSMessageReference jMSMessageReference;
            if (this.messageList == null) {
                this.messageList = new MessageList();
            }
            long l = messageImpl.getSequenceNumber();
            if (this.mRefCache != null) {
                jMSMessageReference = this.mRefCache;
                this.mRefCache = null;
                jMSMessageReference.reset(messageImpl, jMSConsumer);
            } else {
                jMSMessageReference = new JMSMessageReference(messageImpl, jMSConsumer);
            }
            messageImpl.setMessageReference(jMSMessageReference);
            jMSMessageReference.setSequenceNumber(l);
            this.messageList.add(jMSMessageReference);
        }
    }

    private synchronized void removeUnackedMessage(long l, boolean bl, boolean bl2) {
        if (!bl) {
            UnackedMessage unackedMessage = this.firstUnackedMessage;
            UnackedMessage unackedMessage2 = null;
            while (unackedMessage != null && l != unackedMessage.sequenceNumber) {
                unackedMessage2 = unackedMessage;
                unackedMessage = unackedMessage.next;
            }
            if (unackedMessage != null) {
                if (unackedMessage == this.firstUnackedMessage) {
                    this.firstUnackedMessage = null;
                } else {
                    unackedMessage2.next = null;
                }
                while (unackedMessage != null) {
                    JMSConsumer jMSConsumer = unackedMessage.consumer;
                    if (!bl2 && jMSConsumer.getWindowCurrent() < jMSConsumer.getWindowMaximum()) {
                        jMSConsumer.setWindowCurrent(jMSConsumer.getWindowCurrent() + 1);
                    }
                    unackedMessage = unackedMessage.next;
                }
            }
            return;
        }
        if (this.acknowledgeMode == 3) {
            return;
        }
        if (this.messageList == null) {
            return;
        }
        JMSMessageReference jMSMessageReference = (JMSMessageReference)this.messageList.removeBeforeSequenceNumber(l);
        if (this.mRefCache == null && jMSMessageReference != null) {
            jMSMessageReference.prepareForCache();
            this.mRefCache = jMSMessageReference;
            jMSMessageReference = null;
        }
    }

    public void setDecrementWindow(boolean bl) {
        this.decrementWindow = bl;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15620: {
                this.pushMessage(request, false);
                return Integer.MAX_VALUE;
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId() + " for class " + this.getClass().getName());
    }

    class UnackedMessage {
        JMSConsumer consumer;
        long sequenceNumber;
        UnackedMessage next;

        UnackedMessage(JMSConsumer jMSConsumer, long l) {
            this.consumer = jMSConsumer;
            this.sequenceNumber = l;
        }
    }
}

