/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;

public final class JMSXAConnection
extends JMSConnection
implements XAQueueConnection,
XATopicConnection,
JMSPeerGoneListener,
Externalizable,
Invocable {
    static final long serialVersionUID = -4665036665162468456L;
    private static final byte EXTVERSION = 1;

    public JMSXAConnection(JMSID jMSID, String string, int n, int n2, long l, long l2, long l3, long l4, long l5, boolean bl, boolean bl2, int n3, int n4, int n5, boolean bl3, DispatcherWrapper dispatcherWrapper, boolean bl4, int n6, int n7, int n8, int n9, PeerVersionable peerVersionable, String string2, String string3, PeerInfo peerInfo) {
        super(jMSID, string, n, n2, l, l2, l3, l4, l5, true, bl2, n3, n4, n5, bl3, dispatcherWrapper, bl4, n6, n7, n8, n9, false, peerVersionable, string2, string3, peerInfo);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        JMSSession jMSSession = this.createSessionInternal(false, 2, true);
        jMSSession.setType(2);
        return (XAQueueSession)((Object)jMSSession);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        JMSSession jMSSession = this.createSessionInternal(false, 2, true);
        jMSSession.setType(1);
        return (XATopicSession)((Object)jMSSession);
    }

    public XASession createXASession() throws JMSException {
        return (XASession)((Object)this.createSessionInternal(false, 2, true));
    }

    public JMSXAConnection() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
    }
}

