/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.rmi.extensions.server.RemoteWrapper;

public final class JMSXAConnectionFactory
extends JMSConnectionFactory
implements XAQueueConnectionFactory,
XATopicConnectionFactory,
Externalizable,
RemoteWrapper {
    static final long serialVersionUID = 343051208017579157L;
    private static final byte EXTVERSION = 1;

    public JMSXAConnectionFactory(FEConnectionFactoryRemote fEConnectionFactoryRemote) {
        super(fEConnectionFactoryRemote);
    }

    public XAQueueConnection createXAQueueConnection(String string, String string2) throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(string, string2, true);
        jMSConnection.setType(1);
        return (XAQueueConnection)((Object)jMSConnection);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(null, null, true);
        jMSConnection.setType(1);
        return (XAQueueConnection)((Object)jMSConnection);
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        return (XAConnection)((Object)this.createConnectionInternal(string, string2, true));
    }

    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)((Object)this.createConnectionInternal(null, null, true));
    }

    public XATopicConnection createXATopicConnection(String string, String string2) throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(string, string2, true);
        jMSConnection.setType(2);
        return (XATopicConnection)((Object)jMSConnection);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        JMSConnection jMSConnection = this.createConnectionInternal(null, null, true);
        jMSConnection.setType(2);
        return (XATopicConnection)((Object)jMSConnection);
    }

    public JMSXAConnectionFactory() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
    }

    public Remote getRemoteDelegate() {
        return super.getRemoteDelegate();
    }
}

