/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.transaction.xa.XAResource;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.kernel.Kernel;
import weblogic.transaction.TransactionHelper;

public final class JMSXASession
extends JMSSession
implements XASession,
XAQueueSession,
XATopicSession {
    private static final String TX_HELPER_CLASS = "weblogic.transaction.TxHelper";
    private boolean originalTransacted;
    static /* synthetic */ Class class$javax$naming$Context;
    static /* synthetic */ Class class$java$lang$String;

    protected JMSXASession(JMSConnection jMSConnection, boolean bl, int n, boolean bl2) throws JMSException {
        super(jMSConnection, false, 2, bl2);
        this.setUserTransactionsEnabled(true);
        this.originalTransacted = bl;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.originalTransacted;
    }

    public void commit() throws JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new weblogic.jms.common.IllegalStateException("No transaction");
        }
        throw new TransactionInProgressException("Error commiting session");
    }

    public void rollback() throws JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new weblogic.jms.common.IllegalStateException("No transaction");
        }
        throw new TransactionInProgressException("Error rolling back session");
    }

    public XAResource getXAResource() {
        if (!Kernel.isServer()) {
            throw new IllegalStateException("can only be called from server");
        }
        try {
            Class<?> clazz = Class.forName(TX_HELPER_CLASS);
            Method method = clazz.getMethod("getServerInterposedTransactionManager", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object == null) {
                return null;
            }
            method = object.getClass().getMethod("getXAResource", new Class[0]);
            return (XAResource)method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public XAResource getXAResource(Context context, String string) {
        try {
            Class<?> clazz = Class.forName("TX_HELPER_CLASS");
            Method method = clazz.getMethod("getClientInterposedTransactionManager", class$javax$naming$Context == null ? (class$javax$naming$Context = JMSXASession.class$("javax.naming.Context")) : class$javax$naming$Context, class$java$lang$String == null ? (class$java$lang$String = JMSXASession.class$("java.lang.String")) : class$java$lang$String);
            Object object = method.invoke(null, context, string);
            if (object == null) {
                return null;
            }
            method = object.getClass().getMethod("getXAResource", new Class[0]);
            return (XAResource)method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public QueueSession getQueueSession() {
        return (QueueSession)this.getSession();
    }

    public TopicSession getTopicSession() {
        return (TopicSession)this.getSession();
    }

    public Session getSession() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

