/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.PutBackable;

public final class BufferDataInputStream
extends InputStream
implements DataInput,
ObjectInput,
PutBackable {
    private byte[] buf;
    private int pos;
    private int mark = 0;
    private int offset;
    private int count;
    private ObjectIOBypass objectIOBypass;
    private static final int VERSION = 1234;
    private byte magic0;
    private byte magic1;
    private byte magic2;
    private byte magic3;
    private byte magic4;
    private byte magic5;
    private byte magic6;
    private byte magic7;
    private int blockSize;

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
        this.offset = 0;
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.offset = n;
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, int n) {
        this.buf = new byte[n];
        this.pos = 0;
        this.count = n;
        this.offset = 0;
        this.objectIOBypass = objectIOBypass;
    }

    public void ensureCapacity(int n) {
        if (n > this.buf.length) {
            this.buf = new byte[n];
        }
    }

    public void resizeCapacity(int n) {
        this.buf = new byte[n];
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public void mark() {
        this.mark = this.pos;
    }

    public void backToMark() {
        this.pos = this.mark;
    }

    public void unput() {
        --this.pos;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() {
        this.pos = this.offset;
    }

    public synchronized void close() throws IOException {
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos + n2 > this.count) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = Math.min(this.count - this.pos, n);
        this.pos += n2;
        return n2;
    }

    public final Object readObject() throws IOException, ClassNotFoundException {
        int n = this.readInt();
        if (n != 1234) {
            throw new StreamCorruptedException("Unknown object stream version. " + n);
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException("Stream can not handle raw objects.");
        }
        return this.objectIOBypass.readObject(this);
    }

    public final boolean readBoolean() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] != 0;
    }

    public final byte readByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    public final int readUnsignedByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public final short readShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((short)(this.buf[this.pos] & 0xFF) << 8) + ((short)(this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (short)n;
    }

    public final int readUnsignedShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return n;
    }

    public final char readChar() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (char)n;
    }

    public final int readInt() throws IOException {
        if (this.pos + 4 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
        this.pos += 4;
        return n;
    }

    public final long readLong() throws IOException {
        if (this.pos + 8 > this.count) {
            throw new EOFException();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        throw new IOException("not implemented");
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void setMagic(long l, int n) {
        this.magic0 = (byte)((int)(l >>> 56) & 0xFF);
        this.magic1 = (byte)((int)(l >>> 48) & 0xFF);
        this.magic2 = (byte)((int)(l >>> 40) & 0xFF);
        this.magic3 = (byte)((int)(l >>> 32) & 0xFF);
        this.magic4 = (byte)(l >>> 24 & 0xFFL);
        this.magic5 = (byte)(l >>> 16 & 0xFFL);
        this.magic6 = (byte)(l >>> 8 & 0xFFL);
        this.magic7 = (byte)(l >>> 0 & 0xFFL);
        this.blockSize = n;
    }

    public final boolean scanForMagic() {
        this.pos = this.pos + (this.blockSize - 1) & ~(this.blockSize - 1);
        while (true) {
            if (this.pos + 8 > this.count) {
                this.pos = this.count;
                return false;
            }
            if (this.buf[this.pos + 0] == this.magic0 && this.buf[this.pos + 1] == this.magic1 && this.buf[this.pos + 2] == this.magic2 && this.buf[this.pos + 3] == this.magic3 && this.buf[this.pos + 4] == this.magic4 && this.buf[this.pos + 5] == this.magic5 && this.buf[this.pos + 6] == this.magic6 && this.buf[this.pos + 7] == this.magic7) {
                return true;
            }
            this.pos += this.blockSize;
        }
    }

    public final String readUTF32() throws IOException {
        int n = this.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        block5: while (n2 < n) {
            int n3 = this.readByte() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    byte by2 = this.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(stringBuffer);
    }
}

