/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferDataOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageEOFException;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;

public final class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = -8264735281046103996L;
    private transient byte[] buffer;
    private transient int length;
    private transient boolean copyOnWrite;
    private transient BufferDataOutputStream bdos;
    private transient BufferDataInputStream bdis;

    public BytesMessageImpl() {
    }

    public BytesMessageImpl(BytesMessage bytesMessage) throws IOException, javax.jms.JMSException {
        this(bytesMessage, (Destination)null, (Destination)null);
    }

    public BytesMessageImpl(BytesMessage bytesMessage, Destination destination, Destination destination2) throws IOException, javax.jms.JMSException {
        super(bytesMessage, destination, destination2);
        byte[] byArray = new byte[128];
        bytesMessage.reset();
        int n = bytesMessage.readBytes(byArray, 128);
        while (n > 0) {
            this.writeBytes(byArray, 0, n);
            n = bytesMessage.readBytes(byArray, 128);
        }
        this.reset();
    }

    public byte getType() {
        return 1;
    }

    public void nullBody() {
        this.buffer = null;
        this.length = 0;
        this.bdis = null;
        this.bdos = null;
        this.copyOnWrite = false;
    }

    public boolean readBoolean() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readBoolean();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public byte readByte() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public int readUnsignedByte() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public short readShort() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public int readUnsignedShort() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public char readChar() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readChar();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public int readInt() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readInt();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public long readLong() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readLong();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public float readFloat() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readFloat();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public double readDouble() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readDouble();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public String readUTF() throws javax.jms.JMSException {
        try {
            this.checkReadable();
            return this.bdis.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("Attempt to read past end of message", eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException("Error reading from stream", iOException);
        }
    }

    public int readBytes(byte[] byArray) throws javax.jms.JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    public int readBytes(byte[] byArray, int n) throws javax.jms.JMSException {
        super.readMode();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Length is negative");
        }
        if (n > byArray.length) {
            throw new IndexOutOfBoundsException("Length is greater than length of array");
        }
        try {
            this.checkReadable();
        }
        catch (javax.jms.MessageEOFException messageEOFException) {
            return -1;
        }
        return this.bdis.read(byArray, 0, n);
    }

    public void writeBoolean(boolean bl) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeByte(byte by) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeShort(short s) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeChar(char c) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeInt(int n) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeLong(long l) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeFloat(float f) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeDouble(double d) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeUTF(String string) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeBytes(byte[] byArray) throws javax.jms.JMSException {
        try {
            this.checkWritable();
            this.bdos.write(byArray);
        }
        catch (IOException iOException) {
            throw new JMSException("Error writing to stream", iOException);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        this.checkWritable();
        this.bdos.write(byArray, n, n2);
    }

    public void writeObject(Object object) throws javax.jms.JMSException {
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Number) {
            if (object instanceof Byte) {
                this.writeByte(((Number)object).byteValue());
            } else if (object instanceof Short) {
                this.writeShort(((Number)object).shortValue());
            } else if (object instanceof Integer) {
                this.writeInt(((Number)object).intValue());
            } else if (object instanceof Long) {
                this.writeLong(((Number)object).longValue());
            } else if (object instanceof Float) {
                this.writeFloat(((Number)object).floatValue());
            } else if (object instanceof Double) {
                this.writeDouble(((Number)object).doubleValue());
            }
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            throw new MessageFormatException("Invalid object type, " + object.getClass().getName());
        }
    }

    public void reset() throws javax.jms.JMSException {
        this.setBodyWritable(false);
        if (this.bdis != null) {
            this.bdis.reset();
        } else if (this.bdos != null) {
            this.buffer = this.bdos.getBuffer();
            this.length = this.bdos.size();
            this.bdos = null;
        }
        this.copyOnWrite = false;
    }

    public MessageImpl copy() {
        BytesMessageImpl bytesMessageImpl = new BytesMessageImpl();
        super.copy(bytesMessageImpl);
        if (this.bdos != null) {
            bytesMessageImpl.buffer = this.bdos.getBuffer();
            bytesMessageImpl.length = this.bdos.size();
            this.copyOnWrite = true;
        } else {
            bytesMessageImpl.buffer = this.buffer;
            bytesMessageImpl.length = this.length;
        }
        bytesMessageImpl.setBodyWritable(false);
        return bytesMessageImpl;
    }

    private void checkWritable() throws javax.jms.JMSException {
        super.writeMode();
        if (this.bdos == null) {
            this.bdos = new BufferDataOutputStream(null, 256);
        } else if (this.copyOnWrite) {
            this.bdos.copyBuffer();
            this.copyOnWrite = false;
        }
    }

    private void checkReadable() throws javax.jms.JMSException {
        super.readMode();
        if (this.bdis == null) {
            if (this.buffer == null) {
                throw new MessageEOFException("Attempt to read past end of message");
            }
            this.bdis = new BufferDataInputStream(null, this.buffer, 0, this.length);
        }
    }

    public String toString() {
        return "BytesMessage[" + this.getJMSMessageID() + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        byte[] byArray;
        super.writeExternal(objectOutput);
        objectOutput.writeByte(2);
        if (this.bdos != null) {
            byArray = this.bdos.getBuffer();
            n = this.bdos.size();
        } else {
            byArray = this.buffer;
            n = this.length;
        }
        if (byArray == null || n == 0) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(n);
            objectOutput.write(byArray, 0, n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        if (by == 2) {
            this.length = objectInput.readInt();
            if (this.length > 0) {
                this.buffer = new byte[this.length];
                objectInput.readFully(this.buffer);
            }
        } else if (objectInput.readBoolean()) {
            this.length = objectInput.readInt();
            this.buffer = new byte[this.length];
            objectInput.readFully(this.buffer);
        }
        this.setBodyWritable(false);
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.buffer != null) {
            this.bodySize = this.length;
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    public long getBodyLength() {
        if (this.bdos != null) {
            return this.bdos.size();
        }
        if (this.bdis != null) {
            return this.bdis.size();
        }
        return this.buffer != null ? (long)this.length : 0L;
    }
}

