/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.common.Destination;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherManager;

public class DestinationImpl
extends Destination
implements Queue,
Topic,
TemporaryQueue,
TemporaryTopic,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    static final long serialVersionUID = 6099783323740404732L;
    public static final byte TYPE_QUEUE = 1;
    public static final byte TYPE_TOPIC = 2;
    public static final byte TYPE_TEMP_QUEUE = 4;
    public static final byte TYPE_TEMP_TOPIC = 8;
    private transient JMSConnection connection;
    private transient boolean closed = false;
    protected String name;
    protected String serverName;
    protected JMSServerId backEndId;
    private String multicastAddress;
    private int port;
    protected JMSID destinationId;
    protected byte type;
    protected DispatcherId dispatcherId;
    protected long generation = 1L;
    private static final int FIRSTGENERATION = 1;
    private static final int _VERSIONMASK = 3840;
    private static final int _VERSIONSHIFT = 8;
    private static final int _TYPEMASK = 15;
    private static final int _TYPESHIFT = 0;
    private static final int _HASGENERATION = 32;
    protected static final int _HASIDS = 4096;
    private static final int _ISNOTREPLYTO = 8192;
    private static final int _HASMULTICASTADDR = 16384;
    private static final int _HASDISPID = 32768;

    public DestinationImpl() {
    }

    public DestinationImpl(int n, String string, String string2, JMSServerId jMSServerId, JMSID jMSID, long l) {
        this.type = (byte)n;
        this.serverName = string;
        this.name = string2;
        this.backEndId = jMSServerId;
        this.destinationId = jMSID;
        this.generation = l;
        DispatcherManager.create();
        this.dispatcherId = DispatcherManager.getLocalDispatcher().getId();
    }

    public DestinationImpl(int n, String string, String string2, JMSServerId jMSServerId, JMSID jMSID) {
        this.type = (byte)n;
        this.serverName = string;
        this.name = string2;
        this.backEndId = jMSServerId;
        this.destinationId = jMSID;
        try {
            DispatcherManager.create();
            this.dispatcherId = DispatcherManager.getLocalDispatcher().getId();
        }
        catch (Exception exception) {
            System.out.println("Fail to Get Local Dispatcher");
        }
    }

    public boolean isQueue() {
        return this.type == 1 || this.type == 4;
    }

    public boolean isTopic() {
        return this.type == 2 || this.type == 8;
    }

    public String getDestinationName() {
        return this.name;
    }

    public String toString() {
        return this.getDestinationName();
    }

    public String getQueueName() {
        return this.getDestinationName();
    }

    public String getTopicName() {
        return this.getDestinationName();
    }

    static int getFirstGeneration() {
        return 1;
    }

    public byte getDestinationInstanceType() {
        return 1;
    }

    public int getType() {
        return this.type;
    }

    public void setBackEndID(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public synchronized JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public JMSID getId() {
        return this.destinationId;
    }

    public synchronized JMSID getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(JMSID jMSID) {
        this.destinationId = jMSID;
    }

    public String getName() {
        return this.getDestinationName();
    }

    public String getServerName() {
        return this.serverName;
    }

    public DispatcherId getDispatcherId() {
        return this.dispatcherId;
    }

    public boolean isStale() {
        return this.dispatcherId == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeDestinationImpl(objectOutput);
    }

    protected void writeDestinationImpl(ObjectOutput objectOutput) throws IOException {
        boolean bl = objectOutput instanceof WLObjectOutput;
        int n = 0;
        n = bl ? (int)((short)(n | 0x200)) : (int)((short)(n | 0x300));
        n = (short)(n | this.type);
        if (!bl && objectOutput instanceof JMSOutputStream && ((JMSOutputStream)((Object)objectOutput)).isJMSStoreOutputStream()) {
            n = (short)(n | 0x20);
            objectOutput.writeShort(n);
            objectOutput.writeUTF(this.name);
            objectOutput.writeUTF(this.serverName);
            objectOutput.writeLong(this.getGeneration());
            return;
        }
        n = (short)(n | 0x1000);
        if (this.multicastAddress != null) {
            n = (short)(n | 0x4000);
        }
        if (this.destinationId != null) {
            n = (short)(n | 0x2000);
        }
        JMSID jMSID = this.destinationId;
        if (this.dispatcherId != null) {
            n = (short)(n | 0x8000);
        }
        objectOutput.writeShort(n);
        if (bl) {
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.name);
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.serverName);
        } else {
            objectOutput.writeUTF(this.name);
            objectOutput.writeUTF(this.serverName);
        }
        if (jMSID != null) {
            this.backEndId.writeExternal(objectOutput);
            jMSID.writeExternal(objectOutput);
        }
        if (this.multicastAddress != null) {
            objectOutput.writeUTF(this.multicastAddress);
            objectOutput.writeInt(this.port);
        }
        if (this.dispatcherId != null) {
            this.dispatcherId.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = objectInput.readShort();
        this.readDestinationImpl(objectInput, s);
    }

    protected void readDestinationImpl(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException {
        byte by = (byte)((n & 0xF00) >>> 8 & 0xFF);
        if (by == 1) {
            this.readExternalVersion1(objectInput, (byte)(n & 0xFF));
            return;
        }
        if (by != 2 && by != 3) {
            throw JMSUtilities.versionIOException(by, 1, 3);
        }
        this.type = (byte)((n & 0xF) >>> 0 & 0xFF);
        if ((n & 0x1000) == 0) {
            this.name = objectInput.readUTF();
            this.serverName = objectInput.readUTF();
            if ((n & 0x20) != 0) {
                this.generation = by == 2 ? (long)objectInput.readInt() : objectInput.readLong();
            }
            return;
        }
        if (objectInput instanceof WLObjectInput) {
            this.name = ((WLObjectInput)objectInput).readAbbrevString();
            this.serverName = ((WLObjectInput)objectInput).readAbbrevString();
        } else {
            this.name = objectInput.readUTF();
            this.serverName = objectInput.readUTF();
        }
        if ((n & 0x2000) != 0) {
            this.backEndId = new JMSServerId();
            this.backEndId.readExternal(objectInput);
            this.destinationId = new JMSID();
            this.destinationId.readExternal(objectInput);
        }
        if ((n & 0x4000) != 0) {
            this.multicastAddress = objectInput.readUTF();
            this.port = objectInput.readInt();
        }
        if ((n & 0x8000) != 0) {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
    }

    public void readExternalVersion1(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        this.type = by;
        this.generation = 1L;
        this.name = objectInput.readUTF();
        this.serverName = objectInput.readUTF();
        if (objectInput.readBoolean()) {
            this.backEndId = new JMSServerId();
            this.backEndId.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.destinationId = new JMSID();
            this.destinationId.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.multicastAddress = objectInput.readUTF();
            this.port = objectInput.readInt();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DestinationImpl)) {
            return false;
        }
        DestinationImpl destinationImpl = (DestinationImpl)object;
        if (destinationImpl == this) {
            return true;
        }
        if (this.type != destinationImpl.type) {
            return false;
        }
        if (this.destinationId == null) {
            return false;
        }
        if (!this.name.equals(destinationImpl.name)) {
            return false;
        }
        return this.destinationId.equals(destinationImpl.destinationId);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void delete() throws javax.jms.JMSException {
        if (this.connection == null) {
            throw new JMSException("Invalid Temporary Destination");
        }
        this.connection.destroyTemporaryDestination(this.backEndId, this.destinationId);
    }

    public void setConnection(JMSConnection jMSConnection) {
        this.connection = jMSConnection;
    }

    public JMSConnection getConnection() {
        return this.connection;
    }

    public void setMulticastAddress(String string) {
        this.multicastAddress = string;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public synchronized long getGeneration() {
        return this.generation;
    }

    public synchronized void setGeneration(long l) {
        this.generation = l;
    }
}

