/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;
import weblogic.jms.dispatcher.DispatcherId;
import weblogic.jms.dispatcher.DispatcherManager;

public final class DistributedDestinationImpl
extends DestinationImpl
implements InteropWriteReplaceable,
Externalizable {
    private static final int DDVERSION1 = 1;
    static final long serialVersionUID = 6099783323740404732L;
    private static final int BE_DESTINATION_NOT_TEMPORARY = 1;
    private int weight = 1;
    private int duration;
    private int loadBalancePolicy;
    private String ddJNDIName;
    private String distributedConfigMbeanName;
    private boolean hasStore;
    private boolean stale;
    private boolean serverAffinityEnabled = true;
    public boolean isProxyTopicMember;
    private boolean isQueueForward;
    private Dispatcher localDispatcher;
    private int nonSystemSubscriberConsumers;
    private int order;
    private static final int _DDVERSIONMASK = 3840;
    private static final int _DDVERSIONSHIFT = 8;
    private static final int _HASDDJNDINAME = 2;
    private static final int _HASSTORE = 4;
    private static final int _HASNONSYSSUBCNT = 8;
    private static final int _ISDURABLE = 16;
    private static final int _ISBOUNDBYINTERNALNAME = 32;
    private static final int _ISQUEUEFORWARD = 64;
    private static final int _ISSERVERAFFINITY = 128;
    private static final int _DONOTUSE_RESERVED = 4096;

    public DistributedDestinationImpl() {
    }

    public DistributedDestinationImpl(int n, String string, String string2, int n2, String string3, String string4, JMSServerId jMSServerId, JMSID jMSID, DispatcherId dispatcherId, int n3, boolean bl, boolean bl2) {
        super(n, string, string3, jMSServerId, jMSID);
        this.ddJNDIName = string4;
        this.distributedConfigMbeanName = string2;
        this.loadBalancePolicy = n2;
        this.dispatcherId = dispatcherId;
        this.duration = n3;
        this.hasStore = bl;
        this.isProxyTopicMember = bl2;
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, " ------- Distributed Destination ------------------------------\n name            = " + this.name + "\n" + " serverName      = " + this.serverName + "\n" + " distributedConfigMbeanName = " + this.distributedConfigMbeanName + "\n" + " ddJNDIName      = " + this.ddJNDIName + "\n" + " --------------------------------------------------------------\n");
        }
    }

    public String toString() {
        return this.getName();
    }

    public int getLoadBalancingPolicy() {
        return this.loadBalancePolicy;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public synchronized int getOrder() {
        return this.order;
    }

    public synchronized void setOrder(int n) {
        this.order = n;
    }

    public boolean isPersistent() {
        return this.hasStore;
    }

    public boolean isDurable() {
        return this.duration != 1;
    }

    public byte getDestinationInstanceType() {
        return 2;
    }

    public boolean isLocal() {
        return this.localDispatcher == null || this.localDispatcher.getId().equals(this.dispatcherId);
    }

    public void setServerAffinityEnabled(boolean bl) {
        this.serverAffinityEnabled = bl;
    }

    public boolean isServerAffinityEnabled() {
        return this.serverAffinityEnabled;
    }

    public void setStale(boolean bl) {
        this.stale = bl;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setQueueForward(boolean bl) {
        this.isQueueForward = bl;
    }

    public boolean isQueueForward() {
        return this.isQueueForward;
    }

    public boolean isProxy() {
        return this.isProxyTopicMember;
    }

    public void setNonSystemSubscriberConsumers(int n) {
        this.nonSystemSubscriberConsumers = n;
    }

    public int getNonSystemSubscriberConsumers() {
        return this.nonSystemSubscriberConsumers;
    }

    public boolean hasConsumer() {
        return this.nonSystemSubscriberConsumers > 0;
    }

    public String getInstanceName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return ((String)object).equals(this.getInstanceName());
        }
        return super.equals(object);
    }

    public boolean same(String string) {
        return string.equals(this.getName());
    }

    public void update(DistributedDestinationImpl distributedDestinationImpl) {
        this.nonSystemSubscriberConsumers = distributedDestinationImpl.nonSystemSubscriberConsumers;
        this.loadBalancePolicy = distributedDestinationImpl.loadBalancePolicy;
        this.weight = distributedDestinationImpl.weight;
        this.isQueueForward = distributedDestinationImpl.isQueueForward;
        this.ddJNDIName = distributedDestinationImpl.ddJNDIName;
        this.destinationId = distributedDestinationImpl.destinationId;
        this.dispatcherId = distributedDestinationImpl.dispatcherId;
    }

    public String getDDJNDIName() {
        return this.ddJNDIName;
    }

    public String getName() {
        return this.distributedConfigMbeanName;
    }

    public void setName(String string) {
        this.distributedConfigMbeanName = string;
    }

    public String getDestinationName() {
        return this.distributedConfigMbeanName;
    }

    public String debugString() {
        if (!JMSDebug.debugJMSCommon) {
            return "Distributed Destination Impl";
        }
        return new String(this.getDestinationName() + " | pers-" + this.isPersistent() + " | cons-" + this.hasConsumer() + " | weit-" + this.getWeight() + " | locl-" + this.isLocal() + " | prox-" + this.isProxy());
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (peerInfo.compareTo(PeerInfo.VERSION_60) < 0) {
            throw new IOException("Peer not compatible with DistributedDestinationImpl version 1.  Peer Major Version is less than 6");
        }
        if (peerInfo.compareTo(PeerInfo.VERSION_70) < 0) {
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "\n   *** Peer > 6 & < 7 WriteReplace DDImpl with DImpl ***\n      serverName = " + this.serverName + "      qname      = " + this.distributedConfigMbeanName);
            }
            return new DestinationImpl(this.type, this.serverName, this.distributedConfigMbeanName, this.backEndId, this.destinationId);
        }
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, "\n   *** Peer > 7 WriteReplace return this ***\n");
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        PeerInfo peerInfo;
        boolean bl = objectOutput instanceof WLObjectOutput;
        if (objectOutput instanceof JMSOutputStream && ((JMSOutputStream)((Object)objectOutput)).isJMSStoreOutputStream()) {
            this.writeDestinationImpl(objectOutput);
            return;
        }
        PeerInfo peerInfo2 = peerInfo = objectOutput instanceof PeerInfoable ? ((PeerInfoable)((Object)objectOutput)).getPeerInfo() : null;
        if (peerInfo != null && !((object = this.interopWriteReplace(peerInfo)) instanceof DistributedDestinationImpl)) {
            this.writeDestinationImpl(objectOutput);
            return;
        }
        this.writeDistributedDestinationImpl(objectOutput);
    }

    public void writeDistributedDestinationImpl(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 1;
        n2 |= n3 << 8;
        n2 |= 0x20;
        if (this.duration == 1) {
            n2 |= 0x10;
        }
        if (this.ddJNDIName != null) {
            n2 |= 2;
        }
        if (this.hasStore) {
            n2 |= 4;
        }
        if (this.serverAffinityEnabled) {
            n2 |= 0x80;
        }
        if ((n = this.nonSystemSubscriberConsumers) != 0) {
            n2 |= 8;
        }
        if (this.isQueueForward) {
            n2 |= 0x40;
        }
        objectOutput.writeShort(n2 |= 0x1000);
        this.writeDestinationImpl(objectOutput);
        if (objectOutput instanceof WLObjectOutput) {
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.distributedConfigMbeanName);
            if ((n2 & 2) != 0) {
                ((WLObjectOutput)objectOutput).writeAbbrevString(this.ddJNDIName);
            }
        } else {
            objectOutput.writeUTF(this.distributedConfigMbeanName);
            if ((n2 & 2) != 0) {
                objectOutput.writeUTF(this.ddJNDIName);
            }
        }
        objectOutput.writeInt(this.loadBalancePolicy);
        objectOutput.writeInt(this.weight);
        if (n != 0) {
            objectOutput.writeLong(n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = 0;
        short s2 = objectInput.readShort();
        if ((s2 & 0x1000) == 0) {
            s = s2;
        } else {
            byte by = (byte)((s2 & 0xF00) >>> 8 & 0xFF);
            if (by != 1) {
                throw JMSUtilities.versionIOException(by, 1, 1);
            }
            s = objectInput.readShort();
        }
        this.readDestinationImpl(objectInput, s);
        try {
            DispatcherManager.create();
            this.localDispatcher = DispatcherManager.getLocalDispatcher();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ((s2 & 0x1000) == 0) {
            return;
        }
        if (objectInput instanceof WLObjectInput) {
            this.distributedConfigMbeanName = ((WLObjectInput)objectInput).readAbbrevString();
            if ((s2 & 2) != 0) {
                this.ddJNDIName = ((WLObjectInput)objectInput).readAbbrevString();
            }
        } else {
            this.distributedConfigMbeanName = objectInput.readUTF();
            if ((s2 & 2) != 0) {
                this.ddJNDIName = objectInput.readUTF();
            }
        }
        this.loadBalancePolicy = objectInput.readInt();
        this.weight = objectInput.readInt();
        if ((s2 & 4) != 0) {
            this.hasStore = true;
        }
        this.serverAffinityEnabled = (s2 & 0x80) != 0;
        if ((s2 & 0x48) != 0) {
            if ((s2 & 8) != 0) {
                this.nonSystemSubscriberConsumers = (int)objectInput.readLong();
            }
            if ((s2 & 0x40) != 0) {
                this.isQueueForward = true;
            }
        }
    }
}

