/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Response;

public final class JMSConsumerReceiveResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -6762955361476059878L;
    private static final byte EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_TYPE_MASK = 65280;
    private static final int MESSAGE_TYPE_SHIFT = 8;
    private static final int TRANSACTIONAL_FLAG = 65536;
    private static final int SEQUENCE_FLAG = 131072;
    private MessageImpl message;
    private long sequenceNumber;
    private boolean isTransactional;

    public JMSConsumerReceiveResponse(MessageImpl messageImpl, long l, boolean bl) {
        this.message = messageImpl;
        this.sequenceNumber = l;
        this.isTransactional = bl;
    }

    public final boolean isTransactional() {
        return this.isTransactional;
    }

    public final MessageImpl getMessage() {
        return this.message;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public JMSConsumerReceiveResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.isTransactional) {
            n |= 0x10000;
        }
        if (this.sequenceNumber != 0L) {
            n |= 0x20000;
        }
        if (this.message != null) {
            n |= this.message.getType() << 8;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.message != null) {
            this.message.writeExternal(objectOutput);
        }
        if (this.sequenceNumber != 0L) {
            objectOutput.writeLong(this.sequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        int n3 = n2 & 0xFF;
        if (n3 != 1) {
            throw JMSUtilities.versionIOException(n3, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n2 & 0x10000) != 0) {
            this.isTransactional = true;
        }
        if ((n = (n2 & 0xFF00) >> 8) != 0) {
            this.message = MessageImpl.createMessageImpl((byte)n);
            this.message.readExternal(objectInput);
        }
        if ((n2 & 0x20000) != 0) {
            this.sequenceNumber = objectInput.readLong();
        }
    }
}

