/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.JMSLogger;

public final class JMSDebug {
    public static final int BE = 4;
    public static final int FE = 8;
    public static final int COMMON = 16;
    public static final int CONFIG = 32;
    public static final int LOCKING = 64;
    public static final int XA = 128;
    public static final int STORE = 256;
    public static final int BOOT = 512;
    public static final int DURSUB = 1024;
    public static final int DISP = 2048;
    public static final int DIST_TOPIC = 4096;
    public static final int AME = 8192;
    public static final int MESSAGE_PATH = 16384;
    public static boolean debugDumpTolog = true;
    public static boolean debugDumpToConsole = false;
    public static boolean debugJMSBackEnd = false;
    public static boolean debugJMSFrontEnd = false;
    public static boolean debugJMSCommon = false;
    public static boolean debugJMSConfig = false;
    public static boolean debugJMSLocking = false;
    public static boolean debugJMSXA = false;
    public static boolean debugJMSStore = false;
    public static boolean debugJMSBoot = false;
    public static boolean debugJMSDurSub = false;
    public static boolean debugJMSDispatcher = false;
    public static boolean debugJMSDistTopic = false;
    public static boolean debugJMSAME = false;
    public static boolean debugJMSMessagePath = false;
    public static boolean jmsJDBCScavengeOnFlush = true;
    public static final boolean DEBUG = true;

    private static String flagToString(int n) {
        switch (n) {
            case 4: {
                return "BE ";
            }
            case 8: {
                return "FE ";
            }
            case 16: {
                return "CMN";
            }
            case 32: {
                return "CFG";
            }
            case 64: {
                return "LCK";
            }
            case 128: {
                return "XA ";
            }
            case 256: {
                return "STO";
            }
            case 512: {
                return "BT ";
            }
            case 1024: {
                return "DSB";
            }
            case 2048: {
                return "DISP";
            }
            case 4096: {
                return "DIST_TOPIC";
            }
            case 8192: {
                return "AME";
            }
            case 16384: {
                return "MSG_PATH";
            }
        }
        return "MIX" + n;
    }

    public static final void locking(String string, Object object) {
        JMSDebug.debugLocking(string + " : locking " + object);
    }

    public static final void locked(String string, Object object) {
        JMSDebug.debugLocking(string + " : locked " + object);
    }

    public static final void unlocked(String string, Object object) {
        JMSDebug.debugLocking(string + " : unlocked " + object);
    }

    private static final void debugLocking(String string) {
        if (debugJMSLocking) {
            if (debugDumpTolog) {
                JMSLogger.logDebugMsg("LCK!" + Thread.currentThread().getName() + ": " + string);
            }
            if (debugDumpToConsole) {
                System.out.println("LCK!" + Thread.currentThread().getName() + ": " + string);
            }
        }
    }

    public static final void debug(int n, String string) {
        if (debugDumpTolog) {
            JMSLogger.logDebugMsg(JMSDebug.flagToString(n) + "! " + string);
        }
        if (debugDumpToConsole) {
            System.out.println(JMSDebug.flagToString(n) + "!" + string);
        }
    }

    public static final void debug(int n, String string, Throwable throwable) {
        if (debugDumpTolog) {
            JMSLogger.logDebugMsgTrace(JMSDebug.flagToString(n) + "!" + string, throwable);
        }
        if (debugDumpToConsole) {
            System.out.println(JMSDebug.flagToString(n) + "!" + string);
            throwable.printStackTrace();
        }
    }
}

