/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSUtilities;

public final class JMSMessageId
implements Externalizable {
    private static final byte MINVERSION = 1;
    private static final byte WL60_VERSION = 1;
    private static final byte WL61_VERSION = 11;
    private static final byte WL81_VERSION = 12;
    private static final byte MAXVERSION = 12;
    private static final int VERSION_MASK = 63;
    private static final int HAS_DIFFERENTIATOR = 64;
    static final long serialVersionUID = 3784286757441851850L;
    private int seed;
    private long timestamp;
    private int counter;
    private int differentiator;

    public JMSMessageId(int n, long l, int n2, long l2) {
        this.seed = n;
        this.timestamp = l;
        this.counter = n2;
    }

    public JMSMessageId(JMSMessageId jMSMessageId, int n) {
        this.seed = jMSMessageId.seed;
        this.timestamp = jMSMessageId.timestamp;
        this.counter = jMSMessageId.counter;
        this.differentiator = n;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getDifferentiator() {
        return this.differentiator;
    }

    public JMSMessageId() {
    }

    private int getStreamVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()).compareTo(PeerInfo.VERSION_81) < 0) {
            return 11;
        }
        return 12;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getStreamVersion(objectOutput);
        if (n >= 12 && this.differentiator != 0) {
            n |= 0x40;
        }
        objectOutput.writeByte((byte)n);
        objectOutput.writeLong(this.timestamp);
        objectOutput.writeInt(this.counter);
        objectOutput.writeInt(this.seed);
        if ((n & 0x40) != 0) {
            objectOutput.writeInt(this.differentiator);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        int n = by & 0x3F;
        if (n == 12 || n == 11) {
            this.timestamp = objectInput.readLong();
            this.counter = objectInput.readInt();
            this.seed = objectInput.readInt();
            if ((by & 0x40) != 0) {
                this.differentiator = objectInput.readInt();
            }
        } else if (n == 1) {
            this.timestamp = objectInput.readLong();
            this.counter = objectInput.readInt();
            objectInput.readInt();
            this.seed = objectInput.readInt();
        } else {
            throw JMSUtilities.versionIOException(n, 1, 12);
        }
    }

    public boolean equals(Object object) {
        JMSMessageId jMSMessageId = (JMSMessageId)object;
        return this.timestamp == jMSMessageId.timestamp && this.counter == jMSMessageId.counter && this.seed == jMSMessageId.seed;
    }

    public boolean differentiatedEquals(Object object) {
        return this.equals(object) && this.differentiator == ((JMSMessageId)object).differentiator;
    }

    public int compare(JMSMessageId jMSMessageId) {
        if (this.timestamp > jMSMessageId.timestamp) {
            return 1;
        }
        if (this.timestamp < jMSMessageId.timestamp) {
            return -1;
        }
        if (this.counter > jMSMessageId.counter) {
            return 1;
        }
        if (this.counter < jMSMessageId.counter) {
            return -1;
        }
        if (this.seed > jMSMessageId.seed) {
            return 1;
        }
        if (this.seed < jMSMessageId.seed) {
            return -1;
        }
        if (this.differentiator > jMSMessageId.differentiator) {
            return 1;
        }
        if (this.differentiator < jMSMessageId.differentiator) {
            return -1;
        }
        return 0;
    }

    public int compareTime(JMSMessageId jMSMessageId) {
        if (this.timestamp < jMSMessageId.timestamp) {
            return -1;
        }
        if (this.timestamp > jMSMessageId.timestamp) {
            return 1;
        }
        if (this.counter < jMSMessageId.counter) {
            return -1;
        }
        if (this.counter > jMSMessageId.counter) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "<" + this.seed + "." + this.timestamp + "." + this.counter + ">";
    }

    public int hashCode() {
        return (int)((long)this.seed ^ this.timestamp ^ (long)this.counter);
    }

    public int differentiatedHashCode() {
        return this.hashCode() ^ this.differentiator;
    }
}

