/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Dispatcher;

public final class JMSPushEntry
implements Externalizable {
    static final long serialVersionUID = -632448292622511345L;
    public static final int EXTVERSION = 1;
    public static final int VERSION_MASK = 255;
    public static final int NEXT_MASK = 256;
    public static final int REDELIVERED_MASK = 512;
    public static final int SEQUENCER_ID_MASK = 1024;
    public static final int BACK_END_MASK = 2048;
    public static final int FRONT_END_MASK = 4096;
    public static final int CLIENTRESPONSIBLEFORACKNOWLEDGE = 8192;
    private transient JMSPushEntry next;
    private transient JMSPushEntry nextUnacked;
    private transient JMSPushEntry prevUnacked;
    private transient Dispatcher dispatcher;
    private transient long messageSize;
    private JMSID sequencerId;
    private JMSID consumerId;
    private long backEndSequenceNumber;
    private long frontEndSequenceNumber;
    private boolean redelivered;
    private boolean clientResponsibleForAcknowledge = false;

    public JMSPushEntry(JMSID jMSID, JMSID jMSID2, long l, long l2, boolean bl) {
        this.sequencerId = jMSID;
        this.consumerId = jMSID2;
        this.backEndSequenceNumber = l;
        this.frontEndSequenceNumber = l2;
        this.redelivered = bl;
    }

    public final JMSID getSequencerId() {
        return this.sequencerId;
    }

    public final JMSID getConsumerId() {
        return this.consumerId;
    }

    public final long getFrontEndSequenceNumber() {
        return this.frontEndSequenceNumber;
    }

    public final void setFrontEndSequenceNumber(long l) {
        this.frontEndSequenceNumber = l;
    }

    public final long getBackEndSequenceNumber() {
        return this.backEndSequenceNumber;
    }

    public final void setBackEndSequenceNumber(long l) {
        this.backEndSequenceNumber = l;
    }

    public final long getMessageSize() {
        return this.messageSize;
    }

    public final void setMessageSize(long l) {
        this.messageSize = l;
    }

    public final boolean getRedelivered() {
        return this.redelivered;
    }

    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public final void setClientResponsibleForAcknowledge(boolean bl) {
        this.clientResponsibleForAcknowledge = bl;
    }

    public final JMSPushEntry getNext() {
        return this.next;
    }

    public final void setNext(JMSPushEntry jMSPushEntry) {
        this.next = jMSPushEntry;
    }

    public final JMSPushEntry getNextUnacked() {
        return this.nextUnacked;
    }

    public final void setNextUnacked(JMSPushEntry jMSPushEntry) {
        this.nextUnacked = jMSPushEntry;
    }

    public final JMSPushEntry getPrevUnacked() {
        return this.prevUnacked;
    }

    public final void setPrevUnacked(JMSPushEntry jMSPushEntry) {
        this.prevUnacked = jMSPushEntry;
    }

    public final void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public JMSPushEntry() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal(objectOutput, null);
    }

    public void writeExternal(ObjectOutput objectOutput, JMSPushRequest jMSPushRequest) throws IOException {
        int n = 1;
        JMSPushEntry jMSPushEntry = this;
        JMSID jMSID = null;
        if (jMSPushRequest == null) {
            n |= 0x1800;
        } else if (jMSPushRequest.getMethodId() == 15620) {
            n |= 0x1000;
        } else {
            jMSID = jMSPushRequest.getInvocableId();
            n |= 0x800;
        }
        do {
            n &= 0xFFFFF8FF;
            if (jMSPushEntry.next != null) {
                n |= 0x100;
            }
            if (jMSPushEntry.redelivered) {
                n |= 0x200;
            }
            if (jMSPushEntry.getClientResponsibleForAcknowledge()) {
                n |= 0x2000;
            }
            if ((n & 0x800) != 0 && jMSPushEntry.sequencerId != jMSID) {
                n |= 0x400;
                jMSID = this.sequencerId;
            }
            objectOutput.writeInt(n);
            if ((n & 0x400) != 0) {
                jMSPushEntry.sequencerId.writeExternal(objectOutput);
            }
            if ((n & 0x800) != 0) {
                objectOutput.writeLong(jMSPushEntry.backEndSequenceNumber);
            }
            if ((n & 0x1000) != 0) {
                objectOutput.writeLong(jMSPushEntry.frontEndSequenceNumber);
            }
            jMSPushEntry.consumerId.writeExternal(objectOutput);
        } while ((jMSPushEntry = jMSPushEntry.next) != null);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.readExternal(objectInput, null);
    }

    JMSPushEntry readExternal(ObjectInput objectInput, JMSPushRequest jMSPushRequest) throws ClassNotFoundException, IOException {
        JMSPushEntry jMSPushEntry = null;
        JMSPushEntry jMSPushEntry2 = this;
        JMSID jMSID = jMSPushRequest.getInvocableId();
        do {
            int n;
            int n2;
            if ((n2 = (n = objectInput.readInt()) & 0xFF) != 1) {
                throw JMSUtilities.versionIOException(n2, 1, 1);
            }
            if ((n & 0x400) == 0) {
                jMSPushEntry2.sequencerId = jMSID;
            } else {
                jMSPushEntry2.sequencerId = new JMSID();
                jMSPushEntry2.sequencerId.readExternal(objectInput);
            }
            if ((n & 0x800) != 0) {
                jMSPushEntry2.backEndSequenceNumber = objectInput.readLong();
            }
            if ((n & 0x1000) != 0) {
                jMSPushEntry2.frontEndSequenceNumber = objectInput.readLong();
            }
            jMSPushEntry2.consumerId = new JMSID();
            jMSPushEntry2.consumerId.readExternal(objectInput);
            jMSPushEntry2.redelivered = (n & 0x200) != 0;
            jMSPushEntry2.setClientResponsibleForAcknowledge((n & 0x2000) != 0);
            jMSPushEntry = jMSPushEntry2;
            if ((n & 0x100) == 0) continue;
            jMSPushEntry2.next = new JMSPushEntry();
        } while ((jMSPushEntry2 = jMSPushEntry2.next) != null);
        return jMSPushEntry;
    }
}

