/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;

public final class JMSPushExceptionRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -8924769504929515114L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSException exception;

    public JMSPushExceptionRequest(int n, JMSID jMSID, JMSException jMSException) {
        super(jMSID, 0x3C00 | n);
        this.exception = jMSException;
    }

    public void setInvocableType(int n) {
        this.methodId = this.methodId & 0xFFFF00 & n;
    }

    public JMSException getException() {
        return this.exception;
    }

    public int remoteSignature() {
        return 64;
    }

    public JMSPushExceptionRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.exception);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.exception = (JMSException)objectInput.readObject();
    }
}

