/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Request;

public final class JMSPushRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -7576284721569682185L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_MASK = 65280;
    private static final int BACK_END_MASK = 65536;
    private static final int NEXT_MASK = 131072;
    private static final int MESSAGE_MASK_SHIFT = 8;
    private MessageImpl message;
    private JMSPushEntry firstPushEntry;
    private JMSPushEntry lastPushEntry;

    public JMSPushRequest(int n, JMSID jMSID, MessageImpl messageImpl) {
        super(jMSID, 0x3D00 | n);
        this.message = messageImpl;
    }

    public JMSPushRequest(int n, JMSID jMSID, MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        super(jMSID, 0x3D00 | n);
        this.message = messageImpl;
        this.firstPushEntry = jMSPushEntry;
        if (this.firstPushEntry != null) {
            for (JMSPushEntry jMSPushEntry2 = jMSPushEntry; jMSPushEntry2 != null; jMSPushEntry2 = jMSPushEntry2.getNext()) {
                this.lastPushEntry = jMSPushEntry2;
            }
        }
    }

    public JMSPushRequest(JMSPushRequest jMSPushRequest) {
        super(jMSPushRequest.invocableId, jMSPushRequest.methodId);
        this.message = jMSPushRequest.message;
        this.firstPushEntry = jMSPushRequest.firstPushEntry;
        this.lastPushEntry = jMSPushRequest.lastPushEntry;
        this.next = jMSPushRequest.next;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    public void setMessage(MessageImpl messageImpl) {
        this.message = messageImpl;
    }

    public void setInvocableType(int n) {
        this.methodId = this.methodId & 0xFFFF00 | n;
    }

    public void addPushEntry(JMSPushEntry jMSPushEntry) {
        jMSPushEntry.setNext(null);
        if (this.firstPushEntry == null) {
            this.firstPushEntry = jMSPushEntry;
        } else {
            this.lastPushEntry.setNext(jMSPushEntry);
        }
        this.lastPushEntry = jMSPushEntry;
    }

    public JMSPushEntry removePushEntry() {
        JMSPushEntry jMSPushEntry = this.firstPushEntry;
        if (jMSPushEntry != null) {
            this.firstPushEntry = jMSPushEntry.getNext();
            if (this.firstPushEntry == null) {
                this.lastPushEntry = null;
            }
        }
        return jMSPushEntry;
    }

    public long getBackEndSequenceNumber() {
        return this.firstPushEntry.getBackEndSequenceNumber();
    }

    public long getFrontEndSequenceNumber() {
        return this.firstPushEntry.getFrontEndSequenceNumber();
    }

    public void setFirstPushEntry(JMSPushEntry jMSPushEntry) {
        this.firstPushEntry = jMSPushEntry;
    }

    public JMSPushEntry getFirstPushEntry() {
        return this.firstPushEntry;
    }

    public void setLastPushEntry(JMSPushEntry jMSPushEntry) {
        this.lastPushEntry = jMSPushEntry;
    }

    public JMSPushEntry getLastPushEntry() {
        return this.lastPushEntry;
    }

    public final JMSPushEntry getPushEntries() {
        return this.firstPushEntry;
    }

    public final void setPushEntries(JMSPushEntry jMSPushEntry) {
        this.firstPushEntry = jMSPushEntry;
        if (this.firstPushEntry == null) {
            this.lastPushEntry = null;
        } else {
            this.lastPushEntry = jMSPushEntry;
            while (this.lastPushEntry.getNext() != null) {
                this.lastPushEntry = this.lastPushEntry.getNext();
            }
        }
    }

    public int remoteSignature() {
        return 64;
    }

    public JMSPushRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        JMSPushRequest jMSPushRequest = this;
        do {
            int n = jMSPushRequest.message.getType() << 8;
            if (jMSPushRequest.getNext() != null) {
                n |= 0x20000;
            }
            objectOutput.writeInt(n | 1);
            super.writeExternal(objectOutput);
            jMSPushRequest.message.writeExternal(objectOutput);
            jMSPushRequest.firstPushEntry.writeExternal(objectOutput, this);
        } while ((jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) != null);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        JMSPushRequest jMSPushRequest = this;
        do {
            int n;
            int n2;
            if ((n2 = (n = objectInput.readInt()) & 0xFF) != 1) {
                throw JMSUtilities.versionIOException(n2, 1, 1);
            }
            super.readExternal(objectInput);
            byte by = (byte)((n & 0xFF00) >>> 8);
            jMSPushRequest.message = MessageImpl.createMessageImpl(by);
            jMSPushRequest.message.readExternal(objectInput);
            jMSPushRequest.firstPushEntry = new JMSPushEntry();
            jMSPushRequest.lastPushEntry = jMSPushRequest.firstPushEntry.readExternal(objectInput, jMSPushRequest);
            if ((n & 0x20000) == 0) continue;
            jMSPushRequest.setNext(new JMSPushRequest());
        } while ((jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) != null);
    }
}

