/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class JMSSessionRecoverResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -7983006155010336377L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private long sequenceNumber;

    public JMSSessionRecoverResponse(long l) {
        this.sequenceNumber = l;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public JMSSessionRecoverResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.sequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.sequenceNumber = objectInput.readLong();
    }
}

