/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Message;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.MessageFormatException;

public final class JMSUtilities {
    public static final String RESERVED_ROLLBACK_ONLY = "ReservedRollbackOnly";
    private static final int MAXUTFLENGTH = 65535;
    private static final short TYPENULL = 99;
    private static final short TYPESTRING = 102;
    private static final short TYPEBOOLEAN = 103;
    private static final short TYPEINTEGER = 104;
    private static final short TYPELONG = 105;
    private static final short TYPEBYTE = 106;
    private static final short TYPESHORT = 107;
    private static final short TYPEFLOAT = 108;
    private static final short TYPEDOUBLE = 109;
    private static final short TYPECHARACTER = 110;
    private static final short TYPEBYTEARRAY = 111;
    private static final short TYPEBIGSTRING = 112;
    public static final int MESSAGE_MASK = 256;
    public static final int BYTESMSG_MASK = 512;
    public static final int HDRMSG_MASK = 1024;
    public static final int MAPMSG_MASK = 2048;
    public static final int OBJMSG_MASK = 4096;
    public static final int STRMMSG_MASK = 8192;
    public static final int TXTMSG_MASK = 16384;
    public static final int XMLMSG_MASK = 32768;

    public static javax.jms.JMSException jmsException(String string, Exception exception) {
        return JMSUtilities.jmsExceptionThrowable(string, exception);
    }

    public static javax.jms.JMSException jmsExceptionThrowable(String string, Throwable throwable) {
        if (JMSDebug.debugJMSCommon) {
            JMSDebug.debug(16, string, throwable);
        }
        if (throwable instanceof javax.jms.JMSException) {
            return (javax.jms.JMSException)throwable;
        }
        JMSException jMSException = new JMSException(string, throwable);
        return jMSException;
    }

    public static javax.jms.JMSException jmsExceptionObject(String string, Object object) {
        if (!(object instanceof Throwable)) {
            JMSException jMSException = new JMSException("Unexpected return type, non-exception object=" + string + " " + object);
            if (JMSDebug.debugJMSCommon) {
                JMSDebug.debug(16, "something happened", jMSException);
            }
            return jMSException;
        }
        return JMSUtilities.jmsExceptionThrowable(string, (Throwable)object);
    }

    public static MessageFormatException messageFormatException(String string, Exception exception) {
        MessageFormatException messageFormatException = new MessageFormatException(string, exception);
        return messageFormatException;
    }

    public static StreamCorruptedException versionIOException(int n, int n2, int n3) {
        return new StreamCorruptedException("Unsupported class version " + n + "." + "  Expected a value between " + n2 + " and " + n3 + " inclusive." + (n > n2 ? "  Possible attempt to access newer JMS version then current version." : "  Possible attempt to access unsupported older JMS version."));
    }

    public static boolean getTracing(Message message) {
        return true;
    }

    public static void setTracing(Message message, boolean bl) {
        try {
            message.setBooleanProperty("tracing", bl);
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
    }

    static final int writeBasicMap(ObjectOutput objectOutput, Map map, PeerInfo peerInfo, boolean bl) throws IOException {
        Map.Entry entry;
        Iterator iterator;
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        if (peerInfo != null) {
            bl2 = peerInfo.compareTo(PeerInfo.VERSION_612) <= 0;
            boolean bl4 = bl3 = bl && peerInfo.compareTo(PeerInfo.VERSION_701) >= 0;
        }
        if (!bl2) {
            n = map.size();
        } else {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getValue() == null) continue;
                ++n;
            }
        }
        objectOutput.writeInt(n);
        n = 0;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (bl2 && entry.getValue() == null) continue;
            n += JMSUtilities.writeBasicType(objectOutput, entry.getKey(), false);
            n += JMSUtilities.writeBasicType(objectOutput, entry.getValue(), bl3);
        }
        return n;
    }

    static final HashMap readBasicMap(ObjectInput objectInput, PeerInfo peerInfo) throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = objectInput.readInt();
        while (n-- > 0) {
            Object object = JMSUtilities.readBasicType(objectInput);
            Object object2 = JMSUtilities.readBasicType(objectInput);
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    static final int calcObjectSize(Object object) {
        if (object == null) {
            return 2;
        }
        if (object instanceof Integer) {
            return 6;
        }
        if (object instanceof String) {
            return 4 + (((String)object).length() << 2);
        }
        if (object instanceof Long) {
            return 10;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof Byte) {
            return 3;
        }
        if (object instanceof Short) {
            return 4;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 10;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length + 6;
        }
        return 0;
    }

    private static final int writeBasicType(ObjectOutput objectOutput, Object object, boolean bl) throws IOException {
        if (object == null) {
            objectOutput.writeShort(99);
            return 2;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            int n2 = JMSUtilities.getUTFLength(string);
            if (n2 != -1) {
                objectOutput.writeShort(102);
                JMSUtilities.writeUTF(objectOutput, string, n2);
            } else if (bl) {
                objectOutput.writeShort(112);
                objectOutput.writeObject(string);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((n << 2) + 50);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(string);
                return JMSUtilities.writeBasicType(objectOutput, byteArrayOutputStream.toByteArray(), bl);
            }
            return 4 + (n << 2);
        }
        if (object instanceof Integer) {
            objectOutput.writeShort(104);
            objectOutput.writeInt((Integer)object);
            return 6;
        }
        if (object instanceof Long) {
            objectOutput.writeShort(105);
            objectOutput.writeLong((Long)object);
            return 10;
        }
        if (object instanceof byte[]) {
            objectOutput.writeShort(111);
            objectOutput.writeInt(((byte[])object).length);
            objectOutput.write((byte[])object);
            return 6 + ((byte[])object).length;
        }
        if (object instanceof Boolean) {
            objectOutput.writeShort(103);
            objectOutput.writeBoolean((Boolean)object);
            return 3;
        }
        if (object instanceof Byte) {
            objectOutput.writeShort(106);
            objectOutput.writeByte(((Byte)object).byteValue());
            return 3;
        }
        if (object instanceof Short) {
            objectOutput.writeShort(107);
            objectOutput.writeShort(((Short)object).shortValue());
            return 4;
        }
        if (object instanceof Float) {
            objectOutput.writeShort(108);
            objectOutput.writeFloat(((Float)object).floatValue());
            return 6;
        }
        if (object instanceof Double) {
            objectOutput.writeShort(109);
            objectOutput.writeDouble((Double)object);
            return 10;
        }
        if (object instanceof Character) {
            objectOutput.writeShort(110);
            objectOutput.writeChar(((Character)object).charValue());
            return 4;
        }
        throw new StreamCorruptedException("Could not write object, expected simple type, but class named " + object.getClass().getName());
    }

    private static final Object readBasicType(ObjectInput objectInput) throws IOException {
        short s = objectInput.readShort();
        switch (s) {
            case 99: {
                return null;
            }
            case 102: {
                return DataInputStream.readUTF(objectInput);
            }
            case 112: {
                try {
                    return new String((String)objectInput.readObject());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IOException(classNotFoundException.toString());
                }
            }
            case 103: {
                return new Boolean(objectInput.readBoolean());
            }
            case 104: {
                return new Integer(objectInput.readInt());
            }
            case 105: {
                return new Long(objectInput.readLong());
            }
            case 106: {
                return new Byte(objectInput.readByte());
            }
            case 111: {
                byte[] byArray = new byte[objectInput.readInt()];
                objectInput.readFully(byArray);
                return byArray;
            }
            case 107: {
                return new Short(objectInput.readShort());
            }
            case 108: {
                return new Float(objectInput.readFloat());
            }
            case 109: {
                return new Double(objectInput.readDouble());
            }
            case 110: {
                return new Character(objectInput.readChar());
            }
        }
        throw new StreamCorruptedException("Could not read object, unrecognized class code " + s);
    }

    private static int getUTFLength(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        if (n > 65535) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            return -1;
        }
        return n2;
    }

    private static void writeUTF(ObjectOutput objectOutput, String string, int n) throws IOException {
        if (n > 65535) {
            throw new UTFDataFormatException();
        }
        objectOutput.write(n >>> 8 & 0xFF);
        objectOutput.write(n >>> 0 & 0xFF);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                objectOutput.write(c);
                continue;
            }
            if (c > '\u07ff') {
                objectOutput.write(0xE0 | c >> 12 & 0xF);
                objectOutput.write(0x80 | c >> 6 & 0x3F);
                objectOutput.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            objectOutput.write(0xC0 | c >> 6 & 0x1F);
            objectOutput.write(0x80 | c >> 0 & 0x3F);
        }
    }
}

